/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.google.common.primitives.Longs;
import java.math.BigInteger;
import java.util.List;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormula;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

public class BoolectorFormulaCreator
extends FormulaCreator<Long, Long, Long, Long> {
    private static final char ARBITRARY_VALUE = '1';
    private final Table<String, Long, Long> nameFormulaCache = HashBasedTable.create();

    BoolectorFormulaCreator(Long btor) {
        super(btor, BtorJNI.boolector_bool_sort(btor), null, null);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof BitvectorFormula) {
            long sort = BtorJNI.boolector_get_sort((Long)this.getEnv(), this.extractInfo(pFormula));
            Preconditions.checkArgument((boolean)BtorJNI.boolector_is_bitvec_sort((Long)this.getEnv(), sort), (String)"BitvectorFormula with type missmatch: %s", pFormula);
            return FormulaType.getBitvectorTypeWithSize(BtorJNI.boolector_get_width((Long)this.getEnv(), this.extractInfo(pFormula)));
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public Long extractInfo(Formula pT) {
        return BoolectorFormulaManager.getBtorTerm(pT);
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long sort = BtorJNI.boolector_get_sort((Long)this.getEnv(), pFormula);
        if (BtorJNI.boolector_is_bitvec_sort((Long)this.getEnv(), sort)) {
            if (sort == 1L) {
                return FormulaType.BooleanType;
            }
            return FormulaType.getBitvectorTypeWithSize(BtorJNI.boolector_get_width((Long)this.getEnv(), pFormula));
        }
        if (BtorJNI.boolector_is_array_sort((Long)this.getEnv(), sort)) {
            int indexWidth = BtorJNI.boolector_get_index_width((Long)this.getEnv(), pFormula);
            int elementWidth = BtorJNI.boolector_get_width((Long)this.getEnv(), pFormula);
            return FormulaType.getArrayType(FormulaType.getBitvectorTypeWithSize(indexWidth), FormulaType.getBitvectorTypeWithSize(elementWidth));
        }
        throw new IllegalArgumentException("Unknown formula type for " + pFormula);
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm))) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new BoolectorFormula.BoolectorBooleanFormula(pTerm, (Long)this.getEnv());
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new BoolectorFormula.BoolectorArrayFormula(pTerm, arrFt.getIndexType(), arrFt.getElementType(), (Long)this.getEnv());
        }
        if (pType.isBitvectorType()) {
            return (T)new BoolectorFormula.BoolectorBitvectorFormula(pTerm, (Long)this.getEnv());
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in Boolector.");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType()) : "Unexpected formula type for Boolean formula: " + this.getFormulaType(pTerm);
        return new BoolectorFormula.BoolectorBooleanFormula(pTerm, (Long)this.getEnv());
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType()) : "Unexpected formula type for BV formula: " + this.getFormulaType(pTerm);
        return new BoolectorFormula.BoolectorBitvectorFormula(pTerm, (Long)this.getEnv());
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(Long pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).isArrayType()) : "Unexpected formula type for array formula: " + this.getFormulaType(pTerm);
        return new BoolectorFormula.BoolectorArrayFormula<TI, TE>(pTerm, pIndexType, pElementType, (Long)this.getEnv());
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        return BtorJNI.boolector_bitvec_sort((Long)this.getEnv(), pBitwidth);
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType pType) {
        throw new UnsupportedOperationException("Boolector does not support floating point operations.");
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        return BtorJNI.boolector_array_sort((Long)this.getEnv(), pIndexType, pElementType);
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        Long maybeFormula = (Long)this.nameFormulaCache.get((Object)varName, (Object)type);
        if (maybeFormula != null) {
            return maybeFormula;
        }
        if (this.nameFormulaCache.containsRow((Object)varName)) {
            throw new IllegalArgumentException("Symbol already used: " + varName);
        }
        long newVar = BtorJNI.boolector_var((Long)this.getEnv(), type, varName);
        this.nameFormulaCache.put((Object)varName, (Object)type, (Object)newVar);
        return newVar;
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Long f) {
        throw new UnsupportedOperationException("Boolector has no methods to access internal nodes for visitation.");
    }

    private <R> R visit1(FormulaVisitor<R> visitor, Formula formula, Long f) {
        if (BtorJNI.boolector_is_const((Long)this.getEnv(), f)) {
            String bits = BtorJNI.boolector_get_bits((Long)this.getEnv(), f);
            return visitor.visitConstant(formula, this.convertValue(f, this.parseBitvector(bits)));
        }
        if (BtorJNI.boolector_is_param((Long)this.getEnv(), f)) {
            int deBruijnIdx = 0;
            return visitor.visitBoundVariable(formula, deBruijnIdx);
        }
        if (BtorJNI.boolector_is_var((Long)this.getEnv(), f)) {
            return visitor.visitFreeVariable(formula, this.getName(f));
        }
        ImmutableList.Builder args = ImmutableList.builder();
        ImmutableList.Builder argTypes = ImmutableList.builder();
        return visitor.visitFunction(formula, (List<Formula>)args.build(), FunctionDeclarationImpl.of(this.getName(f), this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), f));
    }

    private FunctionDeclarationKind getDeclarationKind(long f) {
        return null;
    }

    @Override
    public Long callFunctionImpl(Long pDeclaration, List<Long> pArgs) {
        Preconditions.checkArgument((!pArgs.isEmpty() ? 1 : 0) != 0, (Object)"Boolector does not support UFs without arguments.");
        return BtorJNI.boolector_apply((Long)this.getEnv(), Longs.toArray(pArgs), pArgs.size(), pDeclaration);
    }

    @Override
    public Long declareUFImpl(String name, Long pReturnType, List<Long> pArgTypes) {
        Preconditions.checkArgument((!pArgTypes.isEmpty() ? 1 : 0) != 0, (Object)"Boolector does not support UFs without arguments.");
        long[] funSorts = Longs.toArray(pArgTypes);
        long sort = BtorJNI.boolector_fun_sort((Long)this.getEnv(), funSorts, funSorts.length, pReturnType);
        Long maybeFormula = (Long)this.nameFormulaCache.get((Object)name, (Object)sort);
        if (maybeFormula != null) {
            return maybeFormula;
        }
        if (this.nameFormulaCache.containsRow((Object)name)) {
            throw new IllegalArgumentException("Symbol already used: " + name);
        }
        long uf = BtorJNI.boolector_uf((Long)this.getEnv(), sort, name);
        this.nameFormulaCache.put((Object)name, (Object)sort, (Object)uf);
        return uf;
    }

    @Override
    public Object convertValue(Long key, Long term) {
        String value;
        if (BtorJNI.boolector_is_array((Long)this.getEnv(), term)) {
            value = BtorJNI.boolector_bv_assignment((Long)this.getEnv(), term);
        } else if (BtorJNI.boolector_is_const((Long)this.getEnv(), term)) {
            value = BtorJNI.boolector_get_bits((Long)this.getEnv(), term);
        } else if (BtorJNI.boolector_is_bitvec_sort((Long)this.getEnv(), BtorJNI.boolector_get_sort((Long)this.getEnv(), term))) {
            value = BtorJNI.boolector_bv_assignment((Long)this.getEnv(), term);
        } else {
            throw new AssertionError((Object)"unknown sort and term");
        }
        int width = BtorJNI.boolector_get_width((Long)this.getEnv(), term);
        if (width == 1) {
            long longValue = this.parseBigInt(value).longValue();
            if (longValue == 1L) {
                return true;
            }
            if (longValue == 0L) {
                return false;
            }
            throw new IllegalArgumentException("Unexpected type with value: " + value);
        }
        return this.parseBigInt(value);
    }

    private BigInteger parseBigInt(String assignment) {
        try {
            BigInteger bigInt = new BigInteger(assignment, 2);
            return bigInt;
        }
        catch (NumberFormatException e) {
            char[] charArray = assignment.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                if (charArray[i] == 'x') {
                    charArray[i] = 49;
                    continue;
                }
                if (charArray[i] == '0' || charArray[i] == '1') continue;
                throw new IllegalArgumentException("Boolector gave back an assignment that is not parseable.");
            }
            assignment = String.valueOf(charArray);
            return new BigInteger(assignment, 2);
        }
    }

    private Long parseBitvector(String bitVec) {
        try {
            BigInteger bigInt = new BigInteger(bitVec, 2);
            return bigInt.longValue();
        }
        catch (NumberFormatException e) {
            char[] charArray = bitVec.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                if (charArray[i] == 'x') {
                    charArray[i] = 49;
                    continue;
                }
                if (charArray[i] == '0' || charArray[i] == '1') continue;
                throw new IllegalArgumentException("Boolector gave back an assignment that is not parseable.");
            }
            bitVec = String.valueOf(charArray);
            BigInteger bigInt = new BigInteger(bitVec, 2);
            return bigInt.longValue();
        }
    }

    String getName(long pKey) {
        return BtorJNI.boolector_get_symbol((Long)this.getEnv(), pKey);
    }

    @Override
    public Object convertValue(Long pF) {
        throw new UnsupportedOperationException("Please use the other method.");
    }

    @Override
    protected Long getBooleanVarDeclarationImpl(Long pTFormulaInfo) {
        if (BtorJNI.boolector_is_const((Long)this.getEnv(), pTFormulaInfo)) {
            return this.parseBitvector(BtorJNI.boolector_get_bits((Long)this.getEnv(), pTFormulaInfo));
        }
        if (BtorJNI.boolector_is_var((Long)this.getEnv(), pTFormulaInfo)) {
            return this.parseBitvector(BtorJNI.boolector_bv_assignment((Long)this.getEnv(), pTFormulaInfo));
        }
        throw new IllegalArgumentException("Debug only! getBooleanVarDeclarationImpl in BtorFormulaCreator");
    }

    protected Table<String, Long, Long> getCache() {
        return this.nameFormulaCache;
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((BoolectorFormula.BoolectorArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((BoolectorFormula.BoolectorArrayFormula)pArray).getIndexType();
    }
}

