/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.ImmutableList;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class OptimizationFormulaWeights {
    private OptimizationFormulaWeights() {
    }

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormulaManager bmgr = context.getFormulaManager().getBooleanFormulaManager();
            IntegerFormulaManager imgr = context.getFormulaManager().getIntegerFormulaManager();
            OptimizationFormulaWeights.optimizeWithWeights(prover, bmgr, imgr, logger);
        }
        catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
            logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
        }
        catch (UnsupportedOperationException e) {
            logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
        }
    }

    private static void optimizeWithWeights(OptimizationProverEnvironment prover, BooleanFormulaManager bmgr, IntegerFormulaManager imgr, LogManager logger) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)imgr.makeVariable("z");
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)imgr.makeNumber(4L);
        NumeralFormula.IntegerFormula ten = (NumeralFormula.IntegerFormula)imgr.makeNumber(10L);
        NumeralFormula.IntegerFormula scoreBasic = (NumeralFormula.IntegerFormula)imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula scoreLow = (NumeralFormula.IntegerFormula)imgr.makeNumber(2L);
        NumeralFormula.IntegerFormula scoreMedium = (NumeralFormula.IntegerFormula)imgr.makeNumber(4L);
        NumeralFormula.IntegerFormula scoreHigh = (NumeralFormula.IntegerFormula)imgr.makeNumber(10L);
        prover.addConstraint(bmgr.and(imgr.lessOrEquals(x, ten), imgr.lessOrEquals(y, ten), imgr.lessOrEquals(z, ten), imgr.equal(ten, (NumeralFormula.IntegerFormula)imgr.add(x, (NumeralFormula.IntegerFormula)imgr.add(y, z)))));
        ImmutableList weights = ImmutableList.of((Object)bmgr.ifThenElse(imgr.lessOrEquals(x, zero), scoreHigh, scoreBasic), (Object)bmgr.ifThenElse(imgr.lessOrEquals(x, four), scoreHigh, scoreBasic), (Object)bmgr.ifThenElse(imgr.lessOrEquals(y, zero), scoreMedium, scoreBasic), (Object)bmgr.ifThenElse(imgr.lessOrEquals(y, four), scoreMedium, scoreBasic), (Object)bmgr.ifThenElse(imgr.lessOrEquals(z, zero), scoreLow, scoreBasic), (Object)bmgr.ifThenElse(imgr.lessOrEquals(z, four), scoreHigh, scoreBasic));
        int handle = prover.maximize((Formula)imgr.sum(weights));
        OptimizationProverEnvironment.OptStatus response = prover.check();
        assert (response == OptimizationProverEnvironment.OptStatus.OPT);
        try (Model model = prover.getModel();){
            logger.log(Level.INFO, new Object[]{"maximal sum ", prover.upper(handle, Rational.ZERO).orElseThrow(), "with model", model});
        }
    }
}

