/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.UFManager;

public class Bug216 {
    private Configuration config;
    private LogManager logger;
    private ShutdownNotifier notifier;
    private SolverContext context;

    @Before
    public void init() throws InvalidConfigurationException {
        this.config = Configuration.defaultConfiguration();
        this.logger = BasicLogManager.create((Configuration)this.config);
        this.notifier = ShutdownNotifier.createDummy();
    }

    @After
    public final void closeSolver() {
        if (this.context != null) {
            this.context.close();
        }
    }

    @Test
    public void princessSudokuTest() throws InvalidConfigurationException, InterruptedException, SolverException {
        System.out.println("Started test for Princess");
        this.testParsing(SolverContextFactory.Solvers.PRINCESS);
        System.out.println("Finished test for Princess");
    }

    @Test
    public void z3SudokuTest() throws InvalidConfigurationException, InterruptedException, SolverException {
        System.out.println("Started test for Z3");
        this.testParsing(SolverContextFactory.Solvers.Z3);
        System.out.println("Finished test for Z3");
    }

    @Test
    public void mathsatSudokuTest() throws InvalidConfigurationException, InterruptedException, SolverException {
        System.out.println("Started test for MathSat5");
        this.testParsing(SolverContextFactory.Solvers.MATHSAT5);
        System.out.println("Finished test for MathSat5");
    }

    private void testParsing(SolverContextFactory.Solvers solver) throws InvalidConfigurationException, InterruptedException, SolverException {
        this.context = SolverContextFactory.createSolverContext(this.config, this.logger, this.notifier, solver);
        FormulaManager fmgr = this.context.getFormulaManager();
        UFManager ufmgr = fmgr.getUFManager();
        String symbol = "$main_inv1";
        System.out.println(String.format("Created function '%s'", symbol));
        FormulaType<BooleanFormula> returnType = FormulaType.BooleanType;
        ArrayList args = Lists.newArrayList((Object[])new FormulaType[]{FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType});
        FunctionDeclaration<BooleanFormula> res = ufmgr.declareUF(symbol, returnType, args);
        System.out.println(res);
        String definition = "(declare-fun $main_inv1 (Int Int Int) Bool)";
        String formula = "(assert(forall ((n5 Int) (x6 Int) (y7 Int))(=> (and (> x6 0)($main_inv1 n5 x6 y7))($main_inv1 n5 (- x6 1) (+ y7 1)))))";
        String definition2 = "(declare-fun p () Bool)";
        BooleanFormula p = fmgr.getBooleanFormulaManager().makeVariable("p");
        String formula2 = "(assert (and p (not p)))";
        BooleanFormula f = fmgr.parse(formula2);
        System.out.println(f);
    }
}

