/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class AllSatExample {
    private final BooleanFormulaManager bfmgr;
    private final IntegerFormulaManager ifmgr;
    private final ProverEnvironment prover;
    private final SolverContext context;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        for (SolverContextFactory.Solvers solver : SolverContextFactory.Solvers.values()) {
            try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
                 ProverEnvironment prover = context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_ALL_SAT);){
                System.out.println("\nUsing solver " + solver + " in version " + context.getVersion());
                AllSatExample ase = new AllSatExample(context, prover);
                prover.push();
                System.out.println(ase.allSatBooleans1());
                prover.pop();
                prover.push();
                System.out.println(ase.allSatBooleans2());
                prover.pop();
                prover.push();
                System.out.println(ase.allSatIntegers());
                prover.pop();
                prover.push();
                System.out.println(ase.allSatIntegers2());
                prover.pop();
            }
            catch (UnsatisfiedLinkError | InvalidConfigurationException e) {
                logger.logUserException(Level.INFO, e, "Solver " + solver + " is not available.");
            }
            catch (UnsupportedOperationException e) {
                logger.logUserException(Level.INFO, (Throwable)e, e.getMessage());
            }
        }
    }

    public AllSatExample(SolverContext pContext, ProverEnvironment pProver) {
        this.bfmgr = pContext.getFormulaManager().getBooleanFormulaManager();
        this.ifmgr = pContext.getFormulaManager().getIntegerFormulaManager();
        this.prover = pProver;
        this.context = pContext;
    }

    private List<List<BooleanFormula>> allSatBooleans1() throws InterruptedException, SolverException {
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.bfmgr.implication(p, q));
        return this.prover.allSat(new BasicProverEnvironment.AllSatCallback<List<List<BooleanFormula>>>(){
            List<List<BooleanFormula>> models = new ArrayList<List<BooleanFormula>>();

            @Override
            public void apply(List<BooleanFormula> pModel) {
                this.models.add(pModel);
            }

            @Override
            public List<List<BooleanFormula>> getResult() {
                return this.models;
            }
        }, (List<BooleanFormula>)ImmutableList.of((Object)q, (Object)p));
    }

    private List<List<Model.ValueAssignment>> allSatBooleans2() throws InterruptedException, SolverException {
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.bfmgr.implication(p, q));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            models.add((List<Model.ValueAssignment>)this.prover.getModelAssignments());
            Model model = this.prover.getModel();
            try {
                Boolean valueP;
                ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
                Boolean valueQ = model.evaluate(q);
                if (valueQ != null) {
                    assignments.add(this.bfmgr.equivalence(q, this.bfmgr.makeBoolean(valueQ)));
                }
                if ((valueP = model.evaluate(p)) != null) {
                    assignments.add(this.bfmgr.equivalence(p, this.bfmgr.makeBoolean(valueP)));
                }
                this.prover.addConstraint(this.bfmgr.not(this.bfmgr.and(assignments)));
            }
            finally {
                if (model == null) continue;
                model.close();
            }
        }
        return models;
    }

    private List<List<Model.ValueAssignment>> allSatIntegers() throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("b");
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), a));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(a, this.num(10)));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), b));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(b, this.num(10)));
        this.prover.addConstraint(this.ifmgr.greaterOrEquals(a, (NumeralFormula.IntegerFormula)this.ifmgr.multiply(this.num(2), b)));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            models.add((List<Model.ValueAssignment>)this.prover.getModelAssignments());
            Model model = this.prover.getModel();
            try {
                BooleanFormula modelAsFormula = this.bfmgr.and(this.ifmgr.equal(a, this.num(model.evaluate(a))), this.ifmgr.equal(b, this.num(model.evaluate(b))));
                this.prover.addConstraint(this.bfmgr.not(modelAsFormula));
            }
            finally {
                if (model == null) continue;
                model.close();
            }
        }
        return models;
    }

    private List<List<Model.ValueAssignment>> allSatIntegers2() throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable("b");
        BooleanFormula p = this.bfmgr.makeVariable("p");
        BooleanFormula q = this.bfmgr.makeVariable("q");
        this.prover.addConstraint(this.ifmgr.lessOrEquals(this.num(1), a));
        this.prover.addConstraint(this.ifmgr.equal(this.num(0), b));
        this.prover.addConstraint(this.ifmgr.lessOrEquals(a, this.num(3)));
        this.prover.addConstraint(this.bfmgr.equivalence(p, q));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        while (!this.prover.isUnsat()) {
            ImmutableList<Model.ValueAssignment> modelAssignments = this.prover.getModelAssignments();
            models.add((List<Model.ValueAssignment>)modelAssignments);
            ArrayList<BooleanFormula> modelAssignmentsAsFormulas = new ArrayList<BooleanFormula>();
            for (Model.ValueAssignment va : modelAssignments) {
                modelAssignmentsAsFormulas.add(va.getAssignmentAsFormula());
            }
            this.prover.addConstraint(this.bfmgr.not(this.bfmgr.and(modelAssignmentsAsFormulas)));
        }
        return models;
    }

    private NumeralFormula.IntegerFormula num(int number) {
        return (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(number);
    }

    private NumeralFormula.IntegerFormula num(BigInteger number) {
        return (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber(number);
    }
}

