/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedFormulaManager;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedInterpolatingProverEnvironment;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedInterpolatingProverEnvironmentWithContext;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedOptimizationProverEnvironment;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedProverEnvironment;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedProverEnvironmentWithContext;

@Options(prefix="solver.synchronized")
public class SynchronizedSolverContext
implements SolverContext {
    @Option(secure=true, description="Use provers from a seperate context to solve queries. This allows more parallelity when solving larger queries.")
    private boolean useSeperateProvers = false;
    private final SolverContext delegate;
    private final SolverContext sync;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public SynchronizedSolverContext(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, SolverContext pDelegate) throws InvalidConfigurationException {
        pConfig.inject((Object)this, SynchronizedSolverContext.class);
        this.sync = this.delegate = (SolverContext)Preconditions.checkNotNull((Object)pDelegate);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
    }

    private SolverContext createOtherContext() {
        SolverContext otherContext;
        try {
            otherContext = SolverContextFactory.createSolverContext(this.config, this.logger, this.shutdownNotifier, this.delegate.getSolverName());
        }
        catch (InvalidConfigurationException e) {
            throw new AssertionError((Object)"should not happen, current context was already created before.");
        }
        Preconditions.checkState((boolean)(otherContext instanceof SynchronizedSolverContext), (Object)"same config implies same nesting of solver contexts.");
        return ((SynchronizedSolverContext)otherContext).delegate;
    }

    @Override
    public FormulaManager getFormulaManager() {
        return new SynchronizedFormulaManager(this.delegate.getFormulaManager(), this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            if (this.useSeperateProvers) {
                SolverContext otherContext = this.createOtherContext();
                return new SynchronizedProverEnvironmentWithContext(otherContext.newProverEnvironment(pOptions), this.sync, this.delegate.getFormulaManager(), otherContext.getFormulaManager());
            }
            return new SynchronizedProverEnvironment(this.delegate.newProverEnvironment(pOptions), this.delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(SolverContext.ProverOptions ... pOptions) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            if (this.useSeperateProvers) {
                SolverContext otherContext = this.createOtherContext();
                return new SynchronizedInterpolatingProverEnvironmentWithContext(otherContext.newProverEnvironmentWithInterpolation(pOptions), this.sync, this.delegate.getFormulaManager(), otherContext.getFormulaManager());
            }
            return new SynchronizedInterpolatingProverEnvironment(this.delegate.newProverEnvironmentWithInterpolation(pOptions), this.delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptimizationProverEnvironment newOptimizationProverEnvironment(SolverContext.ProverOptions ... pOptions) {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return new SynchronizedOptimizationProverEnvironment(this.delegate.newOptimizationProverEnvironment(pOptions), this.delegate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SolverContextFactory.Solvers getSolverName() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            return this.delegate.getSolverName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.close();
        }
    }
}

