/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;

class StatisticsArrayFormulaManager
implements ArrayFormulaManager {
    private final ArrayFormulaManager delegate;
    private final SolverStatistics stats;

    StatisticsArrayFormulaManager(ArrayFormulaManager pDelegate, SolverStatistics pStats) {
        this.delegate = (ArrayFormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public <TI extends Formula, TE extends Formula> TE select(ArrayFormula<TI, TE> pArray, TI pIndex) {
        this.stats.arrayOperations.getAndIncrement();
        return this.delegate.select(pArray, pIndex);
    }

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> store(ArrayFormula<TI, TE> pArray, TI pIndex, TE pValue) {
        this.stats.arrayOperations.getAndIncrement();
        return this.delegate.store(pArray, pIndex, pValue);
    }

    @Override
    public <TI extends Formula, TE extends Formula, FTI extends FormulaType<TI>, FTE extends FormulaType<TE>> ArrayFormula<TI, TE> makeArray(String pName, FTI pIndexType, FTE pElementType) {
        this.stats.arrayOperations.getAndIncrement();
        return this.delegate.makeArray(pName, pIndexType, pElementType);
    }

    @Override
    public <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> makeArray(String pName, FormulaType.ArrayFormulaType<TI, TE> pType) {
        this.stats.arrayOperations.getAndIncrement();
        return this.delegate.makeArray(pName, pType);
    }

    @Override
    public <TI extends Formula, TE extends Formula> BooleanFormula equivalence(ArrayFormula<TI, TE> pArray1, ArrayFormula<TI, TE> pArray2) {
        this.stats.arrayOperations.getAndIncrement();
        return this.delegate.equivalence(pArray1, pArray2);
    }

    @Override
    public <TI extends Formula> FormulaType<TI> getIndexType(ArrayFormula<TI, ?> pArray) {
        return this.delegate.getIndexType(pArray);
    }

    @Override
    public <TE extends Formula> FormulaType<TE> getElementType(ArrayFormula<?, TE> pArray) {
        return this.delegate.getElementType(pArray);
    }
}

