/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractBooleanFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractQuantifiedFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractSLFormulaManager;
import org.sosy_lab.java_smt.basicimpl.AbstractUFManager;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.tactics.NNFVisitor;
import org.sosy_lab.java_smt.utils.SolverUtils;

public abstract class AbstractFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl>
implements FormulaManager {
    @VisibleForTesting
    public static final ImmutableSet<String> BASIC_OPERATORS = ImmutableSet.of((Object)"!", (Object)"+", (Object)"-", (Object)"*", (Object)"/", (Object)"%", (Object[])new String[]{"=", "<", ">", "<=", ">="});
    @VisibleForTesting
    public static final ImmutableSet<String> SMTLIB2_KEYWORDS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"and", (Object)"or", (Object)"select", (Object)"store", (Object[])new String[]{"xor", "distinct"});
    private static final CharMatcher DISALLOWED_CHARACTERS = CharMatcher.anyOf((CharSequence)"|\\");
    @VisibleForTesting
    public static final ImmutableBiMap<Character, String> DISALLOWED_CHARACTER_REPLACEMENT = ImmutableBiMap.builder().put((Object)Character.valueOf('|'), (Object)"pipe").put((Object)Character.valueOf('\\'), (Object)"backslash").build();
    private static final char ESCAPE = '$';
    private final @Nullable AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> arrayManager;
    private final AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> booleanManager;
    private final @Nullable IntegerFormulaManager integerManager;
    private final @Nullable RationalFormulaManager rationalManager;
    private final @Nullable AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> bitvectorManager;
    private final @Nullable AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> floatingPointManager;
    private final AbstractUFManager<TFormulaInfo, ?, TType, TEnv> functionManager;
    private final @Nullable AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> quantifiedManager;
    private final @Nullable AbstractSLFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> slManager;
    private final FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> formulaCreator;

    protected AbstractFormulaManager(FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> pFormulaCreator, AbstractUFManager<TFormulaInfo, ?, TType, TEnv> functionManager, AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> booleanManager, @Nullable IntegerFormulaManager pIntegerManager, @Nullable RationalFormulaManager pRationalManager, @Nullable AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> bitvectorManager, @Nullable AbstractFloatingPointFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> floatingPointManager, @Nullable AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> quantifiedManager, @Nullable AbstractArrayFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> arrayManager, @Nullable AbstractSLFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> slManager) {
        this.arrayManager = arrayManager;
        this.quantifiedManager = quantifiedManager;
        this.functionManager = (AbstractUFManager)Preconditions.checkNotNull(functionManager, (Object)"function manager needed");
        this.booleanManager = (AbstractBooleanFormulaManager)Preconditions.checkNotNull(booleanManager, (Object)"boolean manager needed");
        this.integerManager = pIntegerManager;
        this.rationalManager = pRationalManager;
        this.bitvectorManager = bitvectorManager;
        this.floatingPointManager = floatingPointManager;
        this.slManager = slManager;
        this.formulaCreator = pFormulaCreator;
        Preconditions.checkArgument((!(booleanManager.getFormulaCreator() != this.formulaCreator || functionManager.getFormulaCreator() != this.formulaCreator || bitvectorManager != null && bitvectorManager.getFormulaCreator() != this.formulaCreator || floatingPointManager != null && floatingPointManager.getFormulaCreator() != this.formulaCreator) ? 1 : 0) != 0, (Object)"The creator instances must match across the managers!");
    }

    public final FormulaCreator<TFormulaInfo, TType, TEnv, TFuncDecl> getFormulaCreator() {
        return this.formulaCreator;
    }

    @Override
    public IntegerFormulaManager getIntegerFormulaManager() {
        if (this.integerManager == null) {
            throw new UnsupportedOperationException("Solver does not support integer theory");
        }
        return this.integerManager;
    }

    @Override
    public RationalFormulaManager getRationalFormulaManager() {
        if (this.rationalManager == null) {
            throw new UnsupportedOperationException("Solver does not support rationals theory");
        }
        return this.rationalManager;
    }

    @Override
    public AbstractBooleanFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> getBooleanFormulaManager() {
        return this.booleanManager;
    }

    @Override
    public AbstractBitvectorFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> getBitvectorFormulaManager() {
        if (this.bitvectorManager == null) {
            throw new UnsupportedOperationException("Solver does not support bitvector theory");
        }
        return this.bitvectorManager;
    }

    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        if (this.floatingPointManager == null) {
            throw new UnsupportedOperationException("Solver does not support floating point theory");
        }
        return this.floatingPointManager;
    }

    @Override
    public AbstractUFManager<TFormulaInfo, ?, TType, TEnv> getUFManager() {
        return this.functionManager;
    }

    @Override
    public SLFormulaManager getSLFormulaManager() {
        if (this.slManager == null) {
            throw new UnsupportedOperationException("Solver does not support seperation logic theory");
        }
        return this.slManager;
    }

    @Override
    public AbstractQuantifiedFormulaManager<TFormulaInfo, TType, TEnv, TFuncDecl> getQuantifiedFormulaManager() {
        if (this.quantifiedManager == null) {
            throw new UnsupportedOperationException("Solver does not support quantification");
        }
        return this.quantifiedManager;
    }

    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        if (this.arrayManager == null) {
            throw new UnsupportedOperationException("Solver does not support arrays");
        }
        return this.arrayManager;
    }

    public abstract Appender dumpFormula(TFormulaInfo var1);

    @Override
    public Appender dumpFormula(BooleanFormula t) {
        return this.dumpFormula(this.formulaCreator.extractInfo(t));
    }

    @Override
    public final <T extends Formula> FormulaType<T> getFormulaType(T formula) {
        return this.formulaCreator.getFormulaType((Formula)Preconditions.checkNotNull(formula));
    }

    public final TEnv getEnvironment() {
        return this.getFormulaCreator().getEnv();
    }

    public final TFormulaInfo extractInfo(Formula f) {
        return this.formulaCreator.extractInfo(f);
    }

    @Override
    public BooleanFormula applyTactic(BooleanFormula f, Tactic tactic) throws InterruptedException {
        switch (tactic) {
            case ACKERMANNIZATION: {
                return this.applyUFEImpl(f);
            }
            case NNF: {
                return this.applyNNFImpl(f);
            }
            case TSEITIN_CNF: {
                return this.applyCNFImpl(f);
            }
            case QE_LIGHT: {
                return this.applyQELightImpl(f);
            }
        }
        throw new UnsupportedOperationException("Unexpected enum value");
    }

    protected BooleanFormula applyUFEImpl(BooleanFormula pF) throws InterruptedException {
        return SolverUtils.ufElimination(this).eliminateUfs(pF);
    }

    protected BooleanFormula applyQELightImpl(BooleanFormula pF) throws InterruptedException {
        return pF;
    }

    protected BooleanFormula applyCNFImpl(BooleanFormula pF) throws InterruptedException {
        throw new UnsupportedOperationException("Currently there is no generic implementation for CNF conversion");
    }

    protected BooleanFormula applyNNFImpl(BooleanFormula input) throws InterruptedException {
        return ((AbstractBooleanFormulaManager)this.getBooleanFormulaManager()).transformRecursively(input, new NNFVisitor(this));
    }

    @Override
    public <T extends Formula> T simplify(T f) throws InterruptedException {
        return (T)this.formulaCreator.encapsulate(this.formulaCreator.getFormulaType(f), this.simplify(this.extractInfo(f)));
    }

    protected TFormulaInfo simplify(TFormulaInfo f) throws InterruptedException {
        return f;
    }

    @Override
    public <R> R visit(Formula input, FormulaVisitor<R> visitor) {
        return this.formulaCreator.visit(input, visitor);
    }

    @Override
    public void visitRecursively(Formula pF, FormulaVisitor<TraversalProcess> pFormulaVisitor) {
        this.formulaCreator.visitRecursively(pFormulaVisitor, pF);
    }

    @Override
    public <T extends Formula> T transformRecursively(T f, FormulaTransformationVisitor pFormulaVisitor) {
        return this.formulaCreator.transformRecursively(pFormulaVisitor, f);
    }

    @Override
    public Map<String, Formula> extractVariables(Formula f) {
        ImmutableMap.Builder found = ImmutableMap.builder();
        this.formulaCreator.extractVariablesAndUFs(f, false, (arg_0, arg_1) -> ((ImmutableMap.Builder)found).put(arg_0, arg_1));
        return found.build();
    }

    @Override
    public Map<String, Formula> extractVariablesAndUFs(Formula f) {
        LinkedHashMap found = new LinkedHashMap();
        this.formulaCreator.extractVariablesAndUFs(f, true, found::put);
        return ImmutableMap.copyOf(found);
    }

    @Override
    public BooleanFormula translateFrom(BooleanFormula formula, FormulaManager otherContext) {
        if (this == otherContext) {
            return formula;
        }
        return this.parse(otherContext.dumpFormula(formula).toString());
    }

    @Override
    public <T extends Formula> T makeVariable(FormulaType<T> formulaType, String name) {
        Formula t;
        AbstractFormulaManager.checkVariableName(name);
        if (formulaType.isBooleanType()) {
            t = this.booleanManager.makeVariable(name);
        } else if (formulaType.isIntegerType()) {
            assert (this.integerManager != null);
            t = this.integerManager.makeVariable(name);
        } else if (formulaType.isRationalType()) {
            assert (this.rationalManager != null);
            t = this.rationalManager.makeVariable(name);
        } else if (formulaType.isBitvectorType()) {
            assert (this.bitvectorManager != null);
            t = this.bitvectorManager.makeVariable((FormulaType.BitvectorType)formulaType, name);
        } else if (formulaType.isFloatingPointType()) {
            assert (this.floatingPointManager != null);
            t = this.floatingPointManager.makeVariable(name, (FormulaType.FloatingPointType)formulaType);
        } else if (formulaType.isArrayType()) {
            assert (this.arrayManager != null);
            t = this.arrayManager.makeArray(name, (FormulaType.ArrayFormulaType)formulaType);
        } else {
            throw new IllegalArgumentException("Unknown formula type");
        }
        BooleanFormula out = t;
        return (T)out;
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> declaration, List<? extends Formula> args) {
        return this.formulaCreator.callFunction(declaration, args);
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> declaration, Formula ... args) {
        return this.makeApplication(declaration, Arrays.asList(args));
    }

    @Override
    public <T extends Formula> T substitute(T pF, final Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.transformRecursively(pF, new FormulaTransformationVisitor(this){

            @Override
            public Formula visitFreeVariable(Formula f, String name) {
                return this.replace(f);
            }

            @Override
            public Formula visitFunction(Formula f, List<Formula> newArgs, FunctionDeclaration<?> functionDeclaration) {
                Formula out = (Formula)pFromToMapping.get(f);
                if (out == null) {
                    return AbstractFormulaManager.this.makeApplication(functionDeclaration, newArgs);
                }
                return out;
            }

            private Formula replace(Formula f) {
                Formula out = (Formula)pFromToMapping.get(f);
                if (out == null) {
                    return f;
                }
                return out;
            }
        });
    }

    @Override
    public final boolean isValidName(String pVar) {
        if (pVar.isEmpty()) {
            return false;
        }
        if (BASIC_OPERATORS.contains((Object)pVar)) {
            return false;
        }
        if (SMTLIB2_KEYWORDS.contains((Object)pVar)) {
            return false;
        }
        return !DISALLOWED_CHARACTERS.matchesAnyOf((CharSequence)pVar);
    }

    @VisibleForTesting
    public static void checkVariableName(String variableName) {
        String help = "Use FormulaManager#isValidName to check your identifier before using it.";
        Preconditions.checkArgument((!variableName.isEmpty() ? 1 : 0) != 0, (Object)"Identifier for variable should not be empty.");
        Preconditions.checkArgument((!BASIC_OPERATORS.contains((Object)variableName) ? 1 : 0) != 0, (String)"Identifier '%s' should not be a simple operator. %s", (Object)variableName, (Object)"Use FormulaManager#isValidName to check your identifier before using it.");
        Preconditions.checkArgument((!SMTLIB2_KEYWORDS.contains((Object)variableName) ? 1 : 0) != 0, (String)"Identifier '%s' should not be a keyword of SMT-LIB2. %s", (Object)variableName, (Object)"Use FormulaManager#isValidName to check your identifier before using it.");
        Preconditions.checkArgument((boolean)DISALLOWED_CHARACTERS.matchesNoneOf((CharSequence)variableName), (String)"Identifier '%s' should contain an escape character %s of SMT-LIB2. %s", (Object)variableName, (Object)DISALLOWED_CHARACTER_REPLACEMENT.keySet(), (Object)"Use FormulaManager#isValidName to check your identifier before using it.");
    }

    @Override
    public final String escape(String pVar) {
        if (pVar.isEmpty() || BASIC_OPERATORS.contains((Object)pVar) || SMTLIB2_KEYWORDS.contains((Object)pVar)) {
            return "$" + pVar;
        }
        if (pVar.indexOf(36) != -1) {
            pVar = pVar.replace("$", "$$");
        }
        if (DISALLOWED_CHARACTERS.matchesAnyOf((CharSequence)pVar)) {
            for (Map.Entry e : DISALLOWED_CHARACTER_REPLACEMENT.entrySet()) {
                pVar = pVar.replace(((Character)e.getKey()).toString(), "$" + (String)e.getValue());
            }
        }
        return pVar;
    }

    @Override
    public final String unescape(String pVar) {
        int idx = pVar.indexOf(36);
        if (idx != -1) {
            String tmp;
            if (idx == 0 && ((tmp = pVar.substring(1)).isEmpty() || BASIC_OPERATORS.contains((Object)tmp) || SMTLIB2_KEYWORDS.contains((Object)tmp))) {
                return tmp;
            }
            StringBuilder str = new StringBuilder();
            block0: for (int i = 0; i < pVar.length(); ++i) {
                if (pVar.charAt(i) == '$') {
                    if (pVar.charAt(i + 1) == '$') {
                        str.append('$');
                        ++i;
                        continue;
                    }
                    String rest = pVar.substring(i + 1);
                    for (Map.Entry e : DISALLOWED_CHARACTER_REPLACEMENT.entrySet()) {
                        if (!rest.startsWith((String)e.getValue())) continue;
                        str.append(e.getKey());
                        i += ((String)e.getValue()).length();
                        continue block0;
                    }
                    continue;
                }
                str.append(pVar.charAt(i));
            }
            return str.toString();
        }
        return pVar;
    }
}

