/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.delegate.logging.LoggingSolverContext;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsSolverContext;
import org.sosy_lab.java_smt.delegate.synchronize.SynchronizedSolverContext;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorSolverContext;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4SolverContext;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5SolverContext;
import org.sosy_lab.java_smt.solvers.princess.PrincessSolverContext;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolSolverContext;
import org.sosy_lab.java_smt.solvers.yices2.Yices2SolverContext;

@Options(prefix="solver")
public class SolverContextFactory {
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    private boolean logAllQueries = false;
    @Option(secure=true, description="Export solver queries in SmtLib format into a file.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private @Nullable PathCounterTemplate logfile = PathCounterTemplate.ofFormatString((String)"smtquery.%03d.smt2");
    @Option(secure=true, description="If logging from the same application, avoid conflicting logfile names.")
    private boolean renameLogfileToAvoidConflicts = true;
    private static final Set<String> logfiles = new LinkedHashSet<String>();
    @Option(secure=true, description="Random seed for SMT solver.")
    private long randomSeed = 42L;
    @Option(secure=true, description="Which SMT solver to use.")
    private Solvers solver = Solvers.SMTINTERPOL;
    @Option(secure=true, description="Log solver actions, this may be slow!")
    private boolean useLogger = false;
    @Option(secure=true, description="Sequentialize all solver actions to allow concurrent access!")
    private boolean synchronize = false;
    @Option(secure=true, description="Counts all operations and interactions towards the SMT solver.")
    private boolean collectStatistics = false;
    @Option(secure=true, description="Default rounding mode for floating point operations.")
    private FloatingPointRoundingMode floatingPointRoundingMode = FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN;
    @Option(secure=true, description="Use non-linear arithmetic of the solver if supported and throw exception otherwise, approximate non-linear arithmetic with UFs if unsupported, or always approximate non-linear arithmetic. This affects only the theories of integer and rational arithmetic.")
    private AbstractNumeralFormulaManager.NonLinearArithmetic nonLinearArithmetic = AbstractNumeralFormulaManager.NonLinearArithmetic.USE;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private static final String Z3_PACKAGE = "org.sosy_lab.java_smt.solvers.z3";
    private static final String Z3_FACTORY_CLASS = "org.sosy_lab.java_smt.solvers.z3.Z3LoadingFactory";
    private static final Pattern Z3_CLASSES = Pattern.compile("^(com\\.microsoft\\.z3|" + Pattern.quote("org.sosy_lab.java_smt.solvers.z3") + ")\\..*");
    private static final ImmutableSet<String> Z3_LIBRARY_NAMES = ImmutableSet.of((Object)"z3", (Object)"libz3", (Object)"libz3java", (Object)"z3java");
    private static final ClassLoader z3ClassLoader = SolverContextFactory.createZ3ClassLoader();

    public SolverContextFactory(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger.withComponentName("JavaSMT");
        this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
        this.config = pConfig;
        if (!this.logAllQueries) {
            this.logfile = null;
        }
        if (this.logfile != null && this.renameLogfileToAvoidConflicts) {
            this.logfile = SolverContextFactory.makeUniqueLogfile(this.logfile);
        }
    }

    private static synchronized PathCounterTemplate makeUniqueLogfile(PathCounterTemplate pLogfile) {
        String original = pLogfile.getTemplate();
        String extension = SolverContextFactory.getFileExtension(original);
        String basename = original.substring(0, original.length() - extension.length());
        Object template = original;
        int counter = 0;
        while (logfiles.contains(template)) {
            template = basename + "." + ++counter + extension;
        }
        logfiles.add((String)template);
        return PathCounterTemplate.ofFormatString((String)template);
    }

    private static String getFileExtension(String path) {
        int lastIndexOf = path.lastIndexOf(46);
        return lastIndexOf == -1 ? "" : path.substring(lastIndexOf);
    }

    public SolverContext generateContext() throws InvalidConfigurationException {
        return this.generateContext(this.solver);
    }

    public SolverContext generateContext(Solvers solverToCreate) throws InvalidConfigurationException {
        SolverContext context;
        try {
            context = this.generateContext0(solverToCreate);
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            throw new InvalidConfigurationException(String.format("The SMT solver %s is not available on this machine because of missing libraries (%s). You may experiment with SMTInterpol by setting solver.solver=SMTInterpol.", new Object[]{solverToCreate, e.getMessage()}), (Throwable)e);
        }
        if (this.useLogger) {
            context = new LoggingSolverContext(this.logger, context);
        }
        if (this.synchronize) {
            context = new SynchronizedSolverContext(this.config, this.logger, this.shutdownNotifier, context);
        }
        if (this.collectStatistics) {
            context = new StatisticsSolverContext(context);
        }
        return context;
    }

    private SolverContext generateContext0(Solvers solverToCreate) throws InvalidConfigurationException {
        switch (solverToCreate) {
            case CVC4: {
                return CVC4SolverContext.create(this.logger, this.shutdownNotifier, (int)this.randomSeed, this.nonLinearArithmetic, this.floatingPointRoundingMode);
            }
            case SMTINTERPOL: {
                return SmtInterpolSolverContext.create(this.config, this.logger, this.shutdownNotifier, this.logfile, this.randomSeed, this.nonLinearArithmetic);
            }
            case MATHSAT5: {
                return Mathsat5SolverContext.create(this.logger, this.config, this.shutdownNotifier, this.logfile, this.randomSeed, this.floatingPointRoundingMode, this.nonLinearArithmetic);
            }
            case Z3: {
                return this.getFactoryForSolver(z3ClassLoader, Z3_FACTORY_CLASS).generateSolverContext(this.config, this.logger, this.shutdownNotifier, this.logfile, this.randomSeed, this.floatingPointRoundingMode, this.nonLinearArithmetic);
            }
            case PRINCESS: {
                return PrincessSolverContext.create(this.config, this.shutdownNotifier, this.logfile, (int)this.randomSeed, this.nonLinearArithmetic);
            }
            case YICES2: {
                return Yices2SolverContext.create((AbstractNumeralFormulaManager.NonLinearArithmetic)this.nonLinearArithmetic, (ShutdownNotifier)this.shutdownNotifier);
            }
            case BOOLECTOR: {
                return BoolectorSolverContext.create(this.config, this.shutdownNotifier, this.logfile, (int)this.randomSeed);
            }
        }
        throw new AssertionError((Object)"no solver selected");
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext();
    }

    public static SolverContext createSolverContext(Configuration config, LogManager logger, ShutdownNotifier shutdownNotifier, Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(config, logger, shutdownNotifier).generateContext(solver);
    }

    public static SolverContext createSolverContext(Solvers solver) throws InvalidConfigurationException {
        return new SolverContextFactory(Configuration.defaultConfiguration(), LogManager.createNullLogManager(), ShutdownNotifier.createDummy()).generateContext(solver);
    }

    private InnerUtilFactory getFactoryForSolver(ClassLoader pClassLoader, String factoryClassName) {
        try {
            Class<?> factoryClass = pClassLoader.loadClass(factoryClassName);
            Constructor<?> factoryConstructor = factoryClass.getConstructor(new Class[0]);
            return (InnerUtilFactory)factoryConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new Classes.UnexpectedCheckedException("Failed to load" + factoryClassName, (Throwable)e);
        }
    }

    private static ClassLoader createZ3ClassLoader() {
        ClassLoader parentClassLoader = SolverContextFactory.class.getClassLoader();
        Classes.ClassLoaderBuilder builder = Classes.makeExtendedURLClassLoader().setParent(parentClassLoader).setDirectLoadClasses(Z3_CLASSES).setCustomLookupNativeLibraries(arg_0 -> Z3_LIBRARY_NAMES.contains(arg_0));
        ImmutableList.Builder libs = ImmutableList.builderWithExpectedSize((int)2);
        libs.add((Object)SolverContextFactory.class.getProtectionDomain().getCodeSource().getLocation());
        URL z3Class = parentClassLoader.getResource("com/microsoft/z3/Native.class");
        if (z3Class != null) {
            if (z3Class.getProtocol().equals("jar")) {
                try {
                    URLConnection conn = z3Class.openConnection();
                    if (!(conn instanceof JarURLConnection)) {
                        throw new AssertionError((Object)"URL.openConnection() did not return a JarURLConnection for a JAR URL");
                    }
                    libs.add((Object)((JarURLConnection)conn).getJarFileURL());
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
            }
            try {
                libs.add((Object)z3Class.toURI().resolve("../../..").toURL());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
        }
        builder.setUrls((Iterable)libs.build());
        return builder.build();
    }

    public static abstract class InnerUtilFactory {
        protected abstract SolverContext generateSolverContext(Configuration var1, LogManager var2, ShutdownNotifier var3, @Nullable PathCounterTemplate var4, long var5, FloatingPointRoundingMode var7, AbstractNumeralFormulaManager.NonLinearArithmetic var8) throws InvalidConfigurationException;
    }

    public static enum Solvers {
        MATHSAT5,
        SMTINTERPOL,
        Z3,
        PRINCESS,
        BOOLECTOR,
        CVC4,
        YICES2;

    }
}

