/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import edu.stanford.CVC4.BitVector;
import edu.stanford.CVC4.BitVectorExtract;
import edu.stanford.CVC4.BitVectorSignExtend;
import edu.stanford.CVC4.BitVectorType;
import edu.stanford.CVC4.BitVectorZeroExtend;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.IntToBitVector;
import edu.stanford.CVC4.Kind;
import edu.stanford.CVC4.Rational;
import edu.stanford.CVC4.Type;
import java.math.BigInteger;
import org.sosy_lab.java_smt.basicimpl.AbstractBitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;

public class CVC4BitvectorFormulaManager
extends AbstractBitvectorFormulaManager<Expr, Type, ExprManager, Expr> {
    private final ExprManager exprManager;

    protected CVC4BitvectorFormulaManager(CVC4FormulaCreator pCreator) {
        super(pCreator);
        this.exprManager = (ExprManager)pCreator.getEnv();
    }

    @Override
    protected Expr concat(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_CONCAT, pParam1, pParam2);
    }

    @Override
    protected Expr extract(Expr pParam1, int pMsb, int pLsb, boolean signed) {
        Expr ext = this.exprManager.mkConst(new BitVectorExtract((long)pMsb, (long)pLsb));
        return this.exprManager.mkExpr(Kind.BITVECTOR_EXTRACT, ext, pParam1);
    }

    @Override
    protected Expr extend(Expr pParam1, int pExtensionBits, boolean signed) {
        Expr op = signed ? this.exprManager.mkConst(new BitVectorSignExtend((long)pExtensionBits)) : this.exprManager.mkConst(new BitVectorZeroExtend((long)pExtensionBits));
        return this.exprManager.mkExpr(op, pParam1);
    }

    @Override
    protected Expr makeBitvectorImpl(int pLength, BigInteger pI) {
        pI = this.transformValueToRange(pLength, pI);
        return this.exprManager.mkConst(new BitVector((long)pLength, pI));
    }

    @Override
    protected Expr makeVariableImpl(int length, String varName) {
        BitVectorType type = this.exprManager.mkBitVectorType((long)length);
        return (Expr)this.getFormulaCreator().makeVariable(type, varName);
    }

    @Override
    protected Expr shiftRight(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_ASHR, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_LSHR, pParam1, pParam2);
    }

    @Override
    protected Expr shiftLeft(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_SHL, pParam1, pParam2);
    }

    @Override
    protected Expr not(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_NOT, pParam1);
    }

    @Override
    protected Expr and(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_AND, pParam1, pParam2);
    }

    @Override
    protected Expr or(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_OR, pParam1, pParam2);
    }

    @Override
    protected Expr xor(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_XOR, pParam1, pParam2);
    }

    @Override
    protected Expr negate(Expr pParam1) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_NEG, pParam1);
    }

    @Override
    protected Expr add(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_PLUS, pParam1, pParam2);
    }

    @Override
    protected Expr subtract(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_SUB, pParam1, pParam2);
    }

    @Override
    protected Expr divide(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SDIV, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_UDIV, pParam1, pParam2);
    }

    @Override
    protected Expr modulo(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SREM, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_UREM, pParam1, pParam2);
    }

    @Override
    protected Expr multiply(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.BITVECTOR_MULT, pParam1, pParam2);
    }

    @Override
    protected Expr equal(Expr pParam1, Expr pParam2) {
        return this.exprManager.mkExpr(Kind.EQUAL, pParam1, pParam2);
    }

    @Override
    protected Expr lessThan(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SLT, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_ULT, pParam1, pParam2);
    }

    @Override
    protected Expr lessOrEquals(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SLE, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_ULE, pParam1, pParam2);
    }

    @Override
    protected Expr greaterThan(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SGT, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_UGT, pParam1, pParam2);
    }

    @Override
    protected Expr greaterOrEquals(Expr pParam1, Expr pParam2, boolean signed) {
        if (signed) {
            return this.exprManager.mkExpr(Kind.BITVECTOR_SGE, pParam1, pParam2);
        }
        return this.exprManager.mkExpr(Kind.BITVECTOR_UGE, pParam1, pParam2);
    }

    @Override
    protected Expr makeBitvectorImpl(int pLength, Expr pParam1) {
        Expr size = this.exprManager.mkConst(new IntToBitVector((long)pLength));
        return this.exprManager.mkExpr(Kind.INT_TO_BITVECTOR, size, pParam1);
    }

    @Override
    protected Expr toIntegerFormulaImpl(Expr pBv, boolean pSigned) {
        Expr intExpr = this.exprManager.mkExpr(Kind.BITVECTOR_TO_NAT, pBv);
        if (pSigned) {
            int size = Math.toIntExact(new BitVectorType(pBv.getType()).getSize());
            BigInteger modulo = BigInteger.ONE.shiftLeft(size);
            BigInteger maxInt = BigInteger.ONE.shiftLeft(size - 1).subtract(BigInteger.ONE);
            Expr moduloExpr = this.exprManager.mkConst(new Rational(modulo.toString()));
            Expr maxIntExpr = this.exprManager.mkConst(new Rational(maxInt.toString()));
            intExpr = this.exprManager.mkExpr(Kind.ITE, this.exprManager.mkExpr(Kind.GT, intExpr, maxIntExpr), this.exprManager.mkExpr(Kind.MINUS, intExpr, moduloExpr), intExpr);
        }
        return intExpr;
    }
}

