/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;

public class TimerPool {
    private static final TimeUnit UNIT = new Timer().getMaxTime().getUnit();
    private final Map<WeakReference<TimerWrapper>, Timer> activeTimers = new IdentityHashMap<WeakReference<TimerWrapper>, Timer>();
    private final ReferenceQueue<TimerWrapper> referenceQueue = new ReferenceQueue();
    private long sumTime = 0L;
    private long maxTime = 0L;
    private int numberOfIntervals = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerWrapper getNewTimer() {
        this.cleanupReferences();
        Timer timer = new Timer();
        TimerWrapper wrapper = new TimerWrapper(timer);
        assert (UNIT == timer.getSumTime().getUnit()) : "sub-timers should use same unit";
        Map<WeakReference<TimerWrapper>, Timer> map = this.activeTimers;
        synchronized (map) {
            this.activeTimers.put(new WeakReference<TimerWrapper>(wrapper, this.referenceQueue), timer);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupReferences() {
        Reference<TimerWrapper> ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            Map<WeakReference<TimerWrapper>, Timer> map = this.activeTimers;
            synchronized (map) {
                this.closeTimer(this.activeTimers.remove(ref));
            }
        }
    }

    private void closeTimer(Timer timer) {
        timer.stopIfRunning();
        this.sumTime += this.convert(timer.getSumTime());
        this.maxTime = Math.max(this.maxTime, this.convert(timer.getMaxTime()));
        this.numberOfIntervals += timer.getNumberOfIntervals();
    }

    private long convert(TimeSpan time) {
        return time.getSaturated(UNIT);
    }

    private long eval(Function<Timer, Long> f, BiFunction<Long, Long, Long> acc) {
        long currentInterval = 0L;
        for (Timer timer : this.activeTimers.values()) {
            currentInterval = acc.apply(currentInterval, f.apply(timer));
        }
        return currentInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpan getSumTime() {
        this.cleanupReferences();
        Map<WeakReference<TimerWrapper>, Timer> map = this.activeTimers;
        synchronized (map) {
            return this.export(this.sumTime + this.eval(t -> this.convert(t.getSumTime()), Math::addExact));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimeSpan getMaxTime() {
        this.cleanupReferences();
        Map<WeakReference<TimerWrapper>, Timer> map = this.activeTimers;
        synchronized (map) {
            return this.export(Math.max(this.maxTime, this.eval(t -> this.convert(t.getMaxTime()), Math::max)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfIntervals() {
        this.cleanupReferences();
        Map<WeakReference<TimerWrapper>, Timer> map = this.activeTimers;
        synchronized (map) {
            return (int)((long)this.numberOfIntervals + this.eval(t -> t.getNumberOfIntervals(), Math::addExact));
        }
    }

    private TimeSpan export(long time) {
        return TimeSpan.of((long)time, (TimeUnit)UNIT);
    }

    public String toString() {
        this.cleanupReferences();
        return this.getSumTime().formatAs(TimeUnit.SECONDS);
    }

    public static class TimerWrapper {
        private final Timer timer;

        TimerWrapper(Timer pTimer) {
            this.timer = pTimer;
        }

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }
    }
}

