/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.statistics;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.ArrayFormulaManager;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FloatingPointFormulaManager;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.RationalFormulaManager;
import org.sosy_lab.java_smt.api.SLFormulaManager;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.UFManager;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.delegate.statistics.SolverStatistics;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsArrayFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsBitvectorFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsBooleanFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsFloatingPointFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsIntegerFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsQuantifiedFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsRationalFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsSLFormulaManager;
import org.sosy_lab.java_smt.delegate.statistics.StatisticsUFManager;

class StatisticsFormulaManager
implements FormulaManager {
    private final FormulaManager delegate;
    private final SolverStatistics stats;

    protected StatisticsFormulaManager(FormulaManager pDelegate, SolverStatistics pStats) {
        this.delegate = (FormulaManager)Preconditions.checkNotNull((Object)pDelegate);
        this.stats = (SolverStatistics)Preconditions.checkNotNull((Object)pStats);
    }

    @Override
    public IntegerFormulaManager getIntegerFormulaManager() {
        return new StatisticsIntegerFormulaManager(this.delegate.getIntegerFormulaManager(), this.stats);
    }

    @Override
    public RationalFormulaManager getRationalFormulaManager() {
        return new StatisticsRationalFormulaManager(this.delegate.getRationalFormulaManager(), this.stats);
    }

    @Override
    public BooleanFormulaManager getBooleanFormulaManager() {
        return new StatisticsBooleanFormulaManager(this.delegate.getBooleanFormulaManager(), this.stats);
    }

    @Override
    public ArrayFormulaManager getArrayFormulaManager() {
        return new StatisticsArrayFormulaManager(this.delegate.getArrayFormulaManager(), this.stats);
    }

    @Override
    public BitvectorFormulaManager getBitvectorFormulaManager() {
        return new StatisticsBitvectorFormulaManager(this.delegate.getBitvectorFormulaManager(), this.stats);
    }

    @Override
    public FloatingPointFormulaManager getFloatingPointFormulaManager() {
        return new StatisticsFloatingPointFormulaManager(this.delegate.getFloatingPointFormulaManager(), this.stats);
    }

    @Override
    public UFManager getUFManager() {
        return new StatisticsUFManager(this.delegate.getUFManager(), this.stats);
    }

    @Override
    public SLFormulaManager getSLFormulaManager() {
        return new StatisticsSLFormulaManager(this.delegate.getSLFormulaManager(), this.stats);
    }

    @Override
    public QuantifiedFormulaManager getQuantifiedFormulaManager() {
        return new StatisticsQuantifiedFormulaManager(this.delegate.getQuantifiedFormulaManager(), this.stats);
    }

    @Override
    public <T extends Formula> T makeVariable(FormulaType<T> pFormulaType, String pName) {
        return this.delegate.makeVariable(pFormulaType, pName);
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> pDeclaration, List<? extends Formula> pArgs) {
        return this.delegate.makeApplication(pDeclaration, pArgs);
    }

    @Override
    public <T extends Formula> T makeApplication(FunctionDeclaration<T> pDeclaration, Formula ... pArgs) {
        return this.delegate.makeApplication(pDeclaration, pArgs);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        return this.delegate.getFormulaType(pFormula);
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        return this.delegate.parse(pS);
    }

    @Override
    public Appender dumpFormula(final BooleanFormula pT) {
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                String dump = StatisticsFormulaManager.this.delegate.dumpFormula(pT).toString();
                out.append(dump);
            }
        };
    }

    @Override
    public BooleanFormula applyTactic(BooleanFormula pInput, Tactic pTactic) throws InterruptedException {
        return this.delegate.applyTactic(pInput, pTactic);
    }

    @Override
    public <T extends Formula> T simplify(T pInput) throws InterruptedException {
        return this.delegate.simplify(pInput);
    }

    @Override
    public <R> R visit(Formula pF, FormulaVisitor<R> pFormulaVisitor) {
        return this.delegate.visit(pF, pFormulaVisitor);
    }

    @Override
    public void visitRecursively(Formula pF, FormulaVisitor<TraversalProcess> pFormulaVisitor) {
        this.delegate.visitRecursively(pF, pFormulaVisitor);
    }

    @Override
    public <T extends Formula> T transformRecursively(T pF, FormulaTransformationVisitor pFormulaVisitor) {
        return this.delegate.transformRecursively(pF, pFormulaVisitor);
    }

    @Override
    public Map<String, Formula> extractVariables(Formula pF) {
        return this.delegate.extractVariables(pF);
    }

    @Override
    public Map<String, Formula> extractVariablesAndUFs(Formula pF) {
        return this.delegate.extractVariablesAndUFs(pF);
    }

    @Override
    public <T extends Formula> T substitute(T pF, Map<? extends Formula, ? extends Formula> pFromToMapping) {
        return this.delegate.substitute(pF, pFromToMapping);
    }

    @Override
    public BooleanFormula translateFrom(BooleanFormula pFormula, FormulaManager pOtherContext) {
        return this.delegate.translateFrom(pFormula, pOtherContext);
    }

    @Override
    public boolean isValidName(String pVariableName) {
        return this.delegate.isValidName(pVariableName);
    }

    @Override
    public String escape(String pVariableName) {
        return this.delegate.escape(pVariableName);
    }

    @Override
    public String unescape(String pVariableName) {
        return this.delegate.unescape(pVariableName);
    }
}

