/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.z3;

import com.google.common.collect.ImmutableList;
import com.microsoft.z3.Native;
import java.util.List;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.z3.Z3FormulaCreator;

class Z3FloatingPointFormulaManager
extends AbstractFloatingPointFormulaManager<Long, Long, Long, Long> {
    private static final FormulaType.FloatingPointType highPrec = FormulaType.getFloatingPointType(15, 112);
    private final long z3context;
    private final long roundingMode;

    Z3FloatingPointFormulaManager(Z3FormulaCreator creator, FloatingPointRoundingMode pFloatingPointRoundingMode) {
        super(creator);
        this.z3context = (Long)creator.getEnv();
        this.roundingMode = this.getRoundingModeImpl(pFloatingPointRoundingMode);
    }

    @Override
    protected Long getDefaultRoundingMode() {
        return this.roundingMode;
    }

    @Override
    protected Long getRoundingModeImpl(FloatingPointRoundingMode pFloatingPointRoundingMode) {
        long out;
        switch (pFloatingPointRoundingMode) {
            case NEAREST_TIES_TO_EVEN: {
                out = Native.mkFpaRoundNearestTiesToEven((long)this.z3context);
                break;
            }
            case NEAREST_TIES_AWAY: {
                out = Native.mkFpaRoundNearestTiesToAway((long)this.z3context);
                break;
            }
            case TOWARD_POSITIVE: {
                out = Native.mkFpaRoundTowardPositive((long)this.z3context);
                break;
            }
            case TOWARD_NEGATIVE: {
                out = Native.mkFpaRoundTowardNegative((long)this.z3context);
                break;
            }
            case TOWARD_ZERO: {
                out = Native.mkFpaRoundTowardZero((long)this.z3context);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected value");
            }
        }
        Native.incRef((long)this.z3context, (long)out);
        return out;
    }

    private long mkFpaSort(FormulaType.FloatingPointType pType) {
        return (Long)this.getFormulaCreator().getFloatingPointType(pType);
    }

    @Override
    protected Long makeNumberImpl(double pN, FormulaType.FloatingPointType pType, Long pRoundingMode) {
        return this.makeNumberImpl(Double.toString(pN), pType, pRoundingMode);
    }

    @Override
    protected Long makeNumberAndRound(String pN, FormulaType.FloatingPointType pType, Long pRoundingMode) {
        if (pType.getExponentSize() <= highPrec.getExponentSize() || pType.getMantissaSize() <= highPrec.getMantissaSize()) {
            long highPrecNumber = Native.mkNumeral((long)this.z3context, (String)pN, (long)this.mkFpaSort(highPrec));
            Native.incRef((long)this.z3context, (long)highPrecNumber);
            long smallPrecNumber = this.castToImpl(highPrecNumber, (FormulaType<?>)pType, pRoundingMode);
            Native.incRef((long)this.z3context, (long)smallPrecNumber);
            long result = Native.simplify((long)this.z3context, (long)smallPrecNumber);
            Native.decRef((long)this.z3context, (long)highPrecNumber);
            Native.decRef((long)this.z3context, (long)smallPrecNumber);
            return result;
        }
        return Native.mkNumeral((long)this.z3context, (String)pN, (long)this.mkFpaSort(pType));
    }

    @Override
    protected Long makeVariableImpl(String var, FormulaType.FloatingPointType pType) {
        return (Long)this.getFormulaCreator().makeVariable(this.mkFpaSort(pType), var);
    }

    @Override
    protected Long makePlusInfinityImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaInf((long)this.z3context, (long)this.mkFpaSort(pType), (boolean)false);
    }

    @Override
    protected Long makeMinusInfinityImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaInf((long)this.z3context, (long)this.mkFpaSort(pType), (boolean)true);
    }

    @Override
    protected Long makeNaNImpl(FormulaType.FloatingPointType pType) {
        return Native.mkFpaNan((long)this.z3context, (long)this.mkFpaSort(pType));
    }

    @Override
    protected Long castToImpl(Long pNumber, FormulaType<?> pTargetType, Long pRoundingMode) {
        if (pTargetType.isFloatingPointType()) {
            FormulaType.FloatingPointType targetType = (FormulaType.FloatingPointType)pTargetType;
            return Native.mkFpaToFpFloat((long)this.z3context, (long)pRoundingMode, (long)pNumber, (long)this.mkFpaSort(targetType));
        }
        if (pTargetType.isBitvectorType()) {
            FormulaType.BitvectorType targetType = (FormulaType.BitvectorType)pTargetType;
            return Native.mkFpaToSbv((long)this.z3context, (long)pRoundingMode, (long)pNumber, (int)targetType.getSize());
        }
        if (pTargetType.isRationalType()) {
            return Native.mkFpaToReal((long)this.z3context, (long)pNumber);
        }
        return this.genericCast(pNumber, pTargetType);
    }

    @Override
    protected Long castFromImpl(Long pNumber, boolean signed, FormulaType.FloatingPointType pTargetType, Long pRoundingMode) {
        FormulaType<?> formulaType = this.getFormulaCreator().getFormulaType(pNumber);
        if (formulaType.isFloatingPointType()) {
            return this.castToImpl(pNumber, (FormulaType<?>)pTargetType, pRoundingMode);
        }
        if (formulaType.isBitvectorType()) {
            if (signed) {
                return Native.mkFpaToFpSigned((long)this.z3context, (long)pRoundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
            }
            return Native.mkFpaToFpUnsigned((long)this.z3context, (long)pRoundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
        }
        if (formulaType.isRationalType()) {
            return Native.mkFpaToFpReal((long)this.z3context, (long)pRoundingMode, (long)pNumber, (long)this.mkFpaSort(pTargetType));
        }
        return this.genericCast(pNumber, pTargetType);
    }

    private Long genericCast(Long pNumber, FormulaType<?> pTargetType) {
        FormulaType<?> argType = this.getFormulaCreator().getFormulaType(pNumber);
        long castFuncDecl = (Long)this.getFormulaCreator().declareUFImpl("__cast_" + argType + "_to_" + pTargetType, (Long)this.toSolverType(pTargetType), (List<Long>)ImmutableList.of((Object)((Long)this.toSolverType(argType))));
        return Native.mkApp((long)this.z3context, (long)castFuncDecl, (int)1, (long[])new long[]{pNumber});
    }

    @Override
    protected Long fromIeeeBitvectorImpl(Long pNumber, FormulaType.FloatingPointType pTargetType) {
        return Native.mkFpaToFpBv((long)this.z3context, (long)pNumber, (long)this.mkFpaSort(pTargetType));
    }

    @Override
    protected Long toIeeeBitvectorImpl(Long pNumber) {
        return Native.mkFpaToIeeeBv((long)this.z3context, (long)pNumber);
    }

    @Override
    protected Long negate(Long pNumber) {
        return Native.mkFpaNeg((long)this.z3context, (long)pNumber);
    }

    @Override
    protected Long abs(Long pNumber) {
        return Native.mkFpaAbs((long)this.z3context, (long)pNumber);
    }

    @Override
    protected Long max(Long pNumber1, Long pNumber2) {
        return Native.mkFpaMax((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long min(Long pNumber1, Long pNumber2) {
        return Native.mkFpaMin((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long sqrt(Long pNumber, Long pRoundingMode) {
        return Native.mkFpaSqrt((long)this.z3context, (long)pRoundingMode, (long)pNumber);
    }

    @Override
    protected Long add(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Native.mkFpaAdd((long)this.z3context, (long)pRoundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long subtract(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Native.mkFpaSub((long)this.z3context, (long)pRoundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long multiply(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Native.mkFpaMul((long)this.z3context, (long)pRoundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long divide(Long pNumber1, Long pNumber2, Long pRoundingMode) {
        return Native.mkFpaDiv((long)this.z3context, (long)pRoundingMode, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long assignment(Long pNumber1, Long pNumber2) {
        return Native.mkEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long equalWithFPSemantics(Long pNumber1, Long pNumber2) {
        return Native.mkFpaEq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long greaterThan(Long pNumber1, Long pNumber2) {
        return Native.mkFpaGt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long greaterOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkFpaGeq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long lessThan(Long pNumber1, Long pNumber2) {
        return Native.mkFpaLt((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long lessOrEquals(Long pNumber1, Long pNumber2) {
        return Native.mkFpaLeq((long)this.z3context, (long)pNumber1, (long)pNumber2);
    }

    @Override
    protected Long isNaN(Long pParam) {
        return Native.mkFpaIsNan((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isInfinity(Long pParam) {
        return Native.mkFpaIsInfinite((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isZero(Long pParam) {
        return Native.mkFpaIsZero((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isSubnormal(Long pParam) {
        return Native.mkFpaIsSubnormal((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isNormal(Long pParam) {
        return Native.mkFpaIsNormal((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long isNegative(Long pParam) {
        return Native.mkFpaIsNegative((long)this.z3context, (long)pParam);
    }

    @Override
    protected Long round(Long pFormula, FloatingPointRoundingMode pRoundingMode) {
        return Native.mkFpaRoundToIntegral((long)this.z3context, (long)this.getRoundingModeImpl(pRoundingMode), (long)pFormula);
    }
}

