/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolAbstractProver;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;

class SmtInterpolTheoremProver
extends SmtInterpolAbstractProver<Void, Term>
implements ProverEnvironment {
    SmtInterpolTheoremProver(SmtInterpolFormulaManager pMgr, Set<SolverContext.ProverOptions> options) {
        super(pMgr, options);
    }

    @Override
    public @Nullable Void addConstraint(BooleanFormula constraint) {
        Preconditions.checkState((!this.isClosed() ? 1 : 0) != 0);
        Term t = (Term)this.mgr.extractInfo(constraint);
        if (this.generateUnsatCores) {
            String termName = SmtInterpolTheoremProver.generateTermName();
            Term annotated = this.env.annotate(t, new Annotation(":named", (Object)termName));
            this.annotatedTerms.put(termName, t);
            this.env.assertTerm(annotated);
        } else {
            this.env.assertTerm(t);
        }
        ((List)this.assertedFormulas.peek()).add(t);
        return null;
    }
}

