/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Joiner;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import edu.stanford.CVC4.Expr;
import edu.stanford.CVC4.ExprManager;
import edu.stanford.CVC4.Type;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4ArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4BitvectorFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4BooleanFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FloatingPointFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4Formula;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4IntegerFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4RationalFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4SLFormulaManager;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4UFManager;

class CVC4FormulaManager
extends AbstractFormulaManager<Expr, Type, ExprManager, Expr> {
    private final CVC4FormulaCreator creator;

    CVC4FormulaManager(CVC4FormulaCreator pFormulaCreator, CVC4UFManager pFfmgr, CVC4BooleanFormulaManager pBfmgr, CVC4IntegerFormulaManager pIfmgr, CVC4RationalFormulaManager pRfmgr, CVC4BitvectorFormulaManager pBvfmgr, CVC4FloatingPointFormulaManager pFpfmgr, CVC4ArrayFormulaManager pAfmgr, CVC4SLFormulaManager pSLfmgr) {
        super(pFormulaCreator, pFfmgr, pBfmgr, pIfmgr, pRfmgr, pBvfmgr, pFpfmgr, null, pAfmgr, pSLfmgr);
        this.creator = pFormulaCreator;
    }

    static Expr getCVC4Expr(Formula pT) {
        if (pT instanceof CVC4Formula) {
            return ((CVC4Formula)pT).getTerm();
        }
        throw new IllegalArgumentException("Cannot get the formula info of type " + pT.getClass().getSimpleName() + " in the Solver!");
    }

    @Override
    public BooleanFormula parse(String pS) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Appender dumpFormula(final Expr f) {
        assert (this.getFormulaCreator().getFormulaType(f) == FormulaType.BooleanType) : "Only BooleanFormulas may be dumped";
        return new Appenders.AbstractAppender(){

            public void appendTo(final Appendable out) throws IOException {
                LinkedHashMap allVars = new LinkedHashMap();
                CVC4FormulaManager.this.creator.extractVariablesAndUFs(f, true, allVars::put);
                for (Map.Entry entry : allVars.entrySet()) {
                    String name = (String)entry.getKey();
                    Expr var = (Expr)entry.getValue();
                    out.append("(declare-fun ").append(PrintTerm.quoteIdentifier((String)name)).append(" (");
                    ArrayList<Type> childrenTypes = new ArrayList<Type>();
                    int i = 0;
                    while ((long)i < var.getNumChildren()) {
                        childrenTypes.add(var.getChild((long)i).getType());
                        ++i;
                    }
                    out.append(Joiner.on((String)" ").join(childrenTypes));
                    out.append(") ").append(var.getType().toString()).append(")\n");
                }
                out.append("(assert ");
                try (OutputStream stream = new OutputStream(){

                    @Override
                    public void write(int chr) throws IOException {
                        out.append((char)chr);
                    }
                };){
                    f.toStream(stream);
                }
                out.append(')');
            }
        };
    }
}

