/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class Sudoku {
    public static final int SIZE = 9;
    private static final int BLOCKSIZE = 3;
    private static final Integer[][] UNSOLVABLE_SUDOKU = null;

    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException, IOException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.MATHSAT5;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);){
            Integer[][] grid = Sudoku.readGridFromStdin();
            IntegerBasedSudokuSolver sudoku = new IntegerBasedSudokuSolver(context);
            Integer[][] solution = sudoku.solve(grid);
            if (solution == UNSOLVABLE_SUDOKU) {
                System.out.println("Sudoku has no solution.");
            } else {
                System.out.println("Sudoku has a solution:");
                for (Object[] objectArray : solution) {
                    System.out.println(Joiner.on((String)"").join(objectArray));
                }
            }
        }
    }

    private Sudoku() {
    }

    private static Integer[][] readGridFromStdin() {
        Integer[][] grid = new Integer[9][9];
        System.out.println("Insert Sudoku:");
        Scanner s = new Scanner(System.in, Charset.defaultCharset().name());
        for (int row = 0; row < 9; ++row) {
            String line = s.nextLine().trim();
            for (int col = 0; col < Math.min(line.length(), 9); ++col) {
                char nextNumber = line.charAt(col);
                if ('0' > nextNumber || nextNumber > '9') continue;
                grid[row][col] = nextNumber - 48;
            }
        }
        return grid;
    }

    public static class BooleanBasedSudokuSolver
    extends SudokuSolver<BooleanFormula[][][]> {
        private BooleanBasedSudokuSolver(SolverContext context) {
            super(context);
        }

        @Override
        BooleanFormula[][][] getSymbols() {
            BooleanFormula[][][] symbols = new BooleanFormula[9][9][9];
            for (int row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    for (int value = 0; value < 9; ++value) {
                        symbols[row][col][value] = this.bmgr.makeVariable("x_" + row + "_" + col + "_" + value);
                    }
                }
            }
            return symbols;
        }

        @Override
        List<BooleanFormula> getRules(BooleanFormula[][][] symbols) {
            ArrayList<BooleanFormula> lst;
            int value;
            int row;
            ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
            for (row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    rules.add(this.oneHot((List<BooleanFormula>)ImmutableList.copyOf((Object[])symbols[row][col])));
                }
            }
            for (row = 0; row < 9; ++row) {
                for (value = 0; value < 9; ++value) {
                    lst = new ArrayList<BooleanFormula>();
                    for (int col = 0; col < 9; ++col) {
                        lst.add(symbols[row][col][value]);
                    }
                    rules.add(this.oneHot(lst));
                }
            }
            for (int col = 0; col < 9; ++col) {
                for (value = 0; value < 9; ++value) {
                    lst = new ArrayList();
                    for (int row2 = 0; row2 < 9; ++row2) {
                        lst.add(symbols[row2][col][value]);
                    }
                    rules.add(this.oneHot(lst));
                }
            }
            for (int rowB = 0; rowB < 9; rowB += 3) {
                for (int colB = 0; colB < 9; colB += 3) {
                    for (int value2 = 0; value2 < 9; ++value2) {
                        ArrayList<BooleanFormula> lst2 = new ArrayList<BooleanFormula>();
                        for (int row3 = rowB; row3 < rowB + 3; ++row3) {
                            for (int col = colB; col < colB + 3; ++col) {
                                lst2.add(symbols[row3][col][value2]);
                            }
                        }
                        rules.add(this.oneHot(lst2));
                    }
                }
            }
            return rules;
        }

        private BooleanFormula oneHot(List<BooleanFormula> vars) {
            ArrayList<BooleanFormula> oneHot = new ArrayList<BooleanFormula>();
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < i; ++j) {
                    oneHot.add(this.bmgr.not(this.bmgr.and(vars.get(i), vars.get(j))));
                }
            }
            oneHot.add(this.bmgr.or(vars));
            return this.bmgr.and(oneHot);
        }

        @Override
        List<BooleanFormula> getAssignments(BooleanFormula[][][] symbols, Integer[][] grid) {
            ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
            for (int row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    Integer value = grid[row][col];
                    if (value == null) continue;
                    assignments.add(symbols[row][col][value - 1]);
                }
            }
            return assignments;
        }

        @Override
        Integer getValue(BooleanFormula[][][] symbols, Model model, int row, int col) {
            for (int value = 0; value < 9; ++value) {
                if (!model.evaluate(symbols[row][col][value]).booleanValue()) continue;
                return value + 1;
            }
            return null;
        }
    }

    public static class IntegerBasedSudokuSolver
    extends SudokuSolver<NumeralFormula.IntegerFormula[][]> {
        public IntegerBasedSudokuSolver(SolverContext context) {
            super(context);
        }

        @Override
        NumeralFormula.IntegerFormula[][] getSymbols() {
            NumeralFormula.IntegerFormula[][] symbols = new NumeralFormula.IntegerFormula[9][9];
            for (int row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    symbols[row][col] = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x_" + row + "_" + col);
                }
            }
            return symbols;
        }

        @Override
        List<BooleanFormula> getRules(NumeralFormula.IntegerFormula[][] symbols) {
            int row;
            ArrayList<BooleanFormula> rules = new ArrayList<BooleanFormula>();
            NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
            NumeralFormula.IntegerFormula nine = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(9L);
            for (row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    for (int i = 0; i < 9; ++i) {
                        rules.add(this.imgr.lessOrEquals(one, symbols[row][col]));
                        rules.add(this.imgr.lessOrEquals(symbols[row][col], nine));
                    }
                }
            }
            for (row = 0; row < 9; ++row) {
                ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int col = 0; col < 9; ++col) {
                    lst.add(symbols[row][col]);
                }
                rules.add(this.imgr.distinct(lst));
            }
            for (int col = 0; col < 9; ++col) {
                ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                for (int row2 = 0; row2 < 9; ++row2) {
                    lst.add(symbols[row2][col]);
                }
                rules.add(this.imgr.distinct(lst));
            }
            for (int rowB = 0; rowB < 9; rowB += 3) {
                for (int colB = 0; colB < 9; colB += 3) {
                    ArrayList<NumeralFormula.IntegerFormula> lst = new ArrayList<NumeralFormula.IntegerFormula>();
                    for (int row3 = rowB; row3 < rowB + 3; ++row3) {
                        for (int col = colB; col < colB + 3; ++col) {
                            lst.add(symbols[row3][col]);
                        }
                    }
                    rules.add(this.imgr.distinct(lst));
                }
            }
            return rules;
        }

        @Override
        List<BooleanFormula> getAssignments(NumeralFormula.IntegerFormula[][] symbols, Integer[][] grid) {
            ArrayList<BooleanFormula> assignments = new ArrayList<BooleanFormula>();
            for (int row = 0; row < 9; ++row) {
                for (int col = 0; col < 9; ++col) {
                    Integer value = grid[row][col];
                    if (value == null) continue;
                    assignments.add(this.imgr.equal(symbols[row][col], (NumeralFormula.IntegerFormula)this.imgr.makeNumber(value.intValue())));
                }
            }
            return assignments;
        }

        @Override
        Integer getValue(NumeralFormula.IntegerFormula[][] symbols, Model model, int row, int col) {
            return model.evaluate(symbols[row][col]).intValue();
        }
    }

    public static abstract class SudokuSolver<S> {
        private final SolverContext context;
        final BooleanFormulaManager bmgr;
        final IntegerFormulaManager imgr;

        private SudokuSolver(SolverContext pContext) {
            this.context = pContext;
            this.bmgr = this.context.getFormulaManager().getBooleanFormulaManager();
            this.imgr = this.context.getFormulaManager().getIntegerFormulaManager();
        }

        abstract S getSymbols();

        abstract List<BooleanFormula> getRules(S var1);

        abstract List<BooleanFormula> getAssignments(S var1, Integer[][] var2);

        abstract Integer getValue(S var1, Model var2, int var3, int var4);

        public @Nullable Integer[][] solve(Integer[][] grid) throws InterruptedException, SolverException {
            S symbols = this.getSymbols();
            List<BooleanFormula> rules = this.getRules(symbols);
            List<BooleanFormula> assignments = this.getAssignments(symbols, grid);
            try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
                prover.push(this.bmgr.and(rules));
                prover.push(this.bmgr.and(assignments));
                boolean isUnsolvable = prover.isUnsat();
                if (isUnsolvable) {
                    Integer[][] integerArray = UNSOLVABLE_SUDOKU;
                    return integerArray;
                }
                Integer[][] solution = new Integer[9][9];
                try (Model model = prover.getModel();){
                    for (int row = 0; row < 9; ++row) {
                        for (int col = 0; col < 9; ++col) {
                            solution[row][col] = this.getValue(symbols, model, row, col);
                        }
                    }
                }
                Integer[][] integerArray = solution;
                return integerArray;
            }
        }
    }
}

