/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolFormulaManager;
import org.sosy_lab.java_smt.solvers.smtinterpol.SmtInterpolInterpolatingProver;

class LoggingSmtInterpolInterpolatingProver
extends SmtInterpolInterpolatingProver {
    private final PrintWriter out;

    LoggingSmtInterpolInterpolatingProver(SmtInterpolFormulaManager pMgr, Set<SolverContext.ProverOptions> pOptions, PrintWriter pOut) {
        super(pMgr, pOptions);
        this.out = (PrintWriter)Preconditions.checkNotNull((Object)pOut);
    }

    @Override
    public void push() {
        this.out.println("(push 1)");
        super.push();
    }

    @Override
    public void pop() {
        this.out.println("(pop 1)");
        super.pop();
    }

    @Override
    public String addConstraint(BooleanFormula f) {
        String result = super.addConstraint(f);
        this.out.println("(assert (! " + f + " :named " + result + "))");
        return result;
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        this.out.println("(get-unsat-core)");
        return super.getUnsatCore();
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> predicates) throws InterruptedException, SolverException {
        this.out.println("(all-sat (" + Joiner.on((String)", ").join(predicates) + "))");
        return super.allSat(callback, predicates);
    }

    @Override
    public boolean isUnsat() throws InterruptedException {
        this.out.print("(check-sat)");
        boolean isUnsat = super.isUnsat();
        this.out.println(" ; " + (isUnsat ? "UNSAT" : "SAT"));
        return isUnsat;
    }

    @Override
    public List<BooleanFormula> getTreeInterpolants(List<? extends Collection<String>> partitionedTermNames, int[] startOfSubTree) throws SolverException, InterruptedException {
        Preconditions.checkArgument((partitionedTermNames.size() == startOfSubTree.length ? 1 : 0) != 0);
        this.out.print("(get-interpolants");
        ArrayDeque<Integer> subtrees = new ArrayDeque<Integer>();
        for (int i = 0; i < startOfSubTree.length; ++i) {
            Collection<String> names = partitionedTermNames.get(i);
            int currentStartOfSubtree = startOfSubTree[i];
            Object currentTerms = names.size() == 1 ? names.iterator().next() : "(and " + Joiner.on((String)" ").join(names) + ")";
            while (!subtrees.isEmpty() && (Integer)subtrees.peek() > currentStartOfSubtree) {
                subtrees.pop();
                this.out.print(")");
            }
            this.out.print(" ");
            if (!subtrees.isEmpty() && (Integer)subtrees.peek() < currentStartOfSubtree) {
                subtrees.push(currentStartOfSubtree);
                this.out.print("(");
            }
            if (subtrees.isEmpty()) {
                subtrees.push(currentStartOfSubtree);
            }
            this.out.print((String)currentTerms);
        }
        this.out.print(") ; subtrees=" + Arrays.toString(startOfSubTree));
        List<BooleanFormula> result = super.getTreeInterpolants(partitionedTermNames, startOfSubTree);
        this.out.println(" ; interpolants=" + result);
        return result;
    }

    @Override
    public void close() {
        this.out.close();
        super.close();
    }
}

