/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.smtinterpol;

import com.google.common.base.Preconditions;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class FormulaCollectionScript
implements Script {
    private final Theory theory;
    private final Script script;
    private final List<Term> assertedTerms = new ArrayList<Term>(1);

    FormulaCollectionScript(Script pScript, Theory pTheory) {
        this.script = (Script)Preconditions.checkNotNull((Object)pScript);
        this.theory = (Theory)Preconditions.checkNotNull((Object)pTheory);
    }

    public List<Term> getAssertedTerms() {
        return Collections.unmodifiableList(this.assertedTerms);
    }

    public Script.LBool assertTerm(Term pTerm) throws SMTLIBException {
        this.assertedTerms.add(pTerm);
        return Script.LBool.UNKNOWN;
    }

    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        FunctionSymbol fsym = this.theory.getFunction(fun, paramSorts);
        if (fsym == null) {
            this.script.declareFun(fun, paramSorts, resultSort);
        } else if (!fsym.getReturnSort().equals(resultSort)) {
            throw new SMTLIBException("Function " + fun + " is already declared with different definition");
        }
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        Sort[] paramSorts = new Sort[params.length];
        for (int i = 0; i < paramSorts.length; ++i) {
            paramSorts[i] = params[i].getSort();
        }
        FunctionSymbol fsym = this.theory.getFunction(fun, paramSorts);
        if (fsym == null) {
            this.script.defineFun(fun, params, resultSort, definition);
        } else if (!fsym.getDefinition().equals(definition) || !fsym.getReturnSort().equals(resultSort)) {
            throw new SMTLIBException("Function " + fun + " is already defined with different definition");
        }
    }

    public void setInfo(String info, Object value) {
        this.script.setInfo(info, value);
    }

    public void declareSort(String sort, int arity) throws SMTLIBException {
        this.script.declareSort(sort, arity);
    }

    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        this.script.defineSort(sort, sortParams, definition);
    }

    public Sort sort(String sortname, Sort ... params) throws SMTLIBException {
        return this.script.sort(sortname, params);
    }

    public Sort sort(String sortname, String[] indices, Sort ... params) throws SMTLIBException {
        return this.script.sort(sortname, indices, params);
    }

    public Term term(String funcname, Term ... params) throws SMTLIBException {
        Term result = this.script.term(funcname, params);
        return this.replaceWithDefinition(result);
    }

    public Term term(String funcname, String[] indices, Sort returnSort, Term ... params) throws SMTLIBException {
        Term result = this.script.term(funcname, indices, returnSort, params);
        return this.replaceWithDefinition(result);
    }

    private Term replaceWithDefinition(Term result) {
        FunctionSymbol func;
        if (result instanceof ApplicationTerm && !(func = ((ApplicationTerm)result).getFunction()).isIntern() && func.getDefinition() != null) {
            if (func.getParameterSorts().length == 0) {
                result = func.getDefinition();
            } else {
                throw new SMTLIBException("Terms with definitions are not supported currently.");
            }
        }
        return result;
    }

    public TermVariable variable(String varname, Sort sort) throws SMTLIBException {
        return this.script.variable(varname, sort);
    }

    public Term quantifier(int quantor, TermVariable[] vars, Term body, Term[] ... patterns) throws SMTLIBException {
        return this.script.quantifier(quantor, vars, body, patterns);
    }

    public Term let(TermVariable[] vars, Term[] values, Term body) throws SMTLIBException {
        return this.script.let(vars, values, body);
    }

    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        return this.script.annotate(t, annotations);
    }

    public Term numeral(String num) throws SMTLIBException {
        return this.script.numeral(num);
    }

    public Term numeral(BigInteger num) throws SMTLIBException {
        return this.script.numeral(num);
    }

    public Term decimal(String decimal) throws SMTLIBException {
        return this.script.decimal(decimal);
    }

    public Term decimal(BigDecimal decimal) throws SMTLIBException {
        return this.script.decimal(decimal);
    }

    public Term string(QuotedObject pStr) throws SMTLIBException {
        return this.script.string(pStr);
    }

    public Term hexadecimal(String hex) throws SMTLIBException {
        return this.script.hexadecimal(hex);
    }

    public Term binary(String bin) throws SMTLIBException {
        return this.script.binary(bin);
    }

    public Sort[] sortVariables(String ... names) throws SMTLIBException {
        return this.script.sortVariables(names);
    }

    public Term[] getAssertions() throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getOption(String opt) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getInfo(String info) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term simplify(Term term) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void push(int levels) {
        throw new UnsupportedOperationException();
    }

    public void pop(int levels) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setLogic(String logic) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Term[] getInterpolants(Term[] pPartition, int[] pStartOfSubtree, Term pProofTree) throws SMTLIBException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Script.LBool checkSat() {
        throw new UnsupportedOperationException();
    }

    public Iterable<Term[]> checkAllsat(Term[] pPredicates) {
        throw new UnsupportedOperationException();
    }

    public Script.LBool checkSatAssuming(Term ... pAssumptions) {
        throw new UnsupportedOperationException();
    }

    public Term[] getUnsatAssumptions() {
        throw new UnsupportedOperationException();
    }

    public void resetAssertions() {
        throw new UnsupportedOperationException();
    }

    public Term[] findImpliedEquality(Term[] pX, Term[] pY) {
        throw new UnsupportedOperationException();
    }

    public void exit() {
        throw new UnsupportedOperationException();
    }

    public QuotedObject echo(QuotedObject pMsg) {
        throw new UnsupportedOperationException();
    }

    public FunctionSymbol getFunctionSymbol(String pConstructor) {
        throw new UnsupportedOperationException();
    }

    public DataType.Constructor constructor(String pName, String[] pSelectors, Sort[] pArgumentSorts) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public DataType datatype(String pTypename, int pNumParams) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void declareDatatype(DataType pDatatype, DataType.Constructor[] pConstrs) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public void declareDatatypes(DataType[] pDatatypes, DataType.Constructor[][] pConstrs, Sort[][] pSortParams) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public Term match(Term pDataArg, TermVariable[][] pVars, Term[] pCases, DataType.Constructor[] pConstructors) throws SMTLIBException {
        throw new UnsupportedOperationException();
    }

    public Theory getTheory() {
        return this.theory;
    }
}

