/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.SimpleAPI;
import ap.parser.IAtom;
import ap.parser.IConstant;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntFormula;
import ap.parser.ITerm;
import ap.parser.SMTLineariser;
import ap.theories.SimpleArray;
import ap.types.MonoSortedIFunction;
import ap.types.Sort;
import ap.types.Sort$;
import ap.util.Debug;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.Appenders;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathCounterTemplate;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.solvers.princess.PrincessAbstractProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaCreator;
import org.sosy_lab.java_smt.solvers.princess.PrincessFormulaManager;
import org.sosy_lab.java_smt.solvers.princess.PrincessInterpolatingProver;
import org.sosy_lab.java_smt.solvers.princess.PrincessTheoremProver;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

@Options(prefix="solver.princess")
class PrincessEnvironment {
    @org.sosy_lab.common.configuration.Option(secure=true, description="The number of atoms a term has to have before it gets abbreviated if there are more identical terms.")
    private int minAtomsForAbbreviation = 100;
    public static final Sort BOOL_SORT = Sort$.MODULE$.Bool();
    public static final Sort INTEGER_SORT = Sort.Integer$.MODULE$;
    @org.sosy_lab.common.configuration.Option(secure=true, description="log all queries as Princess-specific Scala code")
    private boolean logAllQueriesAsScala = false;
    @org.sosy_lab.common.configuration.Option(secure=true, description="file for Princess-specific dump of queries as Scala code")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathCounterTemplate logAllQueriesAsScalaFile = PathCounterTemplate.ofFormatString((String)"princess-query-%03d-");
    private final java.util.Map<String, IFormula> boolVariablesCache = new HashMap<String, IFormula>();
    private final java.util.Map<String, ITerm> sortedVariablesCache = new HashMap<String, ITerm>();
    private final java.util.Map<String, IFunction> functionsCache = new HashMap<String, IFunction>();
    private final int randomSeed;
    private final @Nullable PathCounterTemplate basicLogfile;
    private final ShutdownNotifier shutdownNotifier;
    private final SimpleAPI api;
    private final List<PrincessAbstractProver<?, ?>> registeredProvers = new ArrayList();

    PrincessEnvironment(Configuration config, @Nullable PathCounterTemplate pBasicLogfile, ShutdownNotifier pShutdownNotifier, int pRandomSeed) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.basicLogfile = pBasicLogfile;
        this.shutdownNotifier = pShutdownNotifier;
        this.randomSeed = pRandomSeed;
        this.api = this.getNewApi(false);
    }

    PrincessAbstractProver<?, ?> getNewProver(boolean useForInterpolation, PrincessFormulaManager mgr, PrincessFormulaCreator creator, Set<SolverContext.ProverOptions> pOptions) {
        SimpleAPI newApi = this.getNewApi(useForInterpolation || pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE));
        this.boolVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addBooleanVariable(arg_0));
        this.sortedVariablesCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addConstant(arg_0));
        this.functionsCache.values().forEach(arg_0 -> ((SimpleAPI)newApi).addFunction(arg_0));
        PrincessAbstractProver prover = useForInterpolation ? new PrincessInterpolatingProver(mgr, creator, newApi, this.shutdownNotifier, pOptions) : new PrincessTheoremProver(mgr, creator, newApi, this.shutdownNotifier, pOptions);
        this.registeredProvers.add(prover);
        return prover;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private SimpleAPI getNewApi(boolean constructProofs) {
        Path logPath;
        File directory = null;
        Object smtDumpBasename = null;
        String scalaDumpBasename = null;
        if (this.basicLogfile != null) {
            logPath = this.basicLogfile.getFreshPath();
            directory = this.getAbsoluteParent(logPath);
            smtDumpBasename = logPath.getFileName().toString();
            if (Files.getFileExtension((String)smtDumpBasename).equals("smt2")) {
                smtDumpBasename = Files.getNameWithoutExtension((String)smtDumpBasename);
            }
            smtDumpBasename = (String)smtDumpBasename + "-";
        }
        if (this.logAllQueriesAsScala && this.logAllQueriesAsScalaFile != null) {
            logPath = this.logAllQueriesAsScalaFile.getFreshPath();
            if (directory == null) {
                directory = this.getAbsoluteParent(logPath);
            }
            scalaDumpBasename = logPath.getFileName().toString();
        }
        Debug.enableAllAssertions((boolean)true);
        SimpleAPI newApi = SimpleAPI.apply((boolean)true, (boolean)false, (smtDumpBasename != null ? 1 : 0) != 0, (String)smtDumpBasename, (scalaDumpBasename != null ? 1 : 0) != 0, (String)scalaDumpBasename, (File)directory, (boolean)SimpleAPI.apply$default$8(), (boolean)SimpleAPI.apply$default$9(), (Option)new Some((Object)this.randomSeed));
        if (constructProofs) {
            newApi.setConstructProofs(true);
        }
        return newApi;
    }

    private File getAbsoluteParent(Path path) {
        return Optional.ofNullable(path.getParent()).orElse(Paths.get(".", new String[0])).toAbsolutePath().toFile();
    }

    int getMinAtomsForAbbreviation() {
        return this.minAtomsForAbbreviation;
    }

    void unregisterStack(PrincessAbstractProver<?, ?> stack) {
        assert (this.registeredProvers.contains(stack)) : "cannot unregister stack, it is not registered";
        this.registeredProvers.remove(stack);
    }

    void close() {
        for (PrincessAbstractProver prover : ImmutableList.copyOf(this.registeredProvers)) {
            prover.close();
        }
        this.api.shutDown();
        this.api.reset();
        Preconditions.checkState((boolean)this.registeredProvers.isEmpty());
    }

    public List<? extends IExpression> parseStringToTerms(String s, PrincessFormulaCreator creator) {
        Tuple3 triple = this.api.extractSMTLIBAssertionsSymbols((Reader)new StringReader(s));
        List formula = JavaConverters.asJava((Seq)((Seq)triple._1()));
        ImmutableSet.Builder declaredFunctions = ImmutableSet.builder();
        for (IExpression f : formula) {
            declaredFunctions.addAll(creator.extractVariablesAndUFs(f, true).values());
        }
        for (IExpression var : declaredFunctions.build()) {
            if (var instanceof IConstant) {
                this.sortedVariablesCache.put(var.toString(), (ITerm)var);
                this.addSymbol((ITerm)((IConstant)var));
                continue;
            }
            if (var instanceof IAtom) {
                this.boolVariablesCache.put(((IAtom)var).pred().name(), (IFormula)var);
                this.addSymbol((IFormula)((IAtom)var));
                continue;
            }
            if (!(var instanceof IFunApp)) continue;
            IFunction fun = ((IFunApp)var).fun();
            this.functionsCache.put(fun.name(), fun);
            this.addFunction(fun);
        }
        return formula;
    }

    public Appender dumpFormula(IFormula formula, final PrincessFormulaCreator creator) {
        Tuple2 tuple = this.api.abbrevSharedExpressionsWithMap((IExpression)formula, 1);
        final IExpression lettedFormula = (IExpression)tuple._1();
        final java.util.Map abbrevMap = JavaConverters.asJava((Map)((Map)tuple._2()));
        return new Appenders.AbstractAppender(){

            public void appendTo(Appendable out) throws IOException {
                Object allVars = ImmutableSet.copyOf(creator.extractVariablesAndUFs(lettedFormula, true).values());
                ArrayDeque declaredFunctions = new ArrayDeque(allVars);
                allVars = new HashSet(allVars);
                HashSet<String> doneFunctions = new HashSet<String>();
                HashSet<String> todoAbbrevs = new HashSet<String>();
                while (!declaredFunctions.isEmpty()) {
                    IExpression var = (IExpression)declaredFunctions.poll();
                    String name = PrincessEnvironment.getName(var);
                    if (doneFunctions.contains(name)) continue;
                    doneFunctions.add(name);
                    if (name.startsWith("abbrev_")) {
                        todoAbbrevs.add(name);
                        ImmutableSet varsFromAbbrev = ImmutableSet.copyOf(creator.extractVariablesAndUFs((IExpression)abbrevMap.get(var), true).values());
                        Sets.difference((Set)varsFromAbbrev, (Set)allVars).forEach(declaredFunctions::push);
                        allVars.addAll(varsFromAbbrev);
                        continue;
                    }
                    out.append("(declare-fun ").append(SMTLineariser.quoteIdentifier((String)name));
                    out.append(" (");
                    if (var instanceof IFunApp) {
                        IFunApp function = (IFunApp)var;
                        Iterator args = JavaConverters.asJava((Seq)function.args()).iterator();
                        while (args.hasNext()) {
                            args.next();
                            if (args.hasNext()) {
                                out.append("Int ");
                                continue;
                            }
                            out.append("Int");
                        }
                    }
                    out.append(") ");
                    out.append(PrincessEnvironment.getType(var));
                    out.append(")\n");
                }
                for (Map.Entry entry : abbrevMap.entrySet()) {
                    IExpression abbrev = (IExpression)entry.getKey();
                    IExpression fullFormula = (IExpression)entry.getValue();
                    String name = PrincessEnvironment.getName((IExpression)Iterables.getOnlyElement(creator.extractVariablesAndUFs(abbrev, true).values()));
                    if (!todoAbbrevs.contains(name)) continue;
                    out.append("(define-fun ").append(SMTLineariser.quoteIdentifier((String)name));
                    if (fullFormula instanceof IFormula) {
                        out.append(" () Bool ");
                    } else if (fullFormula instanceof ITerm) {
                        out.append(" () Int ");
                    }
                    out.append(SMTLineariser.asString((IExpression)fullFormula)).append(" )\n");
                }
                out.append("(assert ").append(SMTLineariser.asString((IExpression)lettedFormula)).append(')');
            }
        };
    }

    private static String getName(IExpression var) {
        if (var instanceof IAtom) {
            return ((IAtom)var).pred().name();
        }
        if (var instanceof IConstant) {
            return var.toString();
        }
        if (var instanceof IFunApp) {
            String fullStr = ((IFunApp)var).fun().toString();
            return fullStr.substring(0, fullStr.indexOf(47));
        }
        if (var instanceof IIntFormula) {
            return PrincessEnvironment.getName((IExpression)((IIntFormula)var).t());
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    private static String getType(IExpression var) {
        if (var instanceof IFormula) {
            return "Bool";
        }
        if (var instanceof ITerm) {
            return "Int";
        }
        throw new IllegalArgumentException("The given parameter is no variable or function");
    }

    public IExpression makeVariable(Sort type, String varname) {
        if (type == BOOL_SORT) {
            if (this.boolVariablesCache.containsKey(varname)) {
                return (IExpression)this.boolVariablesCache.get(varname);
            }
            IFormula var = this.api.createBooleanVariable(varname);
            this.addSymbol(var);
            this.boolVariablesCache.put(varname, var);
            return var;
        }
        if (this.sortedVariablesCache.containsKey(varname)) {
            return (IExpression)this.sortedVariablesCache.get(varname);
        }
        ITerm var = this.api.createConstant(varname, type);
        this.addSymbol(var);
        this.sortedVariablesCache.put(varname, var);
        return var;
    }

    public IFunction declareFun(String name, Sort returnType, List<Sort> args) {
        if (this.functionsCache.containsKey(name)) {
            IFunction res = this.functionsCache.get(name);
            assert (!(res instanceof MonoSortedIFunction) ? returnType == INTEGER_SORT && res.arity() == args.size() && args.stream().allMatch(s -> s == INTEGER_SORT) : ((MonoSortedIFunction)res).resSort().equals(returnType) && JavaConverters.asJava((Seq)((MonoSortedIFunction)res).argSorts()).equals(args));
            return res;
        }
        IFunction funcDecl = this.api.createFunction(name, ((Iterable)JavaConverters.collectionAsScalaIterableConverter(args).asScala()).toSeq(), returnType, false, SimpleAPI.FunctionalityMode$.MODULE$.Full());
        this.addFunction(funcDecl);
        this.functionsCache.put(name, funcDecl);
        return funcDecl;
    }

    public ITerm makeSelect(ITerm array, ITerm index) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index);
        return this.api.select(((Iterable)JavaConverters.collectionAsScalaIterableConverter((Collection)args).asScala()).toSeq());
    }

    public ITerm makeStore(ITerm array, ITerm index, ITerm value) {
        ImmutableList args = ImmutableList.of((Object)array, (Object)index, (Object)value);
        return this.api.store(((Iterable)JavaConverters.collectionAsScalaIterableConverter((Collection)args).asScala()).toSeq());
    }

    public boolean hasArrayType(IExpression exp) {
        if (exp instanceof ITerm) {
            ITerm t = (ITerm)exp;
            return Sort$.MODULE$.sortOf(t) instanceof SimpleArray.ArraySort;
        }
        return false;
    }

    public IFormula elimQuantifiers(IFormula formula) {
        return this.api.simplify(formula);
    }

    private void addSymbol(IFormula symbol) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(symbol);
        }
    }

    private void addSymbol(ITerm symbol) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(symbol);
        }
    }

    private void addFunction(IFunction funcDecl) {
        for (PrincessAbstractProver<?, ?> prover : this.registeredProvers) {
            prover.addSymbol(funcDecl);
        }
    }
}

