/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.delegate.synchronize;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;

class SynchronizedModelWithContext
implements Model {
    private static final String UNSUPPORTED_OPERATION = "translating non-boolean formulae is not supported";
    private final Model delegate;
    private final SolverContext sync;
    private final FormulaManager manager;
    private final FormulaManager otherManager;

    SynchronizedModelWithContext(Model pDelegate, SolverContext pSync, FormulaManager pManager, FormulaManager pOtherManager) {
        this.delegate = (Model)Preconditions.checkNotNull((Object)pDelegate);
        this.sync = (SolverContext)Preconditions.checkNotNull((Object)pSync);
        this.manager = (FormulaManager)Preconditions.checkNotNull((Object)pManager);
        this.otherManager = (FormulaManager)Preconditions.checkNotNull((Object)pOtherManager);
    }

    @Override
    public <T extends Formula> @Nullable T eval(T pFormula) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public @Nullable Object evaluate(Formula pF) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public @Nullable BigInteger evaluate(NumeralFormula.IntegerFormula pF) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public @Nullable Rational evaluate(NumeralFormula.RationalFormula pF) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Boolean evaluate(BooleanFormula pF) {
        BooleanFormula f;
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            f = this.otherManager.translateFrom(pF, this.manager);
        }
        return this.delegate.evaluate(f);
    }

    @Override
    public @Nullable BigInteger evaluate(BitvectorFormula pF) {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    @Override
    public ImmutableList<Model.ValueAssignment> asList() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        SolverContext solverContext = this.sync;
        synchronized (solverContext) {
            this.delegate.close();
        }
    }
}

