/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.AbstractFormulaManager;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class VariableNamesTest
extends SolverBasedTest0 {
    private static final ImmutableList<String> NAMES = ImmutableList.of((Object)"java-smt", (Object)"JavaSMT", (Object)"sosylab", (Object)"test", (Object)"foo", (Object)"bar", (Object)"baz", (Object)"declare", (Object)"exit", (Object)"(exit)", (Object)"!=", (Object)"~", (Object[])new String[]{",", ".", ":", " ", "  ", "(", ")", "[", "]", "{", "}", "[]", "\"", "\"\"", "\"\"\"", "\n", "\t", "\u0000", "\u0001", "\u1234", "\u2e80", " this is a quoted symbol ", " so is \n  this one ", " \" can occur too ", " af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984"});
    private static final ImmutableSet<String> FURTHER_SMTLIB2_KEYWORDS = ImmutableSet.of((Object)"let", (Object)"forall", (Object)"exists", (Object)"match", (Object)"Bool", (Object)"continued-execution", (Object[])new String[]{"error", "immediate-exit", "incomplete", "logic", "memout", "sat", "success", "theory", "unknown", "unsupported", "unsat", "_", "as", "BINARY", "DECIMAL", "exists", "HEXADECIMAL", "forall", "let", "match", "NUMERAL", "par", "STRING", "assert", "check-sat", "check-sat-assuming", "declare-const", "declare-datatype", "declare-datatypes", "declare-fun", "declare-sort", "define-fun", "define-fun-rec", "define-sort", "echo", "exit", "get-assertions", "get-assignment", "get-info", "get-model", "get-option", "get-proof", "get-unsat-assumptions", "get-unsat-core", "get-value", "pop", "push", "reset", "reset-assertions", "set-info", "set-logic", "set-option"});
    private static final ImmutableSet<String> UNSUPPORTED_NAMES = ImmutableSet.of((Object)"|", (Object)"||", (Object)"|||", (Object)"|test", (Object)"|test|", (Object)"t|e|s|t", (Object[])new String[]{"\\", "\\s", "\\|\\|", "\\", "| this is a quoted symbol |", "| so is \n  this one |", "| \" can occur too |", "| af klj ^*0 asfe2 (&*)&(#^ $ > > >?\" \u2019]]984|"});
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public String varname;

    @Parameterized.Parameters(name="{0} with varname {1}")
    public static List<Object[]> getAllCombinations() {
        ImmutableList allNames = ImmutableList.builder().addAll(NAMES).addAll(Iterables.transform(NAMES, n -> n + n + n)).addAll(AbstractFormulaManager.BASIC_OPERATORS).addAll(Iterables.transform(AbstractFormulaManager.BASIC_OPERATORS, n -> n + n + n)).addAll(AbstractFormulaManager.SMTLIB2_KEYWORDS).addAll((Iterable)AbstractFormulaManager.DISALLOWED_CHARACTER_REPLACEMENT.values()).addAll(FURTHER_SMTLIB2_KEYWORDS).addAll(UNSUPPORTED_NAMES).build();
        return Lists.transform((List)Lists.cartesianProduct((List[])new List[]{Arrays.asList(SolverContextFactory.Solvers.values()), allNames}), List::toArray);
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    boolean allowInvalidNames() {
        return true;
    }

    String getVarname() {
        return this.varname;
    }

    @CanIgnoreReturnValue
    private <T extends Formula> T createVariableWith(Function<String, T> creator, String name) {
        Formula result;
        if (this.allowInvalidNames() && !this.mgr.isValidName(name)) {
            try {
                result = (Formula)creator.apply(name);
                Truth.assert_().fail();
            }
            catch (IllegalArgumentException e) {
                throw new AssumptionViolatedException("unsupported variable name", (Throwable)e);
            }
        } else {
            result = (Formula)creator.apply(name);
        }
        return (T)result;
    }

    @Test
    public void testBoolVariable() {
        this.createVariableWith(this.bmgr::makeVariable, this.getVarname());
    }

    private <T extends Formula> void testName0(Function<String, T> creator, BiFunction<T, T, BooleanFormula> eq, boolean isUF) throws SolverException, InterruptedException {
        this.requireVisitor();
        T var = this.createVariableWith(creator, this.getVarname());
        Map<String, Formula> map = this.mgr.extractVariables((Formula)var);
        if (isUF) {
            Truth.assertThat(map).isEmpty();
            map = this.mgr.extractVariablesAndUFs((Formula)var);
        }
        Truth.assertThat(map).hasSize(1);
        Truth.assertThat(map).containsEntry((Object)this.getVarname(), var);
        T var2 = this.createVariableWith(creator, this.getVarname());
        Truth.assertThat(var2).isEqualTo(var);
        Truth.assertThat((String)var2.toString()).isEqualTo((Object)var.toString());
        this.assertThatFormula(eq.apply(var, var2)).isSatisfiable();
        if (var instanceof FloatingPointFormula) {
            this.assertThatFormula(this.bmgr.not(eq.apply(var, var2))).isSatisfiable();
        } else {
            this.assertThatFormula(this.bmgr.not(eq.apply(var, var2))).isUnsatisfiable();
            this.assertThatFormula(eq.apply(var, var2)).isSatisfiable(true);
        }
        String dump = this.mgr.dumpFormula(eq.apply(var, var)).toString();
        if (this.allowInvalidNames()) {
            T var3 = this.createVariableWith(creator, "|" + this.getVarname() + "|");
            Truth.assert_().fail();
        }
    }

    @Test
    public void testNameBool() throws SolverException, InterruptedException {
        this.testName0(this.bmgr::makeVariable, this.bmgr::equivalence, false);
    }

    @Test
    public void testNameInt() throws SolverException, InterruptedException {
        this.requireIntegers();
        this.testName0(this.imgr::makeVariable, this.imgr::equal, false);
    }

    @Test
    public void testNameRat() throws SolverException, InterruptedException {
        this.requireRationals();
        this.testName0(this.rmgr::makeVariable, this.rmgr::equal, false);
    }

    @Test
    public void testNameBV() throws SolverException, InterruptedException {
        this.requireBitvectors();
        this.testName0(s -> this.bvmgr.makeVariable(4, (String)s), this.bvmgr::equal, false);
    }

    @Test
    public void testNameFloat() throws SolverException, InterruptedException {
        this.requireFloats();
        this.testName0(s -> this.fpmgr.makeVariable((String)s, FormulaType.getSinglePrecisionFloatingPointType()), this.fpmgr::equalWithFPSemantics, false);
    }

    @Test
    public void testNameIntArray() throws SolverException, InterruptedException {
        this.requireIntegers();
        this.requireArrays();
        this.testName0(s -> this.amgr.makeArray((String)s, FormulaType.IntegerType, FormulaType.IntegerType), this.amgr::equivalence, false);
    }

    @Test
    public void testNameBvArray() throws SolverException, InterruptedException {
        this.requireBitvectors();
        this.requireArrays();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testName0(s -> this.amgr.makeArray((String)s, FormulaType.getBitvectorTypeWithSize(2), FormulaType.getBitvectorTypeWithSize(2)), this.amgr::equivalence, false);
    }

    @Test
    public void testNameUF1Bool() throws SolverException, InterruptedException {
        this.requireIntegers();
        this.testName0(s -> this.fmgr.declareAndCallUF((String)s, FormulaType.BooleanType, new Formula[]{this.imgr.makeNumber(0L)}), this.bmgr::equivalence, true);
    }

    @Test
    public void testNameUF1Int() throws SolverException, InterruptedException {
        this.requireIntegers();
        this.testName0(s -> this.fmgr.declareAndCallUF((String)s, FormulaType.IntegerType, new Formula[]{this.imgr.makeNumber(0L)}), this.imgr::equal, true);
    }

    @Test
    public void testNameUFBv() throws SolverException, InterruptedException {
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testName0(s -> this.fmgr.declareAndCallUF((String)s, FormulaType.BooleanType, this.bvmgr.makeBitvector(2, 0L)), this.bmgr::equivalence, true);
    }

    @Test
    public void testNameUF2Bool() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this.testName0(s -> this.fmgr.declareAndCallUF((String)s, FormulaType.BooleanType, zero, zero), this.bmgr::equivalence, true);
    }

    @Test
    public void testNameUF2Int() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        this.testName0(s -> this.fmgr.declareAndCallUF((String)s, FormulaType.IntegerType, zero, zero), this.imgr::equal, true);
    }

    @Test
    public void testNameExists() {
        this.requireQuantifiers();
        this.requireIntegers();
        NumeralFormula.IntegerFormula var = this.createVariableWith(this.imgr::makeVariable, this.getVarname());
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        BooleanFormula exists = this.qmgr.exists(var, this.imgr.equal(var, zero));
        Truth.assertThat(this.mgr.extractVariablesAndUFs(exists)).isEmpty();
        this.mgr.visit(exists, new DefaultFormulaVisitor<Void>(){

            @Override
            public Void visitQuantifier(BooleanFormula pF, QuantifiedFormulaManager.Quantifier pQuantifier, List<Formula> pBoundVariables, BooleanFormula pBody) {
                for (Formula f : pBoundVariables) {
                    Map<String, Formula> map = VariableNamesTest.this.mgr.extractVariables(f);
                    Truth.assertThat(map).hasSize(1);
                    Truth.assertThat(map).containsEntry((Object)VariableNamesTest.this.getVarname(), (Object)f);
                }
                return null;
            }

            @Override
            protected Void visitDefault(Formula pF) {
                return null;
            }
        });
    }

    @Test
    public void testBoolVariableNameInVisitor() {
        this.requireVisitor();
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable, this.getVarname());
        this.bmgr.visit(var, new DefaultBooleanFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault() {
                throw new AssertionError((Object)"unexpected case");
            }

            @Override
            public Void visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> pDecl) {
                Truth.assertThat((String)pDecl.getName()).isEqualTo((Object)VariableNamesTest.this.getVarname());
                return null;
            }
        });
    }

    @Test
    public void testBoolVariableDump() {
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable, this.getVarname());
        String dump = this.mgr.dumpFormula(var).toString();
    }

    @Test
    public void testEqBoolVariableDump() {
        BooleanFormula var = this.createVariableWith(this.bmgr::makeVariable, this.getVarname());
        String dump = this.mgr.dumpFormula(this.bmgr.equivalence(var, var)).toString();
    }

    @Test
    public void testIntVariable() {
        this.requireIntegers();
        this.createVariableWith(this.imgr::makeVariable, this.getVarname());
    }

    @Test
    public void testInvalidRatVariable() {
        this.requireRationals();
        this.createVariableWith(this.rmgr::makeVariable, this.getVarname());
    }

    @Test
    public void testBVVariable() {
        this.requireBitvectors();
        this.createVariableWith(v -> this.bvmgr.makeVariable(4, (String)v), this.getVarname());
    }

    @Test
    public void testInvalidFloatVariable() {
        this.requireFloats();
        this.createVariableWith(v -> this.fpmgr.makeVariable((String)v, FormulaType.getSinglePrecisionFloatingPointType()), this.getVarname());
    }

    @Test
    public void testIntArrayVariable() {
        this.requireArrays();
        this.requireIntegers();
        this.createVariableWith(v -> this.amgr.makeArray((String)v, FormulaType.IntegerType, FormulaType.IntegerType), this.getVarname());
    }

    @Test
    public void testBvArrayVariable() {
        this.requireArrays();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.createVariableWith(v -> this.amgr.makeArray((String)v, FormulaType.getBitvectorTypeWithSize(2), FormulaType.getBitvectorTypeWithSize(2)), this.getVarname());
    }

    @Test
    public void sameBehaviorTest() {
        if (this.mgr.isValidName(this.getVarname())) {
            AbstractFormulaManager.checkVariableName(this.getVarname());
        } else {
            try {
                AbstractFormulaManager.checkVariableName(this.getVarname());
                Truth.assert_().fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

