/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"})
public class VariableNamesInvalidTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBoolVariable() {
        BooleanFormula var = this.bmgr.makeVariable("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIntVariable() {
        this.requireIntegers();
        Object var = this.imgr.makeVariable("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRatVariable() {
        this.requireRationals();
        Object var = this.rmgr.makeVariable("");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBVVariable() {
        this.requireBitvectors();
        BitvectorFormula var = this.bvmgr.makeVariable(4, "");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidFloatVariable() {
        this.requireFloats();
        FloatingPointFormula var = this.fpmgr.makeVariable("", FormulaType.getSinglePrecisionFloatingPointType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIntArrayVariable() {
        this.requireIntegers();
        this.requireArrays();
        ArrayFormula var = this.amgr.makeArray("", FormulaType.IntegerType, FormulaType.IntegerType);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidBvArrayVariable() {
        this.requireBitvectors();
        this.requireArrays();
        ArrayFormula var = this.amgr.makeArray("", FormulaType.getBitvectorTypeWithSize(2), FormulaType.getBitvectorTypeWithSize(2));
    }
}

