/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.List;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;
import org.sosy_lab.java_smt.utils.SolverUtils;
import org.sosy_lab.java_smt.utils.UfElimination;

@RunWith(value=Parameterized.class)
public class UfEliminationTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private UfElimination ackermannization;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setUp() {
        this.ackermannization = SolverUtils.ufElimination(this.mgr);
    }

    @Test
    public void simpleTest() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, variable2, variable4);
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void nestedUfs() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf1Decl = this.fmgr.declareUF("uf1", FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula uf1a = this.fmgr.callUF(uf1Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf1b = this.fmgr.callUF(uf1Decl, variable2, variable1);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf2", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, uf1a, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, uf1b, variable4);
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf1");
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf2");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void nestedUfs2() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        NumeralFormula.IntegerFormula variable5 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable5");
        NumeralFormula.IntegerFormula variable6 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable6");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        BooleanFormula v5EqualsV6 = this.imgr.equal(variable5, variable6);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf1Decl = this.fmgr.declareUF("uf1", FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType);
        FunctionDeclaration<NumeralFormula.IntegerFormula> uf2Decl = this.fmgr.declareUF("uf2", FormulaType.IntegerType, FormulaType.IntegerType, FormulaType.IntegerType);
        NumeralFormula.IntegerFormula uf2a = this.fmgr.callUF(uf2Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf2b = this.fmgr.callUF(uf2Decl, variable1, variable2);
        NumeralFormula.IntegerFormula uf1a = this.fmgr.callUF(uf1Decl, variable1, uf2a);
        NumeralFormula.IntegerFormula uf1b = this.fmgr.callUF(uf1Decl, variable2, uf2b);
        NumeralFormula.IntegerFormula f1 = this.fmgr.callUF(uf2Decl, uf1a, variable3);
        NumeralFormula.IntegerFormula f2 = this.fmgr.callUF(uf2Decl, uf1b, variable4);
        BooleanFormula f = this.imgr.lessThan(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4, v5EqualsV6);
        BooleanFormula withOutUfs = this.ackermannization.eliminateUfs(f);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf1");
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf2");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void twoFormulasTest() throws SolverException, InterruptedException {
        this.requireIntegers();
        TruthJUnit.assume().withMessage("Princess fails").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        BooleanFormula v1EqualsV2 = this.imgr.equal(variable1, variable2);
        BooleanFormula v3EqualsV4 = this.imgr.equal(variable3, variable4);
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, variable2, variable4);
        BooleanFormula f = this.bmgr.xor(f1, f2);
        BooleanFormula argsEqual = this.bmgr.and(v1EqualsV2, v3EqualsV4);
        UfElimination.Result result1 = this.ackermannization.eliminateUfs(f1, UfElimination.Result.empty(this.mgr));
        BooleanFormula withOutUfs1 = result1.getFormula();
        UfElimination.Result result2 = this.ackermannization.eliminateUfs(f2, result1);
        BooleanFormula withOutUfs2 = result2.getFormula();
        BooleanFormula geConstraints = result2.getConstraints();
        BooleanFormula withOutUfs = this.bmgr.and(this.bmgr.xor(withOutUfs1, withOutUfs2), geConstraints);
        this.assertThatFormula(f).isSatisfiable();
        this.assertThatFormula(withOutUfs).isSatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, f)).isUnsatisfiable();
        this.assertThatFormula(this.bmgr.and(argsEqual, withOutUfs)).isUnsatisfiable();
        Map<String, Formula> variablesAndUFs = this.mgr.extractVariablesAndUFs(withOutUfs);
        Map<String, Formula> variables = this.mgr.extractVariables(withOutUfs);
        Truth.assertThat(variablesAndUFs).doesNotContainKey((Object)"uf");
        Truth.assertThat(variablesAndUFs).isEqualTo(variables);
    }

    @Test
    public void quantifierTest() {
        this.requireQuantifiers();
        this.requireIntegers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> uf2Decl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(uf2Decl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(uf2Decl, variable2, variable4);
        BooleanFormula f = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)variable1, (Object)variable2, (Object)variable3, (Object)variable4), this.bmgr.equivalence(f1, f2));
        try {
            this.ackermannization.eliminateUfs(f);
            Truth.assert_().fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void substitutionTest() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula variable1 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable1");
        NumeralFormula.IntegerFormula variable2 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable2");
        NumeralFormula.IntegerFormula variable3 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable3");
        NumeralFormula.IntegerFormula variable4 = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("variable4");
        FunctionDeclaration<BooleanFormula> ufDecl = this.fmgr.declareUF("uf", FormulaType.BooleanType, FormulaType.IntegerType, FormulaType.IntegerType);
        BooleanFormula f1 = this.fmgr.callUF(ufDecl, variable1, variable3);
        BooleanFormula f2 = this.fmgr.callUF(ufDecl, variable2, variable4);
        BooleanFormula f = this.bmgr.or(f1, this.bmgr.not(f2));
        UfElimination.Result withOutUfs = this.ackermannization.eliminateUfs(f, UfElimination.Result.empty(this.mgr));
        Map<Formula, Formula> substitution = withOutUfs.getSubstitution();
        Truth.assertThat(substitution).hasSize(2);
        BiMap inverseSubstitution = HashBiMap.create(substitution).inverse();
        BooleanFormula revertedSubstitution = this.mgr.substitute(withOutUfs.getFormula(), (Map<? extends Formula, ? extends Formula>)inverseSubstitution);
        this.assertThatFormula(f).isEquivalentTo(revertedSubstitution);
    }
}

