/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.TruthJUnit;
import java.util.Random;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.test.Fuzzer;
import org.sosy_lab.java_smt.test.HardBitvectorFormulaGenerator;
import org.sosy_lab.java_smt.test.HardIntegerFormulaGenerator;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class TimeoutTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testTacticTimeout() {
        TruthJUnit.assume().withMessage("Only Z3 has native tactics").that((Comparable)((Object)this.solverToUse())).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        Fuzzer fuzzer = new Fuzzer(this.mgr, new Random(0L));
        String msg = "ShutdownRequest";
        BooleanFormula test = fuzzer.fuzz(20, 3);
        this.shutdownManager.requestShutdown(msg);
        Assert.assertThrows((String)msg, InterruptedException.class, () -> this.mgr.applyTactic(test, Tactic.NNF));
    }

    @Test
    public void testProverTimeoutInt() throws InterruptedException {
        this.requireIntegers();
        TruthJUnit.assume().withMessage(this.solverToUse() + " does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeoutInt(() -> this.context.newProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testProverTimeoutBv() throws InterruptedException {
        this.requireBitvectors();
        TruthJUnit.assume().withMessage(this.solverToUse() + " does not support interruption").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.testBasicProverTimeoutBv(() -> this.context.newProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testInterpolationProverTimeout() throws InterruptedException {
        this.requireInterpolation();
        this.requireIntegers();
        TruthJUnit.assume().withMessage(this.solverToUse() + " does not support interruption").that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.PRINCESS, (Object)SolverContextFactory.Solvers.BOOLECTOR, new Object[0]);
        this.testBasicProverTimeoutInt(() -> this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]));
    }

    @Test
    public void testOptimizationProverTimeout() throws InterruptedException {
        this.requireOptimization();
        this.requireIntegers();
        this.testBasicProverTimeoutInt(() -> this.context.newOptimizationProverEnvironment(new SolverContext.ProverOptions[0]));
    }

    private void testBasicProverTimeoutInt(Supplier<BasicProverEnvironment<?>> proverConstructor) throws InterruptedException {
        HardIntegerFormulaGenerator gen = new HardIntegerFormulaGenerator(this.imgr, this.bmgr);
        BooleanFormula instance = gen.generate(20);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(1L);
                this.shutdownManager.requestShutdown("Shutdown Request");
            }
            catch (InterruptedException pE) {
                throw new UnsupportedOperationException("Unexpected interrupt");
            }
        });
        try (BasicProverEnvironment<?> pe = proverConstructor.get();){
            pe.push(instance);
            t.start();
            Assert.assertThrows(InterruptedException.class, pe::isUnsat);
        }
    }

    private void testBasicProverTimeoutBv(Supplier<BasicProverEnvironment<?>> proverConstructor) throws InterruptedException {
        HardBitvectorFormulaGenerator gen = new HardBitvectorFormulaGenerator(this.bvmgr, this.bmgr);
        BooleanFormula instance = gen.generate(20);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(1L);
                this.shutdownManager.requestShutdown("Shutdown Request");
            }
            catch (InterruptedException pE) {
                throw new UnsupportedOperationException("Unexpected interrupt");
            }
        });
        try (BasicProverEnvironment<?> pe = proverConstructor.get();){
            pe.push(instance);
            t.start();
            Assert.assertThrows(InterruptedException.class, pe::isUnsat);
        }
    }
}

