/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingMode;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.BooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultBooleanFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaTransformationVisitor;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.api.visitors.TraversalProcess;
import org.sosy_lab.java_smt.test.Fuzzer;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverVisitorTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setup() {
        this.requireVisitor();
    }

    @Test
    public void booleanIdVisit() {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        BooleanFormula f = this.bmgr.makeBoolean(false);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        BooleanFormula z = this.bmgr.makeVariable("z");
        BooleanFormula and = this.bmgr.and(x, y);
        BooleanFormula or = this.bmgr.or(x, y);
        BooleanFormula ite = this.bmgr.ifThenElse(x, and, or);
        BooleanFormula impl = this.bmgr.implication(z, y);
        BooleanFormula eq = this.bmgr.equivalence(t, y);
        BooleanFormula not = this.bmgr.not(eq);
        for (BooleanFormula bf : ImmutableList.of((Object)t, (Object)f, (Object)x, (Object)y, (Object)z, (Object)and, (Object)or, (Object)ite, (Object)impl, (Object)eq, (Object)not)) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr){};
            this.assertThatFormula(this.bmgr.visit(bf, identityVisitor)).isEqualTo(bf);
        }
    }

    @Test
    public void bitvectorIdVisit() {
        this.requireBitvectors();
        FormulaType.BitvectorType bv8 = FormulaType.getBitvectorTypeWithSize(8);
        BitvectorFormula x = this.bvmgr.makeVariable(bv8, "x");
        BitvectorFormula y = this.bvmgr.makeVariable(bv8, "y");
        BitvectorFormula z = this.bvmgr.add(y, this.bvmgr.makeBitvector(8, 13L));
        for (Formula f : ImmutableList.of((Object)this.bvmgr.equal(x, y), (Object)this.bmgr.not(this.bvmgr.equal(x, z)), (Object)this.bvmgr.add(x, y), (Object)this.bvmgr.subtract(x, y), (Object)this.bvmgr.multiply(x, y), (Object)this.bvmgr.and(x, y), (Object)this.bvmgr.or(x, y), (Object)this.bvmgr.xor(x, y), (Object)this.bvmgr.lessThan(x, y, true), (Object)this.bvmgr.lessThan(x, y, false), (Object)this.bvmgr.lessOrEquals(x, y, true), (Object)this.bvmgr.lessOrEquals(x, y, false), (Object[])new Formula[]{this.bvmgr.greaterThan(x, y, true), this.bvmgr.greaterThan(x, y, false), this.bvmgr.greaterOrEquals(x, y, true), this.bvmgr.greaterOrEquals(x, y, false), this.bvmgr.divide(x, y, true), this.bvmgr.divide(x, y, false), this.bvmgr.modulo(x, y, true), this.bvmgr.modulo(x, y, false), this.bvmgr.not(x), this.bvmgr.negate(x), this.bvmgr.extract(x, 7, 5, true), this.bvmgr.extract(x, 7, 5, false), this.bvmgr.concat(x, y)})) {
            this.mgr.visit(f, new FunctionDeclarationVisitor());
            Formula f2 = this.mgr.transformRecursively(f, new FormulaTransformationVisitor(this.mgr){});
            Truth.assertThat((Object)f2).isEqualTo((Object)f);
        }
    }

    @Test
    public void floatIdVisit() {
        this.requireFloats();
        FormulaType.FloatingPointType fp = FormulaType.getSinglePrecisionFloatingPointType();
        FloatingPointFormula x = this.fpmgr.makeVariable("x", fp);
        FloatingPointFormula y = this.fpmgr.makeVariable("y", fp);
        for (Formula f : ImmutableList.of((Object)this.fpmgr.equalWithFPSemantics(x, y), (Object)this.fpmgr.add(x, y), (Object)this.fpmgr.subtract(x, y), (Object)this.fpmgr.multiply(x, y), (Object)this.fpmgr.lessThan(x, y), (Object)this.fpmgr.lessOrEquals(x, y), (Object)this.fpmgr.greaterThan(x, y), (Object)this.fpmgr.greaterOrEquals(x, y), (Object)this.fpmgr.divide(x, y), (Object)this.fpmgr.round(x, FloatingPointRoundingMode.NEAREST_TIES_TO_EVEN), (Object)this.fpmgr.round(x, FloatingPointRoundingMode.TOWARD_POSITIVE), (Object)this.fpmgr.round(x, FloatingPointRoundingMode.TOWARD_NEGATIVE), (Object[])new Formula[]{this.fpmgr.round(x, FloatingPointRoundingMode.TOWARD_ZERO)})) {
            this.mgr.visit(f, new FunctionDeclarationVisitor());
        }
    }

    @Test
    public void floatMoreVisit() {
        this.requireFloats();
        this.requireBitvectors();
        FormulaType.FloatingPointType fp = FormulaType.getSinglePrecisionFloatingPointType();
        FloatingPointFormula x = this.fpmgr.makeVariable("x", fp);
        FloatingPointFormula y = this.fpmgr.makeVariable("x", fp);
        BitvectorFormula z = this.bvmgr.makeVariable(32, "z");
        this.checkKind(this.fpmgr.castTo(x, FormulaType.getBitvectorTypeWithSize(32)), FunctionDeclarationKind.FP_CASTTO_SBV);
        this.checkKind(this.fpmgr.castTo(x, FormulaType.getDoublePrecisionFloatingPointType()), FunctionDeclarationKind.FP_CASTTO_FP);
        this.checkKind(this.fpmgr.isNaN(x), FunctionDeclarationKind.FP_IS_NAN);
        this.checkKind(this.fpmgr.isNegative(x), FunctionDeclarationKind.FP_IS_NEGATIVE);
        this.checkKind(this.fpmgr.isInfinity(x), FunctionDeclarationKind.FP_IS_INF);
        this.checkKind(this.fpmgr.isNormal(x), FunctionDeclarationKind.FP_IS_NORMAL);
        this.checkKind(this.fpmgr.isSubnormal(x), FunctionDeclarationKind.FP_IS_SUBNORMAL);
        this.checkKind(this.fpmgr.isZero(x), FunctionDeclarationKind.FP_IS_ZERO);
        this.checkKind(this.fpmgr.abs(x), FunctionDeclarationKind.FP_ABS);
        this.checkKind(this.fpmgr.max(x, y), FunctionDeclarationKind.FP_MAX);
        this.checkKind(this.fpmgr.min(x, y), FunctionDeclarationKind.FP_MIN);
        this.checkKind(this.fpmgr.sqrt(x), FunctionDeclarationKind.FP_SQRT);
        if (SolverContextFactory.Solvers.CVC4 != this.solverToUse()) {
            this.checkKind(this.fpmgr.toIeeeBitvector(x), FunctionDeclarationKind.FP_AS_IEEEBV);
        }
        this.checkKind(this.fpmgr.castFrom(z, true, FormulaType.getSinglePrecisionFloatingPointType()), FunctionDeclarationKind.BV_SCASTTO_FP);
        this.checkKind(this.fpmgr.castFrom(z, false, FormulaType.getSinglePrecisionFloatingPointType()), FunctionDeclarationKind.BV_UCASTTO_FP);
    }

    @Test
    public void bvVisit() {
        this.requireBitvectors();
        BitvectorFormula x = this.bvmgr.makeVariable(5, "x");
        for (Formula f : ImmutableList.of((Object)this.bvmgr.extend(x, 10, true), (Object)this.bvmgr.extend(x, 10, false))) {
            this.mgr.visit(f, new FunctionDeclarationVisitor());
        }
    }

    private void checkKind(Formula f, FunctionDeclarationKind expected) {
        FunctionDeclarationVisitor visitor = new FunctionDeclarationVisitor();
        this.mgr.visit(f, visitor);
        Truth.assert_().withMessage("declaration kind '%s' in function '%s' not available, only found '%s'.", new Object[]{expected, f, visitor.found}).that(visitor.found).contains((Object)expected);
    }

    @Test
    public void booleanIdVisitWithAtoms() {
        NumeralFormula.IntegerFormula n12 = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(12L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b");
        NumeralFormula.IntegerFormula sum = (NumeralFormula.IntegerFormula)this.imgr.add(a, b);
        NumeralFormula.IntegerFormula diff = (NumeralFormula.IntegerFormula)this.imgr.subtract(a, b);
        NumeralFormula.IntegerFormula neg = (NumeralFormula.IntegerFormula)this.imgr.negate(a);
        BooleanFormula eq = this.imgr.equal(n12, a);
        NumeralFormula.IntegerFormula ite = this.bmgr.ifThenElse(eq, sum, diff);
        for (NumeralFormula.IntegerFormula f : ImmutableList.of((Object)a, (Object)b, (Object)n12, (Object)neg, (Object)ite)) {
            BooleanFormulaTransformationVisitor identityVisitor = new BooleanFormulaTransformationVisitor(this.mgr){};
            BooleanFormula bf = this.imgr.equal(n12, f);
            this.assertThatFormula(this.bmgr.visit(bf, identityVisitor)).isEqualTo(bf);
        }
    }

    @Test
    public void testFormulaVisitor() {
        NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
        BooleanFormula f = this.bmgr.or(this.imgr.equal(z, (NumeralFormula.IntegerFormula)this.imgr.add(x, y)), this.imgr.equal(x, (NumeralFormula.IntegerFormula)this.imgr.add(z, y)));
        final HashSet usedVariables = new HashSet();
        DefaultFormulaVisitor<TraversalProcess> nameExtractor = new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula formula) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula formula, String name) {
                usedVariables.add(name);
                return TraversalProcess.CONTINUE;
            }
        };
        this.mgr.visitRecursively(f, (FormulaVisitor<TraversalProcess>)nameExtractor);
        Truth.assertThat(usedVariables).containsExactly(new Object[]{"x", "y", "z"});
    }

    @Test
    public void testBooleanFormulaQuantifierHandling() throws Exception {
        this.requireQuantifiers();
        TruthJUnit.assume().withMessage("Princess does not support quantifier over boolean variables").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula constraint = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)x), x);
        this.assertThatFormula(constraint).isUnsatisfiable();
        BooleanFormula newConstraint = this.bmgr.visit(constraint, new BooleanFormulaTransformationVisitor(this.mgr){});
        this.assertThatFormula(newConstraint).isUnsatisfiable();
    }

    @Test
    public void testVisitingTrue() {
        BooleanFormula t = this.bmgr.makeBoolean(true);
        final ArrayList containsTrue = new ArrayList();
        this.mgr.visitRecursively(t, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitConstant(Formula f, Object o) {
                if (f.equals(SolverVisitorTest.this.bmgr.makeBoolean(true))) {
                    containsTrue.add(true);
                }
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(containsTrue).isNotEmpty();
    }

    @Test
    public void testCorrectFunctionNames() {
        BooleanFormula a = this.bmgr.makeVariable("a");
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula ab = this.bmgr.and(a, b);
        final HashSet found = new HashSet();
        this.mgr.visitRecursively(ab, (FormulaVisitor<TraversalProcess>)new DefaultFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault(Formula f) {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
                found.add(functionDeclaration.getName());
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitFreeVariable(Formula f, String name) {
                found.add(name);
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(found).containsAtLeast((Object)"a", (Object)"b", new Object[0]);
        Truth.assertThat(found).hasSize(3);
        Truth.assertThat(found).doesNotContain((Object)ab.toString());
    }

    @Test
    public void recursiveTransformationVisitorTest() throws Exception {
        BooleanFormula f = this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("z"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L)));
        BooleanFormula transformed = this.mgr.transformRecursively(f, new FormulaTransformationVisitor(this.mgr){

            @Override
            public Formula visitFreeVariable(Formula formula, String name) {
                return SolverVisitorTest.this.mgr.makeVariable(SolverVisitorTest.this.mgr.getFormulaType(formula), name + "'");
            }
        });
        this.assertThatFormula(transformed).isEquivalentTo(this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x'"), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y'")), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("z'"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(10L))));
    }

    @Test
    public void recursiveTransformationVisitorTest2() throws Exception {
        BooleanFormula f = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        BooleanFormula transformed = this.mgr.transformRecursively(f, new FormulaTransformationVisitor(this.mgr){

            @Override
            public Formula visitFreeVariable(Formula formula, String name) {
                return SolverVisitorTest.this.mgr.makeVariable(SolverVisitorTest.this.mgr.getFormulaType(formula), name + "'");
            }
        });
        this.assertThatFormula(transformed).isEquivalentTo(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y'"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
    }

    @Test
    public void booleanRecursiveTraversalTest() {
        BooleanFormula f = this.bmgr.or(this.bmgr.and(this.bmgr.makeVariable("x"), this.bmgr.makeVariable("y")), this.bmgr.and(this.bmgr.makeVariable("z"), this.bmgr.makeVariable("d"), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("gg"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L))));
        final HashSet foundVars = new HashSet();
        this.bmgr.visitRecursively(f, (BooleanFormulaVisitor<TraversalProcess>)new DefaultBooleanFormulaVisitor<TraversalProcess>(){

            @Override
            protected TraversalProcess visitDefault() {
                return TraversalProcess.CONTINUE;
            }

            @Override
            public TraversalProcess visitAtom(BooleanFormula atom, FunctionDeclaration<BooleanFormula> funcDecl) {
                if (funcDecl.getKind() == FunctionDeclarationKind.VAR) {
                    foundVars.add(funcDecl.getName());
                }
                return TraversalProcess.CONTINUE;
            }
        });
        Truth.assertThat(foundVars).containsExactly(new Object[]{"x", "y", "z", "d"});
    }

    @Test
    public void testTransformationInsideQuantifiers() {
        this.requireQuantifiers();
        TruthJUnit.assume().withMessage("Princess does not support quantifier over boolean variables").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula[] usedVars = (BooleanFormula[])Stream.of("a", "b", "c", "d", "e", "f").map(var -> this.bmgr.makeVariable((String)var)).toArray(BooleanFormula[]::new);
        Fuzzer fuzzer = new Fuzzer(this.mgr, new Random(0L));
        ImmutableList quantifiedVars = ImmutableList.of((Object)this.bmgr.makeVariable("a"));
        BooleanFormula body = fuzzer.fuzz(30, usedVars);
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)quantifiedVars, body);
        BooleanFormula transformed = this.bmgr.transformRecursively(f, new BooleanFormulaTransformationVisitor(this.mgr){

            @Override
            public BooleanFormula visitAtom(BooleanFormula pAtom, FunctionDeclaration<BooleanFormula> decl) {
                if (decl.getKind() == FunctionDeclarationKind.VAR) {
                    return SolverVisitorTest.this.bmgr.makeVariable(decl.getName().toUpperCase());
                }
                return pAtom;
            }
        });
        Truth.assertThat((Boolean)this.mgr.extractVariables(transformed).keySet().stream().allMatch(pS -> pS.equals(pS.toUpperCase()))).isTrue();
    }

    @Test
    public void extractionTest1() {
        NumeralFormula.IntegerFormula v = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("v");
        BooleanFormula q = this.fmgr.declareAndCallUF("q", FormulaType.BooleanType, v);
        Map<String, Formula> mapping = this.mgr.extractVariablesAndUFs(q);
        Truth.assertThat(mapping).containsEntry((Object)"v", (Object)v);
        Truth.assertThat(mapping).containsEntry((Object)"q", (Object)q);
    }

    @Test
    public void extractionTest2() {
        NumeralFormula.IntegerFormula v = this.fmgr.declareAndCallUF("v", FormulaType.IntegerType, new Formula[0]);
        BooleanFormula q = this.fmgr.declareAndCallUF("q", FormulaType.BooleanType, v);
        Map<String, Formula> mapping = this.mgr.extractVariablesAndUFs(q);
        Map<String, Formula> mapping2 = this.mgr.extractVariables(q);
        Truth.assertThat(mapping).hasSize(2);
        Truth.assertThat(mapping).containsEntry((Object)"v", (Object)v);
        Truth.assertThat(mapping).containsEntry((Object)"q", (Object)q);
        if (ImmutableList.of((Object)((Object)SolverContextFactory.Solvers.CVC4), (Object)((Object)SolverContextFactory.Solvers.PRINCESS)).contains((Object)this.solverToUse())) {
            Truth.assertThat(mapping2).isEmpty();
        } else {
            Truth.assertThat(mapping2).hasSize(1);
            Truth.assertThat(mapping2).containsEntry((Object)"v", (Object)v);
        }
    }

    private final class FunctionDeclarationVisitor
    extends DefaultFormulaVisitor<Formula> {
        private final List<FunctionDeclarationKind> found = new ArrayList<FunctionDeclarationKind>();

        private FunctionDeclarationVisitor() {
        }

        @Override
        public Formula visitFunction(Formula f, List<Formula> args, FunctionDeclaration<?> functionDeclaration) {
            this.found.add(functionDeclaration.getKind());
            Truth.assert_().withMessage("unexpected declaration kind '%s' in function '%s' with args '%s'.", new Object[]{functionDeclaration, f, args}).that((Comparable)((Object)functionDeclaration.getKind())).isNotEqualTo((Object)FunctionDeclarationKind.OTHER);
            for (Formula arg : args) {
                SolverVisitorTest.this.mgr.visit(arg, this);
            }
            return this.visitDefault(f);
        }

        @Override
        protected Formula visitDefault(Formula pF) {
            return pF;
        }
    }
}

