/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class SolverContextTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testMultipleContextClose() {
        this.context.close();
        this.context.close();
        this.context.close();
        this.context.close();
    }

    @Test
    public void testFormulaAccessAfterClose() {
        BooleanFormula term = this.bmgr.makeVariable("variable");
        BooleanFormula term2 = this.bmgr.makeVariable("variable");
        BooleanFormula term3 = this.bmgr.makeVariable("test");
        BooleanFormula termTrue = this.bmgr.makeBoolean(true);
        BooleanFormula termFalse = this.bmgr.makeBoolean(false);
        int hash = term.hashCode();
        this.context.close();
        Truth.assertThat((Object)term).isEqualTo((Object)term2);
        Truth.assertThat((Object)term).isNotEqualTo((Object)term3);
        Truth.assertThat((Object)term).isNotEqualTo((Object)termTrue);
        Truth.assertThat((Object)termFalse).isNotEqualTo((Object)termTrue);
        TruthJUnit.assume().withMessage("Solver %s does not support to access formulae after closing the context", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        Truth.assertThat((Integer)term.hashCode()).isEqualTo((Object)hash);
        TruthJUnit.assume().withMessage("Solver %s does not support to access formulae after closing the context", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        Truth.assertThat((Boolean)this.bmgr.isTrue(term)).isFalse();
        Truth.assertThat((Boolean)this.bmgr.isFalse(term)).isFalse();
        Truth.assertThat((Boolean)this.bmgr.isTrue(termTrue)).isTrue();
        Truth.assertThat((Boolean)this.bmgr.isFalse(termFalse)).isTrue();
        TruthJUnit.assume().withMessage("Solver %s does not support to access formulae after closing the context", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.Z3);
        Truth.assertThat((String)term.toString()).isEqualTo((Object)"variable");
        Truth.assertThat((Integer)term.hashCode()).isEqualTo((Object)hash);
        Truth.assertThat((Object)term).isEqualTo((Object)term2);
        TruthJUnit.assume().withMessage("Solver %s does not support to access formulae after closing the context", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.CVC4);
        BooleanFormula notTerm = this.bmgr.not(term);
        Truth.assertThat((Boolean)this.bmgr.isTrue(notTerm)).isFalse();
        Truth.assertThat((Boolean)this.bmgr.isFalse(notTerm)).isFalse();
        BooleanFormula opTerm = this.bmgr.and(notTerm, term2);
        Truth.assertThat((Boolean)this.bmgr.isTrue(opTerm)).isFalse();
        Truth.assertThat((Boolean)this.bmgr.isFalse(opTerm)).isFalse();
    }
}

