/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.HardBitvectorFormulaGenerator;
import org.sosy_lab.java_smt.test.HardIntegerFormulaGenerator;

@RunWith(value=Parameterized.class)
public class SolverConcurrencyTest {
    private static final int NUMBER_OF_THREADS = 4;
    private static final int TIMEOUT_SECONDS = 30;
    private static final ImmutableMap<SolverContextFactory.Solvers, Integer> INTEGER_FORMULA_GEN = ImmutableMap.of((Object)((Object)SolverContextFactory.Solvers.SMTINTERPOL), (Object)10, (Object)((Object)SolverContextFactory.Solvers.CVC4), (Object)14, (Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)16, (Object)((Object)SolverContextFactory.Solvers.PRINCESS), (Object)10, (Object)((Object)SolverContextFactory.Solvers.Z3), (Object)14);
    private static final ImmutableMap<SolverContextFactory.Solvers, Integer> BITVECTOR_FORMULA_GEN = ImmutableMap.of((Object)((Object)SolverContextFactory.Solvers.BOOLECTOR), (Object)60, (Object)((Object)SolverContextFactory.Solvers.CVC4), (Object)9, (Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)60, (Object)((Object)SolverContextFactory.Solvers.PRINCESS), (Object)7, (Object)((Object)SolverContextFactory.Solvers.Z3), (Object)50);
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void checkThatSolverIsAvailable() throws InvalidConfigurationException {
        this.initSolver(new String[0]).close();
    }

    private void requireConcurrentMultipleStackSupport() {
        TruthJUnit.assume().withMessage("Solver does not support concurrent solving in multiple stacks").that((Comparable)((Object)this.solver)).isNoneOf((Object)SolverContextFactory.Solvers.SMTINTERPOL, (Object)SolverContextFactory.Solvers.BOOLECTOR, new Object[]{SolverContextFactory.Solvers.MATHSAT5, SolverContextFactory.Solvers.Z3, SolverContextFactory.Solvers.PRINCESS});
    }

    private void requireIntegers() {
        TruthJUnit.assume().withMessage("Solver does not support integers").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
    }

    private void requireBitvectors() {
        TruthJUnit.assume().withMessage("Solver does not support bitvectors").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.SMTINTERPOL);
    }

    private void requireOptimization() {
        TruthJUnit.assume().withMessage("Solver does not support optimization").that((Comparable)((Object)this.solver)).isNoneOf((Object)SolverContextFactory.Solvers.SMTINTERPOL, (Object)SolverContextFactory.Solvers.BOOLECTOR, new Object[]{SolverContextFactory.Solvers.PRINCESS, SolverContextFactory.Solvers.CVC4});
    }

    @Test
    public void testIntConcurrencyWithConcurrentContext() {
        this.requireIntegers();
        SolverConcurrencyTest.assertConcurrency("testIntConcurrencyWithConcurrentContext", () -> {
            SolverContext context = this.initSolver(new String[0]);
            this.intConcurrencyTest(context);
            this.closeSolver(context);
        });
    }

    @Test
    public void testBvConcurrencyWithConcurrentContext() {
        this.requireBitvectors();
        SolverConcurrencyTest.assertConcurrency("testBvConcurrencyWithConcurrentContext", () -> {
            SolverContext context = this.initSolver(new String[0]);
            this.bvConcurrencyTest(context);
            this.closeSolver(context);
        });
    }

    @Test
    public void testIntConcurrencyWithoutConcurrentContext() throws InvalidConfigurationException {
        this.requireIntegers();
        ConcurrentLinkedQueue<SolverContext> contextList = new ConcurrentLinkedQueue<SolverContext>();
        for (int i = 0; i < 4; ++i) {
            contextList.add(this.initSolver(new String[0]));
        }
        SolverConcurrencyTest.assertConcurrency("testIntConcurrencyWithoutConcurrentContext", () -> {
            SolverContext context = (SolverContext)contextList.poll();
            this.intConcurrencyTest(context);
            this.closeSolver(context);
        });
    }

    @Test
    public void testBvConcurrencyWithoutConcurrentContext() throws InvalidConfigurationException {
        this.requireBitvectors();
        ConcurrentLinkedQueue<SolverContext> contextList = new ConcurrentLinkedQueue<SolverContext>();
        for (int i = 0; i < 4; ++i) {
            contextList.add(this.initSolver(new String[0]));
        }
        SolverConcurrencyTest.assertConcurrency("testBvConcurrencyWithoutConcurrentContext", () -> {
            SolverContext context = (SolverContext)contextList.poll();
            this.bvConcurrencyTest(context);
            this.closeSolver(context);
        });
    }

    @Test
    public void testConcurrentOptimization() {
        this.requireOptimization();
        TruthJUnit.assume().withMessage("Solver does support optimization, but is not yet reentrant.").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        SolverConcurrencyTest.assertConcurrency("testConcurrentOptimization", () -> {
            SolverContext context = this.initSolver("solver.mathsat5.loadOptimathsat5", "true");
            this.optimizationTest(context);
            this.closeSolver(context);
        });
    }

    @Test
    public void testConcurrentStack() throws InvalidConfigurationException, InterruptedException {
        this.requireConcurrentMultipleStackSupport();
        SolverContext context = this.initSolver(new String[0]);
        FormulaManager mgr = context.getFormulaManager();
        IntegerFormulaManager imgr = mgr.getIntegerFormulaManager();
        BooleanFormulaManager bmgr = mgr.getBooleanFormulaManager();
        HardIntegerFormulaGenerator gen = new HardIntegerFormulaGenerator(imgr, bmgr);
        ConcurrentLinkedQueue<ProverEnvironment> proverList = new ConcurrentLinkedQueue<ProverEnvironment>();
        for (int i = 0; i < 4; ++i) {
            BooleanFormula instance = gen.generate((Integer)INTEGER_FORMULA_GEN.getOrDefault((Object)this.solver, (Object)9));
            ProverEnvironment pe = context.newProverEnvironment(new SolverContext.ProverOptions[0]);
            pe.push(instance);
            proverList.add(pe);
        }
        SolverConcurrencyTest.assertConcurrency("testConcurrentStack", () -> {
            BasicProverEnvironment stack = (BasicProverEnvironment)proverList.poll();
            Truth.assertWithMessage((String)"Solver %s failed a concurrency test", (Object[])new Object[]{this.solverToUse()}).that(Boolean.valueOf(stack.isUnsat())).isTrue();
        });
        this.closeSolver(context);
    }

    private void bvConcurrencyTest(SolverContext context) throws SolverException, InterruptedException {
        FormulaManager mgr = context.getFormulaManager();
        BitvectorFormulaManager bvmgr = mgr.getBitvectorFormulaManager();
        BooleanFormulaManager bmgr = mgr.getBooleanFormulaManager();
        HardBitvectorFormulaGenerator gen = new HardBitvectorFormulaGenerator(bvmgr, bmgr);
        BooleanFormula instance = gen.generate((Integer)BITVECTOR_FORMULA_GEN.getOrDefault((Object)this.solver, (Object)9));
        try (ProverEnvironment pe = context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            pe.push(instance);
            Truth.assertWithMessage((String)"Solver %s failed a concurrency test", (Object[])new Object[]{this.solverToUse()}).that(Boolean.valueOf(pe.isUnsat())).isTrue();
        }
    }

    private void intConcurrencyTest(SolverContext context) throws SolverException, InterruptedException {
        FormulaManager mgr = context.getFormulaManager();
        IntegerFormulaManager imgr = mgr.getIntegerFormulaManager();
        BooleanFormulaManager bmgr = mgr.getBooleanFormulaManager();
        HardIntegerFormulaGenerator gen = new HardIntegerFormulaGenerator(imgr, bmgr);
        BooleanFormula instance = gen.generate((Integer)INTEGER_FORMULA_GEN.getOrDefault((Object)this.solver, (Object)9));
        try (ProverEnvironment pe = context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            pe.push(instance);
            Truth.assertWithMessage((String)"Solver %s failed a concurrency test", (Object[])new Object[]{this.solverToUse()}).that(Boolean.valueOf(pe.isUnsat())).isTrue();
        }
    }

    private void optimizationTest(SolverContext context) throws InterruptedException, SolverException {
        FormulaManager mgr = context.getFormulaManager();
        IntegerFormulaManager imgr = mgr.getIntegerFormulaManager();
        BooleanFormulaManager bmgr = mgr.getBooleanFormulaManager();
        try (OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)imgr.makeVariable("y");
            NumeralFormula.IntegerFormula obj = (NumeralFormula.IntegerFormula)imgr.makeVariable("obj");
            prover.addConstraint(bmgr.and(imgr.lessOrEquals(x, (NumeralFormula.IntegerFormula)imgr.makeNumber(10L)), imgr.lessOrEquals(y, (NumeralFormula.IntegerFormula)imgr.makeNumber(15L)), imgr.equal(obj, (NumeralFormula.IntegerFormula)imgr.add(x, y)), imgr.greaterOrEquals((NumeralFormula.IntegerFormula)imgr.subtract(x, y), (NumeralFormula.IntegerFormula)imgr.makeNumber(1L))));
            int handle = prover.maximize(obj);
            OptimizationProverEnvironment.OptStatus response = prover.check();
            Truth.assertThat((Comparable)((Object)response)).isEqualTo((Object)OptimizationProverEnvironment.OptStatus.OPT);
            Truth8.assertThat(prover.upper(handle, Rational.ZERO)).hasValue((Object)Rational.ofString((String)"19"));
            try (Model model = prover.getModel();){
                BigInteger xValue = model.evaluate(x);
                BigInteger objValue = model.evaluate(obj);
                BigInteger yValue = model.evaluate(y);
                Truth.assertThat((Comparable)objValue).isEqualTo((Object)BigInteger.valueOf(19L));
                Truth.assertThat((Comparable)xValue).isEqualTo((Object)BigInteger.valueOf(10L));
                Truth.assertThat((Comparable)yValue).isEqualTo((Object)BigInteger.valueOf(9L));
            }
        }
    }

    private SolverContext initSolver(String ... additionalOptions) throws InvalidConfigurationException {
        try {
            ConfigurationBuilder options = Configuration.builder().setOption("solver.solver", this.solverToUse().toString());
            for (int i = 0; i < additionalOptions.length; i += 2) {
                options.setOption(additionalOptions[i], additionalOptions[i + 1]);
            }
            Configuration config = options.build();
            LogManager logger = LogManager.createTestLogManager();
            ShutdownNotifier shutdownNotifier = ShutdownManager.create().getNotifier();
            SolverContextFactory factory = new SolverContextFactory(config, logger, shutdownNotifier);
            return factory.generateContext();
        }
        catch (InvalidConfigurationException e) {
            TruthJUnit.assume().withMessage(e.getMessage()).that((Throwable)e).hasCauseThat().isNotInstanceOf(UnsatisfiedLinkError.class);
            throw e;
        }
    }

    private void closeSolver(SolverContext context) {
        if (context != null) {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertConcurrency(String testName, Run runnable) {
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        List<Throwable> exceptionsList = Collections.synchronizedList(new ArrayList());
        CountDownLatch allExecutorThreadsReady = new CountDownLatch(4);
        CountDownLatch afterInitBlocker = new CountDownLatch(1);
        CountDownLatch allDone = new CountDownLatch(4);
        for (int i = 0; i < 4; ++i) {
            Future<?> future = threadPool.submit(() -> {
                allExecutorThreadsReady.countDown();
                try {
                    afterInitBlocker.await();
                    runnable.run();
                }
                catch (Throwable e) {
                    exceptionsList.add(e);
                }
                finally {
                    allDone.countDown();
                }
            });
        }
        try {
            Truth.assertWithMessage((String)("Timeout initializing the Threads for " + testName)).that(Boolean.valueOf(allExecutorThreadsReady.await(40L, TimeUnit.MILLISECONDS))).isTrue();
            afterInitBlocker.countDown();
            Truth.assertWithMessage((String)("Timeout in " + testName)).that(Boolean.valueOf(allDone.await(30L, TimeUnit.SECONDS))).isTrue();
        }
        catch (Throwable e) {
            exceptionsList.add(e);
        }
        finally {
            threadPool.shutdownNow();
        }
        Truth.assertWithMessage((String)"Test %s failed with exception(s): %s", (Object[])new Object[]{testName, exceptionsList}).that(Boolean.valueOf(exceptionsList.isEmpty())).isTrue();
    }

    private static interface Run {
        public void run() throws SolverException, InterruptedException, InvalidConfigurationException;
    }
}

