/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.common.truth.TruthJUnit;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ProverEnvironmentTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void assumptionsTest() throws SolverException, InterruptedException {
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        try (ProverEnvironment pe = this.context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
            pe.push();
            pe.addConstraint(this.bmgr.or(b, this.bmgr.makeBoolean(false)));
            pe.addConstraint(c);
            Truth.assertThat((Boolean)pe.isUnsat()).isFalse();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(b)))).isTrue();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)b))).isFalse();
        }
    }

    @Test
    public void assumptionsWithModelTest() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("MathSAT can't construct models for SAT check with assumptions").that((Comparable)((Object)this.solver)).isNotEqualTo((Object)SolverContextFactory.Solvers.MATHSAT5);
        BooleanFormula b = this.bmgr.makeVariable("b");
        BooleanFormula c = this.bmgr.makeVariable("c");
        try (ProverEnvironment pe = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            pe.push();
            pe.addConstraint(this.bmgr.or(b, this.bmgr.makeBoolean(false)));
            pe.addConstraint(c);
            Truth.assertThat((Boolean)pe.isUnsat()).isFalse();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(b)))).isTrue();
            Truth.assertThat((Boolean)pe.isUnsatWithAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)b))).isFalse();
            try (Model m = pe.getModel();){
                Truth.assertThat((Boolean)m.evaluate(c)).isTrue();
            }
        }
    }

    @Test
    public void unsatCoreTest() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        try (ProverEnvironment pe = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            this.unsatCoreTest0(pe);
        }
    }

    @Test
    public void unsatCoreTestItp() throws SolverException, InterruptedException {
        this.requireInterpolation();
        try (InterpolatingProverEnvironment<?> pe = this.context.newProverEnvironmentWithInterpolation(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            this.unsatCoreTest0(pe);
        }
    }

    @Test
    public void unsatCoreTestForOptimizationProver() throws SolverException, InterruptedException {
        this.requireOptimization();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.Z3, (Object)SolverContextFactory.Solvers.BOOLECTOR, new Object[0]);
        try (OptimizationProverEnvironment pe = this.context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            this.unsatCoreTest0(pe);
        }
    }

    private void unsatCoreTest0(BasicProverEnvironment<?> pe) throws InterruptedException, SolverException {
        pe.push();
        pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
        pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
        ProverEnvironmentSubject.assertThat(pe).isUnsatisfiable();
        List<BooleanFormula> unsatCore = pe.getUnsatCore();
        Truth.assertThat(unsatCore).containsExactly(new Object[]{this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))});
    }

    @Test
    public void unsatCoreWithAssumptionsTest() throws SolverException, InterruptedException {
        TruthJUnit.assume().withMessage("Solver %s does not support unsat core generation over assumptions", new Object[]{this.solverToUse()}).that((Comparable)((Object)this.solverToUse())).isNoneOf((Object)SolverContextFactory.Solvers.PRINCESS, (Object)SolverContextFactory.Solvers.MATHSAT5, new Object[]{SolverContextFactory.Solvers.BOOLECTOR, SolverContextFactory.Solvers.CVC4});
        try (ProverEnvironment pe = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_UNSAT_CORE_OVER_ASSUMPTIONS);){
            pe.push();
            pe.addConstraint(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
            BooleanFormula selector = this.bmgr.makeVariable("b");
            pe.addConstraint(this.bmgr.or(selector, this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("y"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))));
            Optional<List<BooleanFormula>> res = pe.unsatCoreOverAssumptions((Collection<BooleanFormula>)ImmutableList.of((Object)this.bmgr.not(selector)));
            Truth8.assertThat(res).isPresent();
            List<BooleanFormula> unsatCore = res.orElseThrow();
            Truth.assertThat(unsatCore).containsExactly(new Object[]{this.bmgr.not(selector)});
        }
    }
}

