/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclaration;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class NumeralFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void distinctTest() throws SolverException, InterruptedException {
        this.requireIntegers();
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
        }
        this.assertThatFormula(this.imgr.distinct(symbols)).isSatisfiable();
    }

    @Test
    public void distinctTest2() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
            constraints.add(this.imgr.lessOrEquals(zero, symbol));
            constraints.add(this.imgr.lessOrEquals(symbol, four));
        }
        this.assertThatFormula(this.bmgr.and(this.imgr.distinct(symbols), this.bmgr.and(constraints))).isSatisfiable();
    }

    @Test
    public void distinctTest3() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
            constraints.add(this.imgr.lessOrEquals(zero, symbol));
            constraints.add(this.imgr.lessThan(symbol, four));
        }
        this.assertThatFormula(this.bmgr.and(this.imgr.distinct(symbols), this.bmgr.and(constraints))).isUnsatisfiable();
    }

    @Test(expected=Exception.class)
    public void failOnInvalidString() {
        this.requireIntegers();
        this.imgr.makeNumber("a");
        Truth.assert_().fail();
    }

    @Test
    public void testSubTypes() {
        this.requireIntegers();
        this.requireRationals();
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a");
        NumeralFormula.RationalFormula r = (NumeralFormula.RationalFormula)this.rmgr.makeVariable("r");
        ImmutableList argTypes = ImmutableList.of(FormulaType.RationalType, FormulaType.RationalType);
        FunctionDeclaration<NumeralFormula.IntegerFormula> ufDecl = this.fmgr.declareUF("uf", FormulaType.IntegerType, (List<FormulaType<?>>)argTypes);
        NumeralFormula.IntegerFormula uf = this.fmgr.callUF(ufDecl, a, r);
        this.mgr.visit(this.bmgr.and(this.rmgr.equal(uf, this.imgr.makeNumber(0L))), new DefaultFormulaVisitor<Void>((List)argTypes, a, r, uf){
            final /* synthetic */ List val$argTypes;
            final /* synthetic */ NumeralFormula.IntegerFormula val$a;
            final /* synthetic */ NumeralFormula.RationalFormula val$r;
            final /* synthetic */ NumeralFormula.IntegerFormula val$uf;
            {
                this.val$argTypes = list;
                this.val$a = integerFormula;
                this.val$r = rationalFormula;
                this.val$uf = integerFormula2;
            }

            @Override
            public Void visitFunction(Formula pF, List<Formula> pArgs, FunctionDeclaration<?> pDeclaration) {
                if ("uf".equals(pDeclaration.getName())) {
                    this.checkUf(pDeclaration);
                } else {
                    this.checkIntEq(pDeclaration);
                }
                return null;
            }

            private void checkUf(FunctionDeclaration<?> pDeclaration) {
                Truth.assertThat(pDeclaration.getArgumentTypes()).isEqualTo((Object)this.val$argTypes);
                FunctionDeclaration<?> ufDecl2 = NumeralFormulaManagerTest.this.fmgr.declareUF("uf", pDeclaration.getType(), pDeclaration.getArgumentTypes());
                Object uf2 = NumeralFormulaManagerTest.this.fmgr.callUF(ufDecl2, this.val$a, this.val$r);
                Truth.assertThat(uf2).isEqualTo((Object)this.val$uf);
                NumeralFormulaManagerTest.this.fmgr.callUF(ufDecl2, this.val$r, this.val$r);
            }

            private void checkIntEq(FunctionDeclaration<?> pDeclaration) {
                Truth.assertThat(pDeclaration.getArgumentTypes()).containsExactly(new Object[]{FormulaType.IntegerType, FormulaType.IntegerType}).inOrder();
            }

            @Override
            protected Void visitDefault(Formula pF) {
                return null;
            }
        });
    }
}

