/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.util.Collection;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class InterpolatingProverTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0}")
    public static SolverContextFactory.Solvers[] getAllCombinations() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    private <T> InterpolatingProverEnvironment<T> newEnvironmentForTest() {
        this.requireInterpolation();
        return this.context.newProverEnvironmentWithInterpolation(new SolverContext.ProverOptions[0]);
    }

    @Test
    public <T> void simpleInterpolation() throws SolverException, InterruptedException {
        try (InterpolatingProverEnvironment<T> prover = this.newEnvironmentForTest();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
            BooleanFormula f1 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.multiply((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), x));
            BooleanFormula f2 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.multiply(z, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L))));
            prover.push(f1);
            Object id2 = prover.push(f2);
            boolean check = prover.isUnsat();
            Truth.assertWithMessage((String)"formulas must be contradicting").that(Boolean.valueOf(check)).isTrue();
            prover.getInterpolant((Collection<T>)ImmutableList.of(id2));
        }
    }

    @Test
    public <T> void emptyInterpolationGroup() throws SolverException, InterruptedException {
        try (InterpolatingProverEnvironment<T> prover = this.newEnvironmentForTest();){
            NumeralFormula.IntegerFormula x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
            NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
            NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("z");
            BooleanFormula f1 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.multiply((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), x));
            BooleanFormula f2 = this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.multiply(z, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L))));
            Object id1 = prover.push(f1);
            Object id2 = prover.push(f2);
            Truth.assertThat((Boolean)prover.isUnsat()).isTrue();
            BooleanFormula emptyB = prover.getInterpolant((Collection<T>)ImmutableList.of(id1, id2));
            Truth.assertThat((Boolean)this.bmgr.isFalse(emptyB)).isTrue();
            BooleanFormula emptyA = prover.getInterpolant((Collection<T>)ImmutableList.of());
            Truth.assertThat((Boolean)this.bmgr.isTrue(emptyA)).isTrue();
        }
    }

    @Test
    public <T> void binaryInterpolation() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        Object TC = stack.push(C);
        Object TD = stack.push(D);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        BooleanFormula itp = stack.getInterpolant((Collection<T>)ImmutableList.of());
        BooleanFormula itpA = stack.getInterpolant((Collection<T>)ImmutableList.of(TA));
        BooleanFormula itpAB = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB));
        BooleanFormula itpABC = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB, TC));
        BooleanFormula itpD = stack.getInterpolant((Collection<T>)ImmutableList.of(TD));
        BooleanFormula itpDC = stack.getInterpolant((Collection<T>)ImmutableList.of(TD, TC));
        BooleanFormula itpDCB = stack.getInterpolant((Collection<T>)ImmutableList.of(TD, TC, TB));
        BooleanFormula itpABCD = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB, TC, TD));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        Truth.assertThat((Object)this.bmgr.makeBoolean(true)).isEqualTo((Object)itp);
        Truth.assertThat((Object)this.bmgr.makeBoolean(false)).isEqualTo((Object)itpABCD);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), (List<BooleanFormula>)ImmutableList.of((Object)itpA, (Object)itpAB, (Object)itpABC));
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), (List<BooleanFormula>)ImmutableList.of((Object)itpD, (Object)itpDC, (Object)itpDCB));
    }

    @Test
    public <T> void binaryInterpolation1() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.bmgr.makeBoolean(false);
        BooleanFormula B = this.bmgr.makeBoolean(false);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        BooleanFormula itp0 = stack.getInterpolant((Collection<T>)ImmutableList.of());
        BooleanFormula itpA = stack.getInterpolant((Collection<T>)ImmutableList.of(TA));
        BooleanFormula itpB = stack.getInterpolant((Collection<T>)ImmutableList.of(TA));
        BooleanFormula itpAB = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB));
        stack.pop();
        stack.pop();
        Truth.assertThat((Object)this.bmgr.makeBoolean(true)).isEqualTo((Object)itp0);
        Truth.assertThat((Object)this.bmgr.makeBoolean(false)).isEqualTo((Object)itpAB);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B), (List<BooleanFormula>)ImmutableList.of((Object)itpA));
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)A), (List<BooleanFormula>)ImmutableList.of((Object)itpB));
    }

    @Test
    public <T> void binaryBVInterpolation1() throws SolverException, InterruptedException {
        this.requireBitvectors();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        int width = 8;
        BitvectorFormula n130 = this.bvmgr.makeBitvector(width, 130L);
        BitvectorFormula a = this.bvmgr.makeVariable(width, "a" + i);
        BitvectorFormula b = this.bvmgr.makeVariable(width, "b" + i);
        BitvectorFormula c = this.bvmgr.makeVariable(width, "c" + i);
        BooleanFormula A = this.bvmgr.equal(b, this.bvmgr.add(a, n130));
        BooleanFormula B = this.bvmgr.greaterThan(b, a, false);
        BooleanFormula C = this.bvmgr.equal(c, this.bvmgr.add(b, n130));
        BooleanFormula D = this.bvmgr.greaterThan(c, b, false);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        Object TC = stack.push(C);
        Object TD = stack.push(D);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        BooleanFormula itp = stack.getInterpolant((Collection<T>)ImmutableList.of());
        BooleanFormula itpA = stack.getInterpolant((Collection<T>)ImmutableList.of(TA));
        BooleanFormula itpAB = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB));
        BooleanFormula itpABC = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB, TC));
        BooleanFormula itpD = stack.getInterpolant((Collection<T>)ImmutableList.of(TD));
        BooleanFormula itpDC = stack.getInterpolant((Collection<T>)ImmutableList.of(TD, TC));
        BooleanFormula itpDCB = stack.getInterpolant((Collection<T>)ImmutableList.of(TD, TC, TB));
        BooleanFormula itpABCD = stack.getInterpolant((Collection<T>)ImmutableList.of(TA, TB, TC, TD));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        Truth.assertThat((Object)this.bmgr.makeBoolean(true)).isEqualTo((Object)itp);
        Truth.assertThat((Object)this.bmgr.makeBoolean(false)).isEqualTo((Object)itpABCD);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), (List<BooleanFormula>)ImmutableList.of((Object)itpA, (Object)itpAB, (Object)itpABC));
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), (List<BooleanFormula>)ImmutableList.of((Object)itpD, (Object)itpDC, (Object)itpDCB));
    }

    private void requireTreeItp() {
        this.requireInterpolation();
        TruthJUnit.assume().withMessage("Solver does not support tree-interpolation.").that((Comparable)((Object)this.solver)).isAnyOf((Object)SolverContextFactory.Solvers.Z3, (Object)SolverContextFactory.Solvers.SMTINTERPOL, new Object[]{SolverContextFactory.Solvers.PRINCESS});
    }

    @Test
    public <T> void sequentialInterpolation() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        this.requireIntegers();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        Object TC = stack.push(C);
        Object TD = stack.push(D);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps1 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TB, TC, TD));
        List<BooleanFormula> itps2 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TD, TC, TB, TA));
        List<BooleanFormula> itps3 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TC, TB, TD));
        List<BooleanFormula> itps4 = stack.getSeqInterpolants(Lists.transform((List)ImmutableList.of(TA, TA, TA, TB, TC, TD, TD), ImmutableSet::of));
        List<BooleanFormula> itps5 = stack.getSeqInterpolants(Lists.transform((List)ImmutableList.of(TA, TA, TB, TC, TD, TA, TD), ImmutableSet::of));
        List<BooleanFormula> itps6 = stack.getSeqInterpolants(Lists.transform((List)ImmutableList.of(TB, TC, TD, TA, TA, TA, TD), ImmutableSet::of));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), itps1);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), itps2);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)C, (Object)B, (Object)D), itps3);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)A, (Object)C, (Object)B, (Object)D, (Object)D), itps4);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)B, (Object)C, (Object)D, (Object)A, (Object)D), itps5);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)C, (Object)D, (Object)A, (Object)A, (Object)A, (Object)D), itps6);
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void sequentialInterpolationWithoutPartition() throws SolverException, InterruptedException {
        this.requireIntegers();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        stack.push(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getSeqInterpolants((List<Collection<T>>)ImmutableList.of());
        Truth.assert_().fail();
    }

    @Test
    public <T> void sequentialInterpolationWithOnePartition() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        this.requireIntegers();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        ImmutableList partition = ImmutableList.of(TA, TB);
        List<BooleanFormula> itps = stack.getSeqInterpolants((List<Collection<T>>)ImmutableList.of((Object)partition));
        Truth.assertThat(itps).isEmpty();
    }

    @Test
    public <T> void sequentialInterpolationWithFewPartitions() throws SolverException, InterruptedException {
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        this.requireIntegers();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        ImmutableSet partition = ImmutableSet.of(TA, TB);
        List<BooleanFormula> itps1 = stack.getSeqInterpolants((List<Collection<T>>)ImmutableList.of((Object)partition));
        List<BooleanFormula> itps2 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TB));
        List<BooleanFormula> itps3 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TB, TA));
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)this.bmgr.and(A, B)), itps1);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B), itps2);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)A), itps3);
    }

    @Test
    public <T> void sequentialBVInterpolation() throws SolverException, InterruptedException {
        this.requireBitvectors();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        int width = 8;
        BitvectorFormula zero = this.bvmgr.makeBitvector(width, 0L);
        BitvectorFormula one = this.bvmgr.makeBitvector(width, 1L);
        BitvectorFormula a = this.bvmgr.makeVariable(width, "a" + i);
        BitvectorFormula b = this.bvmgr.makeVariable(width, "b" + i);
        BitvectorFormula c = this.bvmgr.makeVariable(width, "c" + i);
        BooleanFormula A = this.bvmgr.equal(one, a);
        BooleanFormula B = this.bvmgr.equal(a, b);
        BooleanFormula C = this.bvmgr.equal(b, c);
        BooleanFormula D = this.bvmgr.equal(c, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        Object TC = stack.push(C);
        Object TD = stack.push(D);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps1 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TB, TC, TD));
        List<BooleanFormula> itps2 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TD, TC, TB, TA));
        List<BooleanFormula> itps3 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TC, TB, TD));
        List<BooleanFormula> itps4 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TA, TA, TB, TC, TD, TD));
        List<BooleanFormula> itps5 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TA, TA, TB, TC, TD, TA, TD));
        List<BooleanFormula> itps6 = stack.getSeqInterpolants0((List<T>)ImmutableList.of(TB, TC, TD, TA, TA, TA, TD));
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D), itps1);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)D, (Object)C, (Object)B, (Object)A), itps2);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)C, (Object)B, (Object)D), itps3);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)A, (Object)C, (Object)B, (Object)D, (Object)D), itps4);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)A, (Object)A, (Object)B, (Object)C, (Object)D, (Object)A, (Object)D), itps5);
        this.checkItpSequence(stack, (List<BooleanFormula>)ImmutableList.of((Object)B, (Object)C, (Object)D, (Object)A, (Object)A, (Object)A, (Object)D), itps6);
    }

    @Test
    public <T> void treeInterpolation() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, d);
        BooleanFormula E = this.imgr.equal(d, zero);
        this.testTreeInterpolants0(stack, A, B, C, D, E);
        this.testTreeInterpolants0(stack, A, B, C, E, D);
        this.testTreeInterpolants0(stack, A, B, D, C, E);
        this.testTreeInterpolants0(stack, A, B, D, E, C);
        this.testTreeInterpolants0(stack, A, B, E, C, D);
        this.testTreeInterpolants0(stack, A, B, E, D, C);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants0(stack, this.bmgr.not(A), A, B, B, B);
        this.testTreeInterpolants1(stack, A, B, C, D, E);
        this.testTreeInterpolants1(stack, A, B, C, E, D);
        this.testTreeInterpolants1(stack, A, B, D, C, E);
        this.testTreeInterpolants1(stack, A, B, D, E, C);
        this.testTreeInterpolants1(stack, A, B, E, C, D);
        this.testTreeInterpolants1(stack, A, B, E, D, C);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants1(stack, this.bmgr.not(A), A, B, B, B);
        this.testTreeInterpolants2(stack, A, B, C, D, E);
        this.testTreeInterpolants2(stack, A, B, C, E, D);
        this.testTreeInterpolants2(stack, A, B, D, C, E);
        this.testTreeInterpolants2(stack, A, B, D, E, C);
        this.testTreeInterpolants2(stack, A, B, E, C, D);
        this.testTreeInterpolants2(stack, A, B, E, D, C);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, A, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, A, B);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, B, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, B, A, A);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, A, B, B);
        this.testTreeInterpolants2(stack, this.bmgr.not(A), A, B, B, B);
    }

    private <T> void testTreeInterpolants0(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        Object TA = stack.push(pA);
        Object TB = stack.push(pB);
        Object TC = stack.push(pC);
        Object TD = stack.push(pD);
        Object TE = stack.push(pE);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TB, TD, TE, TC), new int[]{0, 0, 2, 2, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), pB), itps.get(1));
        this.checkImplies(stack, pD, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), pE), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), itps.get(3), pC), this.bmgr.makeBoolean(false));
    }

    private <T> void testTreeInterpolants1(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        Object TA = stack.push(pA);
        Object TB = stack.push(pB);
        Object TC = stack.push(pC);
        Object TD = stack.push(pD);
        Object TE = stack.push(pE);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TB, TC, TD, TE), new int[]{0, 1, 2, 3, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, pB, itps.get(1));
        this.checkImplies(stack, pC, itps.get(2));
        this.checkImplies(stack, pD, itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), itps.get(1), itps.get(2), itps.get(3), pE), this.bmgr.makeBoolean(false));
    }

    private <T> void testTreeInterpolants2(InterpolatingProverEnvironment<T> stack, BooleanFormula pA, BooleanFormula pB, BooleanFormula pC, BooleanFormula pD, BooleanFormula pE) throws SolverException, InterruptedException {
        Object TA = stack.push(pA);
        Object TB = stack.push(pB);
        Object TC = stack.push(pC);
        Object TD = stack.push(pD);
        Object TE = stack.push(pE);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TB, TC, TD, TE), new int[]{0, 0, 0, 0, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, pA, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), pB), itps.get(1));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), pC), itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), pD), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(3), pE), this.bmgr.makeBoolean(false));
    }

    @Test
    public <T> void treeInterpolation2() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula five = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula R1 = this.imgr.equal(b, c);
        BooleanFormula C = this.imgr.equal(c, (NumeralFormula.IntegerFormula)this.imgr.add(d, one));
        BooleanFormula R2 = this.imgr.equal(d, e);
        BooleanFormula D = this.imgr.equal(e, five);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        Object TC = stack.push(C);
        Object TD = stack.push(D);
        Object TR1 = stack.push(R1);
        Object TR2 = stack.push(R2);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TB, TC, TR1, TD, TR2), new int[]{0, 0, 2, 0, 4, 0});
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        stack.pop();
        this.checkImplies(stack, A, itps.get(0));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), B), itps.get(1));
        this.checkImplies(stack, C, itps.get(2));
        this.checkImplies(stack, this.bmgr.and(itps.get(1), itps.get(2), R1), itps.get(3));
        this.checkImplies(stack, D, itps.get(4));
        this.checkImplies(stack, this.bmgr.and(itps.get(3), itps.get(4), R2), this.bmgr.makeBoolean(false));
    }

    @Test
    public <T> void treeInterpolation3() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula five = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula R1 = this.imgr.equal(b, c);
        BooleanFormula C = this.imgr.equal(c, (NumeralFormula.IntegerFormula)this.imgr.add(d, one));
        BooleanFormula R2 = this.imgr.equal(d, e);
        BooleanFormula D = this.imgr.equal(e, five);
        ImmutableSet TB = ImmutableSet.of(stack.push(A), stack.push(B));
        ImmutableSet TR1 = ImmutableSet.of(stack.push(R1));
        ImmutableSet TC = ImmutableSet.of(stack.push(A), stack.push(C));
        ImmutableSet TR2 = ImmutableSet.of(stack.push(R2));
        ImmutableSet TD = ImmutableSet.of(stack.push(A), stack.push(D));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of((Object)TB, (Object)TC, (Object)TR1, (Object)TD, (Object)TR2), new int[]{0, 1, 0, 3, 0});
        Truth.assertThat(itps).hasSize(4);
        for (int j = 0; j < 6; ++j) {
            stack.pop();
        }
        this.checkImplies(stack, this.bmgr.and(A, B), itps.get(0));
        this.checkImplies(stack, this.bmgr.and(A, C), itps.get(1));
        this.checkImplies(stack, this.bmgr.and(itps.get(0), itps.get(1), R1), itps.get(2));
        this.checkImplies(stack, this.bmgr.and(A, D), itps.get(3));
        this.checkImplies(stack, this.bmgr.and(itps.get(2), itps.get(3), R2), this.bmgr.makeBoolean(false));
    }

    @Test
    public <T> void treeInterpolationForSequence() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, zero);
        ImmutableList formulas = ImmutableList.of(stack.push(A), stack.push(B));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itp = stack.getTreeInterpolants0((List<T>)formulas, new int[]{0, 0});
        Truth.assertThat(itp).hasSize(1);
    }

    @Test
    public <T> void treeInterpolationBranching() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        NumeralFormula.IntegerFormula b = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("b" + i);
        NumeralFormula.IntegerFormula c = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("c" + i);
        NumeralFormula.IntegerFormula d = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("d" + i);
        NumeralFormula.IntegerFormula e = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("e" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, b);
        BooleanFormula C = this.imgr.equal(b, c);
        BooleanFormula D = this.imgr.equal(c, d);
        BooleanFormula E = this.imgr.equal(d, e);
        BooleanFormula F = this.imgr.equal(e, zero);
        ImmutableList formulas = ImmutableList.of(stack.push(A), stack.push(B), stack.push(C), stack.push(D), stack.push(E), stack.push(F));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        List<BooleanFormula> itp = stack.getTreeInterpolants0((List<T>)formulas, new int[]{0, 1, 2, 3, 4, 0});
        Truth.assertThat(itp).hasSize(5);
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed1() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        ImmutableSet TA = ImmutableSet.of(stack.push(A));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of((Object)TA), new int[]{0, 0});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed2() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        ImmutableSet TA = ImmutableSet.of(stack.push(A));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of((Object)TA), new int[]{4});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed3() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        ImmutableSet TA = ImmutableSet.of(stack.push(A));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of((Object)TA, (Object)TA), new int[]{1, 0});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed4() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        Object TA = stack.push(A);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TA, TA), new int[]{0, 1, 1});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed5() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        Object TA = stack.push(A);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TA, TA), new int[]{0, 1, 2});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationMalFormed6() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        BooleanFormula A = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        Object TA = stack.push(A);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants0((List<T>)ImmutableList.of(TA, TA, TA), new int[]{0, 2, 0});
    }

    @Test(expected=IllegalArgumentException.class)
    public <T> void treeInterpolationWithoutPartition() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        stack.push(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of(), new int[0]);
        Truth.assert_().fail();
    }

    @Test
    public <T> void treeInterpolationWithOnePartition() throws SolverException, InterruptedException {
        this.requireTreeItp();
        InterpolatingProverEnvironment<T> stack = this.newEnvironmentForTest();
        int i = index.getFreshId();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula one = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L);
        NumeralFormula.IntegerFormula a = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("a" + i);
        BooleanFormula A = this.imgr.equal(one, a);
        BooleanFormula B = this.imgr.equal(a, zero);
        Object TA = stack.push(A);
        Object TB = stack.push(B);
        ProverEnvironmentSubject.assertThat(stack).isUnsatisfiable();
        ImmutableList partition = ImmutableList.of(TA, TB);
        List<BooleanFormula> itps = stack.getTreeInterpolants((List<Collection<T>>)ImmutableList.of((Object)partition), new int[]{0});
        Truth.assertThat(itps).isEmpty();
    }

    private void checkItpSequence(InterpolatingProverEnvironment<?> stack, List<BooleanFormula> formulas, List<BooleanFormula> itps) throws SolverException, InterruptedException {
        Truth.assertWithMessage((String)"there should be N-1 interpolants for N formulas, but we got %s for %s", (Object[])new Object[]{itps, formulas}).that(Boolean.valueOf(formulas.size() - 1 == itps.size())).isTrue();
        if (!itps.isEmpty()) {
            this.checkImplies(stack, formulas.get(0), itps.get(0));
            for (int i = 1; i < formulas.size() - 1; ++i) {
                this.checkImplies(stack, this.bmgr.and(itps.get(i - 1), formulas.get(i)), itps.get(i));
            }
            this.checkImplies(stack, this.bmgr.and((BooleanFormula)Iterables.getLast(itps), (BooleanFormula)Iterables.getLast(formulas)), this.bmgr.makeBoolean(false));
        }
    }

    private void checkImplies(BasicProverEnvironment<?> stack, BooleanFormula a, BooleanFormula b) throws SolverException, InterruptedException {
        stack.push(this.bmgr.or(this.bmgr.not(a), b));
        ProverEnvironmentSubject.assertThat(stack).isSatisfiable();
        stack.pop();
    }
}

