/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import java.util.Random;
import java.util.stream.IntStream;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.NumeralFormula;

class IntegerTheoryFuzzer {
    private final IntegerFormulaManager ifmgr;
    private NumeralFormula.IntegerFormula[] vars = new NumeralFormula.IntegerFormula[0];
    private final Random r;
    private static final String varNameTemplate = "VAR_";
    private int maxConstant;

    IntegerTheoryFuzzer(FormulaManager fmgr, Random pR) {
        this.ifmgr = fmgr.getIntegerFormulaManager();
        this.r = pR;
    }

    public NumeralFormula.IntegerFormula fuzz(int formulaSize, int pMaxConstant) {
        NumeralFormula.IntegerFormula[] args = (NumeralFormula.IntegerFormula[])IntStream.range(0, formulaSize).mapToObj(i -> (NumeralFormula.IntegerFormula)this.ifmgr.makeVariable(varNameTemplate + i)).toArray(NumeralFormula.IntegerFormula[]::new);
        return this.fuzz(formulaSize, pMaxConstant, args);
    }

    public NumeralFormula.IntegerFormula fuzz(int formulaSize, int pMaxConstant, NumeralFormula.IntegerFormula ... pVars) {
        this.vars = pVars;
        this.maxConstant = pMaxConstant;
        return this.recFuzz(formulaSize);
    }

    private NumeralFormula.IntegerFormula recFuzz(int pFormulaSize) {
        if (pFormulaSize == 1) {
            if (this.r.nextBoolean()) {
                return this.getConstant();
            }
            return this.getVar();
        }
        if (pFormulaSize == 2) {
            return (NumeralFormula.IntegerFormula)this.ifmgr.negate(this.getVar());
        }
        int pivot = 1 + this.r.nextInt(--pFormulaSize - 1);
        switch (this.r.nextInt(3)) {
            case 0: {
                return (NumeralFormula.IntegerFormula)this.ifmgr.add(this.recFuzz(pivot), this.recFuzz(pFormulaSize - pivot));
            }
            case 1: {
                return (NumeralFormula.IntegerFormula)this.ifmgr.subtract(this.recFuzz(pivot), this.recFuzz(pFormulaSize - pivot));
            }
            case 2: {
                return (NumeralFormula.IntegerFormula)this.ifmgr.multiply(this.getConstant(), this.recFuzz(pFormulaSize - 1));
            }
        }
        throw new UnsupportedOperationException("Unexpected state");
    }

    private NumeralFormula.IntegerFormula getConstant() {
        return (NumeralFormula.IntegerFormula)this.ifmgr.makeNumber((long)this.r.nextInt(2 * this.maxConstant) - (long)this.maxConstant);
    }

    private NumeralFormula.IntegerFormula getVar() {
        return this.vars[this.r.nextInt(this.vars.length)];
    }
}

