/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.example.FormulaClassifier;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class FormulaClassifierTest
extends SolverBasedTest0 {
    private FormulaClassifier classifier;
    private static final String VARS = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)";
    private static final String BVS = "(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))";
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.classifier = new FormulaClassifier(this.context);
    }

    @Test
    public void test_AUFLIA() {
        this.requireParser();
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((z Int)) (= (select arr x) (foo z))))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"AUFLIA");
    }

    @Test
    public void test_QF_AUFLIA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr x) (foo 0)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_AUFLIA");
    }

    @Test
    public void test_QF_AUFLIRA() {
        this.requireParser();
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr x) (bar (/ 1 2))))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_AUFLIRA");
    }

    @Test
    public void test_QF_AUFNIRA() {
        this.requireParser();
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (select arr (* x x)) (bar (/ 1 2))))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_AUFNIRA");
    }

    @Test
    public void test_LIA() {
        this.requireParser();
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((z Int)) (= (+ x 1) 0)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"LIA");
    }

    @Test
    public void test_LRA() {
        this.requireParser();
        this.requireQuantifiers();
        this.requireRationals();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (= (+ y y) zz)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"LRA");
    }

    @Test
    public void test_ABV() {
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        this.requireQuantifiers();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (exists ((bv2 (_ BitVec 4))) (= bv bv2)) (= arr arr2)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"ABV");
    }

    @Test
    public void test_QF_AUFBV() {
        this.requireParser();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (= bv bv2) (= arr arr2) (= (foo x) x)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_AUFBV");
    }

    @Test
    public void test_QF_BV() {
        this.requireParser();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (bvult bv (bvadd bv #x1)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_BV");
    }

    @Test
    public void test_QF_LIA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (* x 2)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_LIA");
    }

    @Test
    public void test_QF_LRA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy y))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_LRA");
    }

    @Test
    public void test_QF_NIA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (* x x)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_NIA");
    }

    @Test
    public void test_QF_NRA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy (* y y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_NRA");
    }

    @Test
    public void test_QF_UF() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (= (foo x) x))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_UF");
    }

    @Test
    public void test_QF_UFBV() {
        this.requireParser();
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun bv () (_ BitVec 4))(declare-fun bv2 () (_ BitVec 4))(assert (and (= bv bv2) (= (foo x) x)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_UFBV");
    }

    @Test
    public void test_QF_UFLIA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< xx (+ x (foo x))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_UFLIA");
    }

    @Test
    public void test_QF_UFLRA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< yy (bar y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_UFLRA");
    }

    @Test
    public void test_QF_UFNRA() {
        this.requireParser();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (< (* y yy) (bar y)))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_UFNRA");
    }

    @Test
    public void test_UFLRA() {
        this.requireParser();
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (< (+ y yy) (bar y))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"UFLRA");
    }

    @Test
    public void test_UFNRA() {
        this.requireParser();
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(assert (exists ((zz Real)) (< (* y yy) (bar y))))";
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"UFNRA");
    }

    @Test
    public void test_QF_FP() {
        this.requireParser();
        this.requireFloats();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun a () Float32) (assert (fp.eq a (fp.add RNE a a)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"QF_FP");
    }

    @Test
    public void test_FP() {
        this.requireParser();
        this.requireFloats();
        this.requireQuantifiers();
        String query = "(declare-fun x () Int)(declare-fun xx () Int)(declare-fun y () Real)(declare-fun yy () Real)(declare-fun arr () (Array Int Int))(declare-fun arr2 () (Array Int Int))(declare-fun foo (Int) Int)(declare-fun bar (Real) Real)(declare-fun a () Float32) (assert (exists ((zz Real)) (fp.eq a a)))";
        this.classifier.visit(this.mgr.parse(query));
        Truth.assertThat((String)this.classifier.toString()).isEqualTo((Object)"FP");
    }
}

