/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class BitvectorFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    private static final int[] SOME_SIZES = new int[]{1, 2, 4, 10, 16, 20, 32, 60};
    private static final int[] SOME_NUMBERS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 32, 64, 100, 150, 512, 1024, 100000, 1000000, Integer.MAX_VALUE};

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void init() {
        this.requireBitvectors();
    }

    @Test
    public void bvType() {
        int[] testValues = this.solver == SolverContextFactory.Solvers.BOOLECTOR ? new int[]{2, 4, 32, 64, 1000} : new int[]{1, 2, 4, 32, 64, 1000};
        for (int i : testValues) {
            FormulaType.BitvectorType type = FormulaType.getBitvectorTypeWithSize(i);
            Truth.assertWithMessage((String)"bitvector type size").that(Integer.valueOf(type.getSize())).isEqualTo((Object)i);
            BitvectorFormula var = this.bvmgr.makeVariable(type, "x" + i);
            FormulaType.BitvectorType result = (FormulaType.BitvectorType)this.mgr.getFormulaType(var);
            Truth.assertWithMessage((String)"bitvector size").that(Integer.valueOf(result.getSize())).isEqualTo((Object)i);
        }
    }

    @Test
    public void bvOne() throws SolverException, InterruptedException {
        int[] testValues = this.solver == SolverContextFactory.Solvers.BOOLECTOR ? new int[]{2, 4, 32, 64, 1000} : new int[]{1, 2, 4, 32, 64, 1000};
        for (int i : testValues) {
            BitvectorFormula var = this.bvmgr.makeVariable(i, "x" + i);
            BitvectorFormula num0 = this.bvmgr.makeBitvector(i, 0L);
            BitvectorFormula num1 = this.bvmgr.makeBitvector(i, 1L);
            this.assertThatFormula(this.bvmgr.equal(var, num0)).isSatisfiable();
            this.assertThatFormula(this.bvmgr.equal(var, num1)).isSatisfiable();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void bvTooLargeNum() {
        if (this.solver == SolverContextFactory.Solvers.BOOLECTOR) {
            this.bvmgr.makeBitvector(2, 4L);
        } else {
            this.bvmgr.makeBitvector(1, 2L);
        }
    }

    @Test
    public void bvLargeNum() {
        if (this.solver == SolverContextFactory.Solvers.BOOLECTOR) {
            this.bvmgr.makeBitvector(2, 3L);
        } else {
            this.bvmgr.makeBitvector(1, 1L);
        }
    }

    @Test
    public void bvSmallNum() {
        if (this.solver == SolverContextFactory.Solvers.BOOLECTOR) {
            this.bvmgr.makeBitvector(2, -1L);
        } else {
            this.bvmgr.makeBitvector(1, -1L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void bvTooSmallNum() {
        if (this.solver == SolverContextFactory.Solvers.BOOLECTOR) {
            this.bvmgr.makeBitvector(2, -4L);
        } else {
            this.bvmgr.makeBitvector(1, -2L);
        }
    }

    @Test
    public void bvModelValue32bit() throws SolverException, InterruptedException {
        BitvectorFormula var = this.bvmgr.makeVariable(32, "var");
        LinkedHashMap<Long, Long> values = new LinkedHashMap<Long, Long>();
        long int32 = 0x100000000L;
        values.put(0L, 0L);
        values.put(1L, 1L);
        values.put(2L, 2L);
        values.put(123L, 123L);
        values.put((Long)Integer.MAX_VALUE, (Long)Integer.MAX_VALUE);
        values.put(0x80000000L, 0x80000000L);
        values.put(0x80000001L, 0x80000001L);
        values.put(2147483770L, 2147483770L);
        values.put(int32 - 1L, int32 - 1L);
        values.put(int32 - 2L, int32 - 2L);
        values.put(int32 - 123L, int32 - 123L);
        values.put(-1L, int32 - 1L);
        values.put(-2L, int32 - 2L);
        values.put(-123L, int32 - 123L);
        values.put((Long)Integer.MIN_VALUE, 0x80000000L);
        try (ProverEnvironment prover = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            for (Map.Entry entry : values.entrySet()) {
                prover.push(this.bvmgr.equal(var, this.bvmgr.makeBitvector(32, (Long)entry.getKey())));
                ProverEnvironmentSubject.assertThat(prover).isSatisfiable();
                try (Model model = prover.getModel();){
                    BigInteger value = model.evaluate(var);
                    Truth.assertThat((Object)value).isEqualTo((Object)BigInteger.valueOf((Long)entry.getValue()));
                }
                prover.pop();
            }
        }
    }

    @Test
    public void bvToInt() throws SolverException, InterruptedException {
        this.requireIntegers();
        for (int size : new int[]{1, 2, 4, 8}) {
            int max = 1 << size;
            for (int i = -max / 2; i < max; ++i) {
                BitvectorFormula bv = this.bvmgr.makeBitvector(size, i);
                NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(i);
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, num))).isTautological();
                NumeralFormula.IntegerFormula nSigned = this.bvmgr.toIntegerFormula(bv, true);
                NumeralFormula.IntegerFormula nUnsigned = this.bvmgr.toIntegerFormula(bv, false);
                if (i < max / 2) {
                    this.assertThatFormula(this.imgr.equal(num, nSigned)).isTautological();
                    this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, nSigned))).isTautological();
                }
                if (i < 0) continue;
                this.assertThatFormula(this.imgr.equal(num, nUnsigned)).isTautological();
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, nUnsigned))).isTautological();
            }
        }
    }

    @Test
    public void bvToIntEquality() throws SolverException, InterruptedException {
        this.requireIntegers();
        for (int size : new int[]{10, 16, 20, 32, 64}) {
            for (int i : new int[]{1, 2, 4, 32, 64, 100}) {
                BitvectorFormula bv = this.bvmgr.makeBitvector(size, i);
                NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(i);
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, num))).isTautological();
                NumeralFormula.IntegerFormula nSigned = this.bvmgr.toIntegerFormula(bv, true);
                NumeralFormula.IntegerFormula nUnsigned = this.bvmgr.toIntegerFormula(bv, false);
                this.assertThatFormula(this.imgr.equal(num, nSigned)).isTautological();
                this.assertThatFormula(this.imgr.equal(num, nUnsigned)).isTautological();
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, nSigned))).isTautological();
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, nUnsigned))).isTautological();
            }
        }
    }

    @Test
    public void bvToIntEqualityWithOverflow() throws SolverException, InterruptedException {
        this.requireIntegers();
        for (int size : SOME_SIZES) {
            for (int i : SOME_NUMBERS) {
                long upperBound = 1L << size;
                long iMod = (long)i % upperBound;
                NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(i);
                NumeralFormula.IntegerFormula nUnsigned = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(iMod);
                NumeralFormula.IntegerFormula nSigned = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(iMod < upperBound / 2L ? iMod : iMod - upperBound);
                BitvectorFormula bv = this.bvmgr.makeBitvector(size, iMod);
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, num))).isTautological();
                Truth.assertThat(this.mgr.getFormulaType(this.bvmgr.toIntegerFormula(bv, true))).isEqualTo(FormulaType.IntegerType);
                this.assertThatFormula(this.imgr.equal(nSigned, this.bvmgr.toIntegerFormula(bv, true))).isTautological();
                this.assertThatFormula(this.imgr.equal(nUnsigned, this.bvmgr.toIntegerFormula(bv, false))).isTautological();
            }
        }
    }

    @Test
    public void bvToIntEqualityWithOverflowNegative() throws SolverException, InterruptedException {
        this.requireIntegers();
        for (int size : SOME_SIZES) {
            for (int i : SOME_NUMBERS) {
                int negI = -i;
                long upperBound = 1L << size;
                long iMod = (long)negI % upperBound;
                NumeralFormula.IntegerFormula num = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(negI);
                NumeralFormula.IntegerFormula nUnsigned = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(iMod >= 0L ? iMod : iMod + upperBound);
                NumeralFormula.IntegerFormula nSigned = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(iMod < -upperBound / 2L ? iMod + upperBound : iMod);
                BitvectorFormula bv = this.bvmgr.makeBitvector(size, iMod >= -upperBound / 2L ? iMod : iMod + upperBound);
                this.assertThatFormula(this.bvmgr.equal(bv, this.bvmgr.makeBitvector(size, num))).isTautological();
                this.assertThatFormula(this.imgr.equal(nSigned, this.bvmgr.toIntegerFormula(bv, true))).isTautological();
                this.assertThatFormula(this.imgr.equal(nUnsigned, this.bvmgr.toIntegerFormula(bv, false))).isTautological();
            }
        }
    }

    @Test
    public void bvToIntEqualityWithSymbols() throws SolverException, InterruptedException {
        this.requireIntegers();
        for (int size : new int[]{1, 2, 4, 10}) {
            NumeralFormula.IntegerFormula var = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x_" + size);
            this.assertThatFormula(this.imgr.equal(var, this.bvmgr.toIntegerFormula(this.bvmgr.makeBitvector(size, var), true))).isSatisfiable();
            this.assertThatFormula(this.bmgr.not(this.imgr.equal(var, this.bvmgr.toIntegerFormula(this.bvmgr.makeBitvector(size, var), true)))).isSatisfiable();
            BitvectorFormula bvar = this.bvmgr.makeVariable(size, "y_" + size);
            this.assertThatFormula(this.bvmgr.equal(bvar, this.bvmgr.makeBitvector(size, this.bvmgr.toIntegerFormula(bvar, true)))).isTautological();
        }
    }
}

