/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.truth.Truth;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5AbstractNativeApiTest;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

public class Mathsat5NativeApiTest
extends Mathsat5AbstractNativeApiTest {
    private long const0;
    private long const1;
    private long var;

    @BeforeClass
    public static void loadMathsat() {
        try {
            NativeLibraries.loadLibrary((String)"mathsat5j");
        }
        catch (UnsatisfiedLinkError e) {
            throw new AssumptionViolatedException("MathSAT5 is not available", (Throwable)e);
        }
    }

    @Before
    public void createEnvironment() {
        long cfg = Mathsat5NativeApi.msat_create_config();
        this.env = Mathsat5NativeApi.msat_create_env(cfg);
        Mathsat5NativeApi.msat_destroy_config(cfg);
        this.const0 = Mathsat5NativeApi.msat_make_number(this.env, "0");
        this.const1 = Mathsat5NativeApi.msat_make_number(this.env, "1");
        long rationalType = Mathsat5NativeApi.msat_get_rational_type(this.env);
        this.var = Mathsat5NativeApi.msat_make_variable(this.env, "rat", rationalType);
    }

    @Test
    public void sinTest() throws IllegalStateException, InterruptedException, SolverException {
        long sin = Mathsat5NativeApi.msat_make_sin(this.env, this.var);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const0));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, sin, this.const0));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, sin, this.const0));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
    }

    @Test
    public void expTest() throws IllegalStateException, InterruptedException, SolverException {
        long exp = Mathsat5NativeApi.msat_make_exp(this.env, this.var);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const0));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, exp, this.const1));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, exp, this.const1));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
    }

    @Ignore
    public void piTest() throws IllegalStateException, InterruptedException, SolverException {
        long pi = Mathsat5NativeApi.msat_make_pi(this.env);
        long sin = Mathsat5NativeApi.msat_make_sin(this.env, this.var);
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_term_is_pi(this.env, pi)).isTrue();
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_term_is_pi(this.env, this.const0)).isFalse();
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_eq(this.env, sin, this.const0));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_eq(this.env, this.var, pi));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
    }

    @Ignore
    public void asinTest() throws IllegalStateException, InterruptedException, SolverException {
        long asin = Mathsat5NativeApi.msat_make_asin(this.env, this.var);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const0));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, asin, this.const0));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, asin, this.const0));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
    }

    @Ignore
    public void logTest() throws IllegalStateException, InterruptedException, SolverException {
        long logE = Mathsat5NativeApi.msat_make_log(this.env, Mathsat5NativeApi.msat_make_exp(this.env, this.var));
        long logVar = Mathsat5NativeApi.msat_make_log(this.env, this.var);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, logVar, this.const0));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, logE, this.const1));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, this.const1));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, logVar, this.const1));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
    }

    @Test
    public void powTest() throws IllegalStateException, InterruptedException, SolverException {
        long const2 = Mathsat5NativeApi.msat_make_number(this.env, "2");
        long const3 = Mathsat5NativeApi.msat_make_number(this.env, "3");
        long pow2 = Mathsat5NativeApi.msat_make_pow(this.env, this.var, const2);
        long pow3 = Mathsat5NativeApi.msat_make_pow(this.env, this.var, const3);
        long mult2 = Mathsat5NativeApi.msat_make_times(this.env, this.var, this.var);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_not(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, Mathsat5NativeApi.msat_make_number(this.env, "1"))));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_not(this.env, Mathsat5NativeApi.msat_make_equal(this.env, this.var, Mathsat5NativeApi.msat_make_number(this.env, "0"))));
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, pow2, mult2));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, pow3, mult2));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
    }
}

