/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

@Ignore(value="prevent this abstract class being executed as testcase by ant")
public abstract class Mathsat5AbstractNativeApiTest {
    protected long env;

    @After
    public void freeEnvironment() {
        Mathsat5NativeApi.msat_destroy_env(this.env);
    }

    @Test
    public void bvSize() {
        long number = Mathsat5NativeApi.msat_make_bv_number(this.env, "42", 32, 10);
        long type = Mathsat5NativeApi.msat_term_get_type(number);
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_is_bv_type(this.env, type)).isTrue();
        Truth.assertThat((Integer)Mathsat5NativeApi.msat_get_bv_type_size(this.env, type)).isEqualTo((Object)32);
        long funcDecl = Mathsat5NativeApi.msat_declare_function(this.env, "testVar", type);
        long var = Mathsat5NativeApi.msat_make_constant(this.env, funcDecl);
        type = Mathsat5NativeApi.msat_term_get_type(var);
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_is_bv_type(this.env, type)).isTrue();
        Truth.assertThat((Integer)Mathsat5NativeApi.msat_get_bv_type_size(this.env, type)).isEqualTo((Object)32);
    }

    @Test
    public void fpExpWidth() {
        long type = Mathsat5NativeApi.msat_get_fp_type(this.env, 8, 23);
        Truth.assertThat((Integer)Mathsat5NativeApi.msat_get_fp_type_exp_width(this.env, type)).isEqualTo((Object)8);
    }

    @Test
    public void fpMantWidth() {
        long type = Mathsat5NativeApi.msat_get_fp_type(this.env, 8, 23);
        Truth.assertThat((Integer)Mathsat5NativeApi.msat_get_fp_type_mant_width(this.env, type)).isEqualTo((Object)23);
    }

    @Test(expected=IllegalArgumentException.class)
    public void fpExpWidthIllegal() {
        long type = Mathsat5NativeApi.msat_get_integer_type(this.env);
        Mathsat5NativeApi.msat_get_fp_type_exp_width(this.env, type);
    }

    @Test
    public void modularCongruence() throws InterruptedException, IllegalStateException, SolverException {
        long type = Mathsat5NativeApi.msat_get_integer_type(this.env);
        long v1 = Mathsat5NativeApi.msat_declare_function(this.env, "v1", type);
        long t1 = Mathsat5NativeApi.msat_make_constant(this.env, v1);
        long v2 = Mathsat5NativeApi.msat_declare_function(this.env, "v2", type);
        long t2 = Mathsat5NativeApi.msat_make_constant(this.env, v2);
        long t = Mathsat5NativeApi.msat_make_int_modular_congruence(this.env, "42", t1, t2);
        Truth.assertThat((String)Mathsat5NativeApi.msat_term_repr(t)).isEqualTo((Object)"(`int_mod_congr_42` (`+_int` v1 (`*_int` -1 v2)) 0)");
        Mathsat5NativeApi.msat_assert_formula(this.env, t);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "3")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "87")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isTrue();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
        Mathsat5NativeApi.msat_push_backtrack_point(this.env);
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t1, Mathsat5NativeApi.msat_make_number(this.env, "4")));
        Mathsat5NativeApi.msat_assert_formula(this.env, Mathsat5NativeApi.msat_make_equal(this.env, t2, Mathsat5NativeApi.msat_make_number(this.env, "45")));
        Truth.assertThat((Boolean)Mathsat5NativeApi.msat_check_sat(this.env)).isFalse();
        Mathsat5NativeApi.msat_pop_backtrack_point(this.env);
    }
}

