/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import org.junit.After;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorSolverContext;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;
import org.sosy_lab.java_smt.solvers.boolector.BtorOption;

public class BoolectorNativeApiTest {
    private long btor;
    private static final ImmutableMap<String, String> ALLOWED_DIFFS = ImmutableMap.builder().put((Object)"BTOR_OPT_ACKERMANNIZE", (Object)"BTOR_OPT_ACKERMANN").put((Object)"BTOR_OPT_QUANT_DUAL", (Object)"BTOR_OPT_QUANT_DUAL_SOLVER").put((Object)"BTOR_OPT_QUANT_SYNTHLIMIT", (Object)"BTOR_OPT_QUANT_SYNTH_LIMIT").put((Object)"BTOR_OPT_QUANT_SYNTHQI", (Object)"BTOR_OPT_QUANT_SYNTH_QI").put((Object)"BTOR_OPT_QUANT_MS", (Object)"BTOR_OPT_QUANT_MINISCOPE").put((Object)"BTOR_OPT_QUANT_SYNTHCOMPLETE", (Object)"BTOR_OPT_QUANT_SYNTH_ITE_COMPLETE").put((Object)"BTOR_OPT_BETA_REDUCE", (Object)"BTOR_OPT_BETA_REDUCE").put((Object)"BTOR_OPT_DUMP_DIMACS", (Object)"BTOR_OPT_PRINT_DIMACS").put((Object)"BTOR_OPT_SIMP_NORM_ADDS", (Object)"BTOR_OPT_SIMP_NORMAMLIZE_ADDERS").build();

    @BeforeClass
    public static void load() {
        try {
            NativeLibraries.loadLibrary((String)"boolector");
        }
        catch (UnsatisfiedLinkError e) {
            throw new AssumptionViolatedException("Boolector is not available", (Throwable)e);
        }
    }

    @Before
    public void createEnvironment() {
        this.btor = BtorJNI.boolector_new();
    }

    @After
    public void freeEnvironment() {
        BtorJNI.boolector_delete(this.btor);
    }

    @Test
    public void optionNameTest() {
        for (BtorOption option : BtorOption.values()) {
            String optName = BtorJNI.boolector_get_opt_lng(this.btor, option.getValue());
            String converted = "BTOR_OPT_" + optName.replace("-", "_").replace(":", "_").toUpperCase();
            Truth.assertThat((String)option.name()).isEqualTo(ALLOWED_DIFFS.getOrDefault((Object)converted, (Object)converted));
        }
    }

    @Test
    public void satSolverTest() {
        for (BoolectorSolverContext.SatSolver satSolver : BoolectorSolverContext.SatSolver.values()) {
            long btor1 = BtorJNI.boolector_new();
            BtorJNI.boolector_set_sat_solver(btor1, satSolver.name().toLowerCase());
            long newVar = BtorJNI.boolector_var(btor1, BtorJNI.boolector_bool_sort(btor1), "x");
            BtorJNI.boolector_assert(btor1, newVar);
            int result = BtorJNI.boolector_sat(btor1);
            Truth.assertThat((Integer)result).isEqualTo((Object)BtorJNI.BTOR_RESULT_SAT_get());
            BtorJNI.boolector_delete(btor1);
        }
    }

    @Test
    public void satSolverBackendTest() throws InvalidConfigurationException, InterruptedException, SolverException {
        for (BoolectorSolverContext.SatSolver satsolver : BoolectorSolverContext.SatSolver.values()) {
            ConfigurationBuilder config = Configuration.builder().setOption("solver.boolector.satSolver", satsolver.name());
            try (BoolectorSolverContext context = BoolectorSolverContext.create(config.build(), ShutdownNotifier.createDummy(), null, 1L);){
                BooleanFormulaManager bfmgr = context.getFormulaManager().getBooleanFormulaManager();
                BooleanFormula fa = bfmgr.makeVariable("a");
                BooleanFormula fb = bfmgr.makeVariable("b");
                BooleanFormula fc = bfmgr.makeVariable("c");
                BooleanFormula f1 = bfmgr.or(fa, fb, fc);
                BooleanFormula f2 = bfmgr.and(fa, fb, fc);
                try (ProverEnvironment prover = context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
                    prover.addConstraint(bfmgr.equivalence(f1, f2));
                    Truth.assertThat((Boolean)prover.isUnsat()).isFalse();
                }
            }
        }
    }

    @Test
    public void dumpVariableTest() throws InvalidConfigurationException {
        ConfigurationBuilder config = Configuration.builder();
        try (BoolectorSolverContext context = BoolectorSolverContext.create(config.build(), ShutdownNotifier.createDummy(), null, 1L);){
            FormulaManager mgr = context.getFormulaManager();
            BooleanFormulaManager bfmgr = mgr.getBooleanFormulaManager();
            for (String name : ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"abc", (Object)"ABC")) {
                BooleanFormula f = bfmgr.makeVariable(name);
                String s = mgr.dumpFormula(f).toString();
                Truth.assertThat((String)s).contains((CharSequence)String.format("(declare-fun %s () (_ BitVec 1))", name));
            }
        }
    }

    @Test
    public void dumpVariableWithAssertionsOnStackTest() throws InvalidConfigurationException, InterruptedException {
        ConfigurationBuilder config = Configuration.builder();
        try (BoolectorSolverContext context = BoolectorSolverContext.create(config.build(), ShutdownNotifier.createDummy(), null, 1L);){
            FormulaManager mgr = context.getFormulaManager();
            BooleanFormulaManager bfmgr = mgr.getBooleanFormulaManager();
            try (ProverEnvironment prover = context.newProverEnvironment(new SolverContext.ProverOptions[0]);){
                prover.push(bfmgr.makeVariable("x"));
                for (String name : ImmutableList.of((Object)"a", (Object)"a", (Object)"b", (Object)"abc", (Object)"ABC")) {
                    BooleanFormula f = bfmgr.makeVariable(name);
                    String s = mgr.dumpFormula(f).toString();
                    Truth.assertThat((String)s).contains((CharSequence)String.format("(declare-fun BTOR_2@%s () (_ BitVec 1))", name));
                }
            }
        }
    }

    @Test
    public void repeatedDumpFormulaTest() throws InvalidConfigurationException {
        ConfigurationBuilder config = Configuration.builder();
        try (BoolectorSolverContext context = BoolectorSolverContext.create(config.build(), ShutdownNotifier.createDummy(), null, 1L);){
            FormulaManager mgr = context.getFormulaManager();
            BooleanFormulaManager bfmgr = mgr.getBooleanFormulaManager();
            BooleanFormula fa = bfmgr.makeVariable("a");
            BooleanFormula fb = bfmgr.makeVariable("b");
            BooleanFormula fc = bfmgr.makeVariable("c");
            BooleanFormula f1 = bfmgr.or(fa, bfmgr.and(fb, fc));
            BooleanFormula f2 = bfmgr.or(fa, bfmgr.and(fb, fc));
            String s1 = mgr.dumpFormula(f1).toString();
            for (int i = 0; i < 10; ++i) {
                Truth.assertThat((String)s1).isEqualTo((Object)("" + mgr.dumpFormula(f2)));
            }
        }
    }
}

