/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.api.Tactic;
import org.sosy_lab.java_smt.api.visitors.DefaultFormulaVisitor;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"DLS_DEAD_LOCAL_STORE"}, justification="test code")
public class QuantifierManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solverUnderTest;
    private NumeralFormula.IntegerFormula x;
    private ArrayFormula<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula> a;
    private BooleanFormula a_at_x_eq_1;
    private BooleanFormula a_at_x_eq_0;
    private BooleanFormula forall_x_a_at_x_eq_0;
    private static final UniqueIdGenerator index = new UniqueIdGenerator();

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solverUnderTest;
    }

    @Before
    public void setUp() {
        this.requireIntegers();
        this.requireArrays();
        this.requireQuantifiers();
        this.x = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        this.a = this.amgr.makeArray("a", FormulaType.IntegerType, FormulaType.IntegerType);
        this.a_at_x_eq_1 = this.imgr.equal(this.amgr.select(this.a, this.x), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
        this.a_at_x_eq_0 = this.imgr.equal(this.amgr.select(this.a, this.x), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L));
        this.forall_x_a_at_x_eq_0 = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
    }

    private SolverException handleSolverException(SolverException e) throws SolverException {
        if (this.solverUnderTest == SolverContextFactory.Solvers.PRINCESS) {
            TruthJUnit.assume().withMessage(e.getMessage()).fail();
        }
        throw e;
    }

    @Test
    public void testForallArrayConjunctUnsat() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testForallArrayConjunctSat() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
        try {
            this.assertThatFormula(f).isSatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testForallArrayDisjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.bmgr.or(this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        try {
            this.assertThatFormula(f).isSatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testForallArrayDisjunctSat2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testNotExistsArrayConjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        try {
            this.assertThatFormula(f).isUnsatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testNotExistsArrayConjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
        try {
            this.assertThatFormula(f).isSatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testNotExistsArrayConjunct3() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0)), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L)));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testNotExistsArrayDisjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.bmgr.or(this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L))));
        try {
            this.assertThatFormula(f).isSatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testNotExistsArrayDisjunct2() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.or(this.bmgr.not(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.bmgr.not(this.a_at_x_eq_0))), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayConjunct1() throws SolverException, InterruptedException {
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.imgr.equal(this.amgr.select(this.a, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(123L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayConjunct2() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1), this.forall_x_a_at_x_eq_0);
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testExistsArrayConjunct3() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula f = this.bmgr.and(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.forall_x_a_at_x_eq_0);
        try {
            this.assertThatFormula(f).isSatisfiable();
        }
        catch (SolverException e) {
            throw this.handleSolverException(e);
        }
    }

    @Test
    public void testExistsArrayDisjunct1() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula f = this.bmgr.or(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0), this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testExistsArrayDisjunct2() throws SolverException, InterruptedException {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula f = this.bmgr.or(this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1), this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_1));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testContradiction() throws SolverException, InterruptedException {
        this.requireIntegers();
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.imgr.equal(this.x, (NumeralFormula.IntegerFormula)this.imgr.add(this.x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testSimple() throws SolverException, InterruptedException {
        this.requireIntegers();
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.add(this.x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)), (NumeralFormula.IntegerFormula)this.imgr.add((NumeralFormula.IntegerFormula)this.imgr.add(this.x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L)), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testBlah() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula z = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        BooleanFormula f = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)z), this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)y), this.imgr.equal(z, y)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testEquals() {
        this.requireIntegers();
        BooleanFormula f1 = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"))), this.a_at_x_eq_1);
        BooleanFormula f2 = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)((NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"))), this.a_at_x_eq_1);
        Truth.assertThat((Object)f1).isEqualTo((Object)f2);
    }

    @Test
    public void testQELight() throws InterruptedException {
        this.requireIntegers();
        TruthJUnit.assume().that((Comparable)((Object)this.solverToUse())).isEqualTo((Object)SolverContextFactory.Solvers.Z3);
        NumeralFormula.IntegerFormula y = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        BooleanFormula f1 = this.qmgr.exists(y, this.bmgr.and(this.imgr.equal(y, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L)), this.imgr.equal(this.x, (NumeralFormula.IntegerFormula)this.imgr.add(y, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L)))));
        BooleanFormula out = this.mgr.applyTactic(f1, Tactic.QE_LIGHT);
        Truth.assertThat((Object)out).isEqualTo((Object)this.imgr.equal(this.x, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(7L)));
    }

    @Test
    public void testIntrospectionForall() {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula forall = this.qmgr.forall((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
        final AtomicBoolean isQuantifier = new AtomicBoolean(false);
        final AtomicBoolean isForall = new AtomicBoolean(false);
        final AtomicInteger numBound = new AtomicInteger(0);
        this.mgr.visit(forall, new DefaultFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault(Formula f) {
                return null;
            }

            @Override
            public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
                isForall.set(quantifier == QuantifiedFormulaManager.Quantifier.FORALL);
                isQuantifier.set(true);
                numBound.set(boundVariables.size());
                return null;
            }
        });
    }

    @Test
    public void testIntrospectionExists() {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        BooleanFormula exists = this.qmgr.exists((List<? extends Formula>)ImmutableList.of((Object)this.x), this.a_at_x_eq_0);
        final AtomicBoolean isQuantifier = new AtomicBoolean(false);
        final AtomicBoolean isForall = new AtomicBoolean(false);
        final ArrayList boundVars = new ArrayList();
        this.mgr.visit(exists, new DefaultFormulaVisitor<Void>(){

            @Override
            protected Void visitDefault(Formula f) {
                return null;
            }

            @Override
            public Void visitQuantifier(BooleanFormula f, QuantifiedFormulaManager.Quantifier quantifier, List<Formula> boundVariables, BooleanFormula body) {
                Truth.assertThat((Boolean)isQuantifier.get()).isFalse();
                isForall.set(quantifier == QuantifiedFormulaManager.Quantifier.FORALL);
                isQuantifier.set(true);
                boundVars.addAll(boundVariables);
                return null;
            }
        });
        Truth.assertThat((Boolean)isQuantifier.get()).isTrue();
        Truth.assertThat((Boolean)isForall.get()).isFalse();
        TruthJUnit.assume().withMessage("Quantifier introspection in JavaSMT for Princess is currently not complete.").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        Truth.assertThat(boundVars).hasSize(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmpty() {
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        TruthJUnit.assume().withMessage("TODO: The JavaSMT code for Princess explicitly allows this.").that((Comparable)((Object)this.solverToUse())).isNotEqualTo((Object)SolverContextFactory.Solvers.PRINCESS);
        BooleanFormula quantified = this.qmgr.exists((List<? extends Formula>)ImmutableList.of(), this.bmgr.makeVariable("b"));
    }

    @Test
    public void checkQuantifierElimination() throws InterruptedException, SolverException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula xx = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x");
        NumeralFormula.IntegerFormula yy = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y");
        BooleanFormula f = this.qmgr.forall(xx, this.bmgr.or(this.imgr.lessThan(xx, (NumeralFormula.IntegerFormula)this.imgr.makeNumber(5L)), this.imgr.lessThan((NumeralFormula.IntegerFormula)this.imgr.makeNumber(7L), (NumeralFormula.IntegerFormula)this.imgr.add(xx, yy))));
        BooleanFormula qFreeF = this.qmgr.eliminateQuantifiers(f);
        this.assertThatFormula(qFreeF).isEquivalentTo(this.imgr.lessThan((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), yy));
    }

    @Test
    public void checkBVQuantifierElimination() throws InterruptedException, SolverException {
        this.requireBitvectors();
        TruthJUnit.assume().that((Comparable)((Object)this.solverUnderTest)).isEqualTo((Object)SolverContextFactory.Solvers.BOOLECTOR);
        int i = index.getFreshId();
        int width = 2;
        BitvectorFormula xx = this.bvmgr.makeVariable(width, "x" + i);
        BitvectorFormula yy = this.bvmgr.makeVariable(width, "y" + i);
        BooleanFormula f = this.qmgr.exists(yy, this.bvmgr.equal(this.bvmgr.multiply(xx, yy), this.bvmgr.makeBitvector(width, 1L)));
        BooleanFormula qFreeF = this.qmgr.eliminateQuantifiers(f);
        this.assertThatFormula(qFreeF).isEquivalentTo(this.bvmgr.equal(this.bvmgr.extract(xx, 0, 0, false), this.bvmgr.makeBitvector(1, 1L)));
    }
}

