/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.base.Throwables;
import com.google.common.truth.ExpectFailure;
import com.google.common.truth.SimpleSubjectBuilder;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.ProverEnvironmentSubject;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class ProverEnvironmentSubjectTest
extends SolverBasedTest0 {
    @Parameterized.Parameter
    public SolverContextFactory.Solvers solver;
    private BooleanFormula simpleFormula;
    private BooleanFormula contradiction;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void setupFormulas() {
        if (this.imgr != null) {
            this.simpleFormula = this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L));
            this.contradiction = this.bmgr.and(this.simpleFormula, this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeVariable("a"), (NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L)));
        } else {
            this.simpleFormula = this.bvmgr.equal(this.bvmgr.makeVariable(2, "a"), this.bvmgr.makeBitvector(2, 1L));
            this.contradiction = this.bmgr.and(this.simpleFormula, this.bvmgr.equal(this.bvmgr.makeVariable(2, "a"), this.bvmgr.makeBitvector(2, 2L)));
        }
    }

    @Test
    public void testIsSatisfiableYes() throws SolverException, InterruptedException {
        try (ProverEnvironment env = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            env.push(this.simpleFormula);
            this.assertThatEnvironment(env).isSatisfiable();
        }
    }

    @Test
    public void testIsSatisfiableNo() throws InterruptedException {
        this.requireUnsatCore();
        try (ProverEnvironment env = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS, SolverContext.ProverOptions.GENERATE_UNSAT_CORE);){
            env.push(this.contradiction);
            AssertionError failure = this.expectFailure(whenTesting -> ((ProverEnvironmentSubject)whenTesting.that((Object)env)).isSatisfiable());
            ExpectFailure.assertThat((AssertionError)failure).factValue("with unsat core").isNotEmpty();
        }
    }

    @Test
    public void testIsUnsatisfiableYes() throws SolverException, InterruptedException {
        try (ProverEnvironment env = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            env.push(this.contradiction);
            this.assertThatEnvironment(env).isUnsatisfiable();
        }
    }

    @Test
    public void testIsUnsatisfiableNo() throws InterruptedException {
        this.requireModel();
        try (ProverEnvironment env = this.context.newProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            env.push(this.simpleFormula);
            AssertionError failure = this.expectFailure(whenTesting -> ((ProverEnvironmentSubject)whenTesting.that((Object)env)).isUnsatisfiable());
            ExpectFailure.assertThat((AssertionError)failure).factValue("which has model").isNotEmpty();
        }
    }

    private AssertionError expectFailure(ExpectFailureCallback expectFailureCallback) {
        return ExpectFailure.expectFailureAbout(ProverEnvironmentSubject.proverEnvironments(), (ExpectFailure.SimpleSubjectBuilderCallback)expectFailureCallback);
    }

    private static interface ExpectFailureCallback
    extends ExpectFailure.SimpleSubjectBuilderCallback<ProverEnvironmentSubject, BasicProverEnvironment<?>> {
        public void invokeAssertionUnchecked(SimpleSubjectBuilder<ProverEnvironmentSubject, BasicProverEnvironment<?>> var1) throws Exception;

        default public void invokeAssertion(SimpleSubjectBuilder<ProverEnvironmentSubject, BasicProverEnvironment<?>> pWhenTesting) {
            try {
                this.invokeAssertionUnchecked(pWhenTesting);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

