/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class NumeralFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void distinctTest() throws SolverException, InterruptedException {
        this.requireIntegers();
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
        }
        this.assertThatFormula(this.imgr.distinct(symbols)).isSatisfiable();
    }

    @Test
    public void distinctTest2() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
            constraints.add(this.imgr.lessOrEquals(zero, symbol));
            constraints.add(this.imgr.lessOrEquals(symbol, four));
        }
        this.assertThatFormula(this.bmgr.and(this.imgr.distinct(symbols), this.bmgr.and(constraints))).isSatisfiable();
    }

    @Test
    public void distinctTest3() throws SolverException, InterruptedException {
        this.requireIntegers();
        NumeralFormula.IntegerFormula zero = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(0L);
        NumeralFormula.IntegerFormula four = (NumeralFormula.IntegerFormula)this.imgr.makeNumber(4L);
        ArrayList<NumeralFormula.IntegerFormula> symbols = new ArrayList<NumeralFormula.IntegerFormula>();
        ArrayList<BooleanFormula> constraints = new ArrayList<BooleanFormula>();
        for (int i = 0; i < 5; ++i) {
            NumeralFormula.IntegerFormula symbol = (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x" + i);
            symbols.add(symbol);
            constraints.add(this.imgr.lessOrEquals(zero, symbol));
            constraints.add(this.imgr.lessThan(symbol, four));
        }
        this.assertThatFormula(this.bmgr.and(this.imgr.distinct(symbols), this.bmgr.and(constraints))).isUnsatisfiable();
    }

    @Test(expected=Exception.class)
    public void failOnInvalidString() {
        this.requireIntegers();
        this.imgr.makeNumber("a");
        Assert.fail();
    }
}

