/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.NumeralFormulaManager;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractNumeralFormulaManager;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class NonLinearArithmeticTest<T extends NumeralFormula>
extends SolverBasedTest0 {
    static final ImmutableSet<SolverContextFactory.Solvers> SOLVER_WITHOUT_NONLINEAR_ARITHMETIC = ImmutableSet.of((Object)((Object)SolverContextFactory.Solvers.SMTINTERPOL), (Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)((Object)SolverContextFactory.Solvers.BOOLECTOR), (Object)((Object)SolverContextFactory.Solvers.CVC4));
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;
    @Parameterized.Parameter(value=1)
    public FormulaType<?> formulaType;
    private NumeralFormulaManager<T, T> nmgr;
    @Parameterized.Parameter(value=2)
    public AbstractNumeralFormulaManager.NonLinearArithmetic nonLinearArithmetic;

    @Parameterized.Parameters(name="{0} {1} {2}")
    public static Iterable<Object[]> getAllSolvers() {
        return (Iterable)Lists.cartesianProduct((List[])new List[]{Arrays.asList(SolverContextFactory.Solvers.values()), ImmutableList.of(FormulaType.IntegerType, FormulaType.RationalType), Arrays.asList(AbstractNumeralFormulaManager.NonLinearArithmetic.values())}).stream().map(e -> e.toArray()).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Before
    public void chooseNumeralFormulaManager() {
        if (this.formulaType.isIntegerType()) {
            this.requireIntegers();
            this.nmgr = this.imgr;
        } else if (this.formulaType.isRationalType()) {
            this.requireRationals();
            this.nmgr = this.rmgr;
        } else {
            throw new AssertionError();
        }
    }

    @Override
    protected ConfigurationBuilder createTestConfigBuilder() {
        return super.createTestConfigBuilder().setOption("solver.nonLinearArithmetic", this.nonLinearArithmetic.name());
    }

    private T handleExpectedException(Supplier<T> supplier) {
        try {
            return (T)((NumeralFormula)supplier.get());
        }
        catch (UnsupportedOperationException e) {
            if (this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.USE && SOLVER_WITHOUT_NONLINEAR_ARITHMETIC.contains((Object)this.solver)) {
                throw new AssumptionViolatedException("Expected UnsupportedOperationException was thrown correctly");
            }
            throw e;
        }
    }

    private void assertExpectedUnsatifiabilityForNonLinearArithmetic(BooleanFormula f) throws SolverException, InterruptedException {
        if (this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.USE || this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_FALLBACK && !SOLVER_WITHOUT_NONLINEAR_ARITHMETIC.contains((Object)this.solver)) {
            this.assertThatFormula(f).isUnsatisfiable();
        } else {
            this.assertThatFormula(f).isSatisfiable();
        }
    }

    @Test
    public void testLinearMultiplication() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(a, this.nmgr.multiply(this.nmgr.makeNumber(2L), this.nmgr.makeNumber(3L))), this.nmgr.equal(this.nmgr.makeNumber(30L), this.nmgr.multiply(a, this.nmgr.makeNumber(5L))), this.nmgr.equal(this.nmgr.makeNumber(30L), this.nmgr.multiply(this.nmgr.makeNumber(5L), a)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testLinearMultiplicationUnsatisfiable() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(a, this.nmgr.multiply(this.nmgr.makeNumber(2L), this.nmgr.makeNumber(3L))), this.bmgr.xor(this.nmgr.equal(this.nmgr.makeNumber(30L), this.nmgr.multiply(a, this.nmgr.makeNumber(5L))), this.nmgr.equal(this.nmgr.makeNumber(30L), this.nmgr.multiply(this.nmgr.makeNumber(5L), a))));
        this.assertThatFormula(f).isUnsatisfiable();
    }

    @Test
    public void testMultiplicationOfVariables() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        T b = this.nmgr.makeVariable("b");
        T c = this.nmgr.makeVariable("c");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(c, this.handleExpectedException(() -> this.nmgr.multiply(a, b))), this.nmgr.equal(c, this.nmgr.makeNumber(6L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testMultiplicationOfVariablesUnsatisfiable() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        T b = this.nmgr.makeVariable("b");
        T c = this.nmgr.makeVariable("c");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(this.handleExpectedException(() -> this.nmgr.multiply(a, b)), c), this.nmgr.equal(a, this.nmgr.makeNumber(3L)), this.nmgr.equal(b, this.nmgr.makeNumber(5L)), this.bmgr.not(this.nmgr.equal(c, this.nmgr.makeNumber(15L))));
        if (this.solver == SolverContextFactory.Solvers.MATHSAT5 && this.nonLinearArithmetic != AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_ALWAYS) {
            this.assertThatFormula(f).isUnsatisfiable();
        } else {
            this.assertExpectedUnsatifiabilityForNonLinearArithmetic(f);
        }
    }

    @Test
    public void testDivisionByConstant() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(this.nmgr.makeNumber(6L), a), this.nmgr.equal(this.nmgr.divide(a, this.nmgr.makeNumber(3L)), this.nmgr.makeNumber(2L)), this.nmgr.equal(this.nmgr.divide(a, this.nmgr.makeNumber(2L)), this.nmgr.makeNumber(3L)));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testDivisionByConstantUnsatisfiable() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(a, this.nmgr.makeNumber(6L)), this.bmgr.xor(this.nmgr.equal(this.nmgr.divide(a, this.nmgr.makeNumber(3L)), this.nmgr.makeNumber(2L)), this.nmgr.equal(this.nmgr.divide(a, this.nmgr.makeNumber(2L)), this.nmgr.makeNumber(3L))));
        if (this.formulaType.equals(FormulaType.IntegerType) && this.nonLinearArithmetic == AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_ALWAYS) {
            this.assertThatFormula(f).isSatisfiable();
        } else {
            this.assertThatFormula(f).isUnsatisfiable();
        }
    }

    @Test
    public void testDivision() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.nmgr.equal(a, this.nmgr.makeNumber(2L)), this.nmgr.equal(this.nmgr.makeNumber(3L), this.handleExpectedException(() -> this.nmgr.divide(this.nmgr.makeNumber(6L), a))));
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testDivisionUnsatisfiable() throws SolverException, InterruptedException {
        T a = this.nmgr.makeVariable("a");
        BooleanFormula f = this.bmgr.and(this.bmgr.not(this.nmgr.equal(a, this.nmgr.makeNumber(2L))), this.bmgr.not(this.nmgr.equal(a, this.nmgr.makeNumber(0L))), this.nmgr.equal(this.nmgr.makeNumber(3L), this.handleExpectedException(() -> this.nmgr.divide(this.nmgr.makeNumber(6L), a))));
        if (ImmutableSet.of((Object)((Object)SolverContextFactory.Solvers.MATHSAT5), (Object)((Object)SolverContextFactory.Solvers.CVC4)).contains((Object)this.solver) && this.nonLinearArithmetic != AbstractNumeralFormulaManager.NonLinearArithmetic.APPROXIMATE_ALWAYS) {
            this.assertThatFormula(f).isUnsatisfiable();
        } else {
            this.assertExpectedUnsatifiabilityForNonLinearArithmetic(f);
        }
    }
}

