/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.AssumptionViolatedException;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.test.SolverBasedTest0;

@RunWith(value=Parameterized.class)
public class BooleanFormulaManagerTest
extends SolverBasedTest0 {
    @Parameterized.Parameter(value=0)
    public SolverContextFactory.Solvers solver;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllSolvers() {
        return SolverContextFactory.Solvers.values();
    }

    @Override
    protected SolverContextFactory.Solvers solverToUse() {
        return this.solver;
    }

    @Test
    public void testVariableNamedTrue() throws SolverException, InterruptedException {
        BooleanFormula var;
        try {
            var = this.bmgr.makeVariable("true");
        }
        catch (RuntimeException e) {
            throw new AssumptionViolatedException("unsupported variable name", (Throwable)e);
        }
        BooleanFormula f = this.bmgr.equivalence(var, this.bmgr.makeFalse());
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testVariableNamedFalse() throws SolverException, InterruptedException {
        BooleanFormula var;
        try {
            var = this.bmgr.makeVariable("false");
        }
        catch (RuntimeException e) {
            throw new AssumptionViolatedException("unsupported variable name", (Throwable)e);
        }
        BooleanFormula f = this.bmgr.equivalence(var, this.bmgr.makeTrue());
        this.assertThatFormula(f).isSatisfiable();
    }

    @Test
    public void testConjunctionCollector() {
        ImmutableList terms = ImmutableList.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeTrue(), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"));
        this.assertThatFormula(terms.stream().collect(this.bmgr.toConjunction())).isEqualTo(this.bmgr.and((Collection<BooleanFormula>)terms));
    }

    @Test
    public void testDisjunctionCollector() {
        ImmutableList terms = ImmutableList.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeFalse(), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"));
        this.assertThatFormula(terms.stream().collect(this.bmgr.toDisjunction())).isEqualTo(this.bmgr.or((Collection<BooleanFormula>)terms));
    }

    @Test
    public void testConjunctionArgsExtractionEmpty() throws SolverException, InterruptedException {
        this.requireVisitor();
        BooleanFormula input = this.bmgr.makeBoolean(true);
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, false)).isEmpty();
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testConjunctionArgsExtraction() throws SolverException, InterruptedException {
        this.requireIntegers();
        BooleanFormula input = this.bmgr.and(this.bmgr.makeVariable("a"), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, false)).isEqualTo((Object)ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x"))));
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testConjunctionArgsExtractionRecursive() throws SolverException, InterruptedException {
        ImmutableSet comparisonSet;
        BooleanFormula input;
        if (this.imgr != null) {
            input = this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(true), this.bmgr.and(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.and(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), this.bmgr.makeVariable("d"), this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))});
        } else {
            input = this.bmgr.and(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(true), this.bmgr.and(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.and(this.bvmgr.equal(this.bvmgr.makeBitvector(2, 2L), this.bvmgr.makeVariable(2, "y")), this.bmgr.makeVariable("d"), this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")), (Object)this.bvmgr.equal(this.bvmgr.makeBitvector(2, 2L), this.bvmgr.makeVariable(2, "y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.or(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))});
        }
        this.requireVisitor();
        Truth.assertThat(this.bmgr.toConjunctionArgs(input, true)).isEqualTo((Object)comparisonSet);
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, true))).isEquivalentTo(input);
        this.assertThatFormula(this.bmgr.and(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtractionEmpty() throws SolverException, InterruptedException {
        this.requireVisitor();
        BooleanFormula input = this.bmgr.makeBoolean(false);
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, false)).isEmpty();
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtraction() throws SolverException, InterruptedException {
        ImmutableSet comparisonSet;
        BooleanFormula input;
        if (this.imgr != null) {
            input = this.bmgr.or(this.bmgr.makeVariable("a"), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
        } else {
            input = this.bmgr.or(this.bmgr.makeVariable("a"), this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")));
        }
        this.requireVisitor();
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, false)).isEqualTo((Object)comparisonSet);
        this.assertThatFormula(this.bmgr.or(this.bmgr.toConjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void testDisjunctionArgsExtractionRecursive() throws SolverException, InterruptedException {
        ImmutableSet comparisonSet;
        BooleanFormula input;
        if (this.imgr != null) {
            input = this.bmgr.or(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(false), this.bmgr.or(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.or(this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), this.bmgr.makeVariable("d"), this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(1L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("x")), (Object)this.imgr.equal((NumeralFormula.IntegerFormula)this.imgr.makeNumber(2L), (NumeralFormula.IntegerFormula)this.imgr.makeVariable("y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))});
        } else {
            input = this.bmgr.or(this.bmgr.makeVariable("a"), this.bmgr.makeBoolean(false), this.bmgr.or(this.bmgr.makeVariable("b"), this.bmgr.makeVariable("c"), this.bmgr.or(this.bvmgr.equal(this.bvmgr.makeBitvector(2, 2L), this.bvmgr.makeVariable(2, "y")), this.bmgr.makeVariable("d"), this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f")))), this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")));
            comparisonSet = ImmutableSet.of((Object)this.bmgr.makeVariable("a"), (Object)this.bmgr.makeVariable("b"), (Object)this.bmgr.makeVariable("c"), (Object)this.bvmgr.equal(this.bvmgr.makeBitvector(2, 1L), this.bvmgr.makeVariable(2, "x")), (Object)this.bvmgr.equal(this.bvmgr.makeBitvector(2, 2L), this.bvmgr.makeVariable(2, "y")), (Object)this.bmgr.makeVariable("d"), (Object[])new BooleanFormula[]{this.bmgr.and(this.bmgr.makeVariable("e"), this.bmgr.makeVariable("f"))});
        }
        this.requireVisitor();
        Truth.assertThat(this.bmgr.toDisjunctionArgs(input, true)).isEqualTo((Object)comparisonSet);
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, true))).isEquivalentTo(input);
        this.assertThatFormula(this.bmgr.or(this.bmgr.toDisjunctionArgs(input, false))).isEquivalentTo(input);
    }

    @Test
    public void simplificationTest() {
        BooleanFormula tru = this.bmgr.makeBoolean(true);
        BooleanFormula fals = this.bmgr.makeBoolean(false);
        BooleanFormula x = this.bmgr.makeVariable("x");
        BooleanFormula y = this.bmgr.makeVariable("y");
        Truth.assertThat((Object)this.bmgr.and(tru)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.and(fals)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.and(x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.and(new BooleanFormula[0])).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.and(tru, tru)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.and(tru, x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.and(fals, x)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.and(x, x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.and(tru, tru, tru)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.and(fals, fals, fals)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.and(fals, x, x)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.and(tru, x, tru)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.and(tru, tru, x, fals, y, tru, x, y)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.or(tru)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.or(fals)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.or(x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.or(new BooleanFormula[0])).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.or(tru, tru)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.or(tru, x)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.or(fals, x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.or(x, x)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.or(fals, fals, fals)).isEqualTo((Object)fals);
        Truth.assertThat((Object)this.bmgr.or(tru, x, x)).isEqualTo((Object)tru);
        Truth.assertThat((Object)this.bmgr.or(fals, x, fals)).isEqualTo((Object)x);
        Truth.assertThat((Object)this.bmgr.or(fals, fals, x, tru, y, fals, x, y)).isEqualTo((Object)tru);
    }
}

