/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.princess;

import ap.basetypes.IdealInt;
import ap.parser.IAtom;
import ap.parser.IBinFormula;
import ap.parser.IBinJunctor;
import ap.parser.IBoolLit;
import ap.parser.IConstant;
import ap.parser.IEpsilon;
import ap.parser.IExpression;
import ap.parser.IFormula;
import ap.parser.IFormulaITE;
import ap.parser.IFunApp;
import ap.parser.IFunction;
import ap.parser.IIntFormula;
import ap.parser.IIntLit;
import ap.parser.IIntRelation;
import ap.parser.INot;
import ap.parser.IPlus;
import ap.parser.IQuantified;
import ap.parser.ITerm;
import ap.parser.ITermITE;
import ap.parser.ITimes;
import ap.parser.IVariable;
import ap.terfor.conjunctions.Quantifier;
import ap.terfor.preds.Predicate;
import ap.theories.SimpleArray;
import ap.theories.bitvectors.ModuloArithmetic;
import ap.theories.nia.GroebnerMultiplication$;
import ap.types.Sort;
import ap.types.Sort$;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.QuantifiedFormulaManager;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.princess.PrincessEnvironment;
import org.sosy_lab.java_smt.solvers.princess.PrincessFunctionDeclaration;
import scala.Enumeration;
import scala.Option;
import scala.Tuple2;

class PrincessFormulaCreator
extends FormulaCreator<IExpression, Sort, PrincessEnvironment, PrincessFunctionDeclaration> {
    private static final Map<IFunction, FunctionDeclarationKind> theoryFunctionKind = new HashMap<IFunction, FunctionDeclarationKind>();
    private static final Map<Predicate, FunctionDeclarationKind> theoryPredKind = new HashMap<Predicate, FunctionDeclarationKind>();

    PrincessFormulaCreator(PrincessEnvironment pEnv) {
        super(pEnv, PrincessEnvironment.BOOL_SORT, PrincessEnvironment.INTEGER_SORT, null);
    }

    @Override
    public Object convertValue(IExpression value) {
        if (value instanceof IBoolLit) {
            return ((IBoolLit)value).value();
        }
        if (value instanceof IIntLit) {
            return ((IIntLit)value).value().bigIntValue();
        }
        if (value instanceof IFunApp) {
            IFunApp fun = (IFunApp)value;
            switch (fun.fun().name()) {
                case "false": {
                    assert (fun.fun().arity() == 0);
                    return false;
                }
                case "mod_cast": {
                    return ((IIntLit)fun.apply(2)).value().bigIntValue();
                }
            }
        }
        throw new IllegalArgumentException("unhandled model value " + value + " of type " + value.getClass());
    }

    @Override
    public FormulaType<?> getFormulaType(IExpression pFormula) {
        if (pFormula instanceof IFormula) {
            return FormulaType.BooleanType;
        }
        if (pFormula instanceof ITerm) {
            Sort sort = Sort$.MODULE$.sortOf((ITerm)pFormula);
            if (sort == PrincessEnvironment.BOOL_SORT) {
                return FormulaType.BooleanType;
            }
            if (sort == PrincessEnvironment.INTEGER_SORT) {
                return FormulaType.IntegerType;
            }
            if (sort instanceof SimpleArray.ArraySort) {
                return new FormulaType.ArrayFormulaType<NumeralFormula.IntegerFormula, NumeralFormula.IntegerFormula>(FormulaType.IntegerType, FormulaType.IntegerType);
            }
            Option<Object> bitWidth = PrincessFormulaCreator.getBitWidth(sort);
            if (bitWidth.isDefined()) {
                return FormulaType.getBitvectorTypeWithSize((Integer)bitWidth.get());
            }
        }
        throw new IllegalArgumentException(String.format("Unknown formula type '%s' for formula '%s'.", pFormula.getClass(), pFormula));
    }

    static Option<Object> getBitWidth(Sort sort) {
        Option bitWidth = ModuloArithmetic.UnsignedBVSort$.MODULE$.unapply(sort);
        if (!bitWidth.isDefined()) {
            bitWidth = ModuloArithmetic.SignedBVSort$.MODULE$.unapply(sort);
        }
        return bitWidth;
    }

    @Override
    public IExpression makeVariable(Sort type, String varName) {
        return ((PrincessEnvironment)this.getEnv()).makeVariable(type, varName);
    }

    @Override
    public Sort getBitvectorType(int pBitwidth) {
        return ModuloArithmetic.UnsignedBVSort$.MODULE$.apply(pBitwidth);
    }

    @Override
    public Sort getFloatingPointType(FormulaType.FloatingPointType type) {
        throw new UnsupportedOperationException("FloatingPoint theory is not supported by Princess");
    }

    @Override
    public Sort getArrayType(Sort pIndexType, Sort pElementType) {
        return SimpleArray.ArraySort$.MODULE$.apply(1);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        if (pFormula instanceof BitvectorFormula) {
            ITerm input = (ITerm)this.extractInfo(pFormula);
            Sort sort = Sort$.MODULE$.sortOf(input);
            Option<Object> bitWidth = PrincessFormulaCreator.getBitWidth(sort);
            Preconditions.checkArgument((boolean)bitWidth.isDefined(), (Object)("BitvectorFormula with actual type " + sort + ": " + pFormula));
            return FormulaType.getBitvectorTypeWithSize((Integer)bitWidth.get());
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return new FormulaType.ArrayFormulaType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    private String getName(IExpression input) {
        if (input instanceof IAtom || input instanceof IConstant) {
            return input.toString();
        }
        if (input instanceof IBinFormula) {
            return ((IBinFormula)input).j().toString();
        }
        if (input instanceof IFormulaITE || input instanceof ITermITE) {
            return "ite";
        }
        if (input instanceof IIntFormula) {
            return ((IIntFormula)input).rel().toString();
        }
        if (input instanceof INot) {
            return "not";
        }
        if (input instanceof IFunApp) {
            return ((IFunApp)input).fun().name();
        }
        if (input instanceof IPlus) {
            return "+";
        }
        if (input instanceof ITimes) {
            return "*";
        }
        if (input instanceof IEpsilon) {
            return "eps";
        }
        throw new AssertionError((Object)("Unhandled type " + input.getClass()));
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula f, IExpression input) {
        if (input instanceof IIntLit) {
            IdealInt value = ((IIntLit)input).value();
            return visitor.visitConstant(f, value.bigIntValue());
        }
        if (input instanceof IBoolLit) {
            IBoolLit literal = (IBoolLit)input;
            return visitor.visitConstant(f, literal.value());
        }
        if (input instanceof IQuantified) {
            BooleanFormula body = this.encapsulateBoolean(((IQuantified)input).subformula());
            return visitor.visitQuantifier((BooleanFormula)f, ((IQuantified)input).quan().equals(Quantifier.apply((boolean)true)) ? QuantifiedFormulaManager.Quantifier.FORALL : QuantifiedFormulaManager.Quantifier.EXISTS, new ArrayList<Formula>(), body);
        }
        if (input instanceof IVariable) {
            return visitor.visitBoundVariable(f, ((IVariable)input).index());
        }
        if (input instanceof IAtom && ((IAtom)input).args().isEmpty() || input instanceof IConstant) {
            return visitor.visitFreeVariable(f, input.toString());
        }
        if (input instanceof ITimes) {
            assert (input.length() == 1);
            ITimes multiplication = (ITimes)input;
            IIntLit coeff = new IIntLit(multiplication.coeff());
            FormulaType<NumeralFormula.IntegerFormula> coeffType = FormulaType.IntegerType;
            ITerm factor = multiplication.subterm();
            FormulaType<ITerm> factorType = this.getFormulaType((Formula)factor);
            return visitor.visitFunction(f, (List<Formula>)ImmutableList.of((Object)this.encapsulate(coeffType, coeff), (Object)this.encapsulate(factorType, factor)), FunctionDeclarationImpl.of(this.getName(input), this.getDeclarationKind(input), ImmutableList.of(coeffType, factorType), this.getFormulaType(f), PrincessFunctionDeclaration.PrincessMultiplyDeclaration.INSTANCE));
        }
        FunctionDeclarationKind kind = this.getDeclarationKind(input);
        if (kind == FunctionDeclarationKind.EQ) {
            Option maybeArgs = IExpression.Eq$.MODULE$.unapply((IFormula)input);
            assert (maybeArgs.isDefined());
            ITerm left = (ITerm)((Tuple2)maybeArgs.get())._1;
            ITerm right = (ITerm)((Tuple2)maybeArgs.get())._2;
            ImmutableList.Builder args = ImmutableList.builder();
            ImmutableList.Builder argTypes = ImmutableList.builder();
            FormulaType<ITerm> argumentTypeLeft = this.getFormulaType((Formula)left);
            args.add((Object)this.encapsulate(argumentTypeLeft, left));
            argTypes.add(argumentTypeLeft);
            FormulaType<ITerm> argumentTypeRight = this.getFormulaType((Formula)right);
            args.add((Object)this.encapsulate(argumentTypeRight, right));
            argTypes.add(argumentTypeRight);
            return visitor.visitFunction(f, (List<Formula>)args.build(), FunctionDeclarationImpl.of(this.getName(input), FunctionDeclarationKind.EQ, argTypes.build(), this.getFormulaType(f), PrincessFunctionDeclaration.PrincessEquationDeclaration.INSTANCE));
        }
        if (kind == FunctionDeclarationKind.UF && input instanceof IIntFormula) {
            assert (((IIntFormula)input).rel().equals((Object)IIntRelation.EqZero()));
            return this.visit(visitor, f, (IExpression)((IIntFormula)input).t());
        }
        ImmutableList.Builder args = ImmutableList.builder();
        ImmutableList.Builder argTypes = ImmutableList.builder();
        int arity = input.length();
        for (int i = 0; i < arity; ++i) {
            IExpression arg = input.apply(i);
            FormulaType<IExpression> argumentType = this.getFormulaType((Formula)arg);
            args.add((Object)this.encapsulate(argumentType, arg));
            argTypes.add(argumentType);
        }
        PrincessFunctionDeclaration solverDeclaration = input instanceof IFunApp ? (kind == FunctionDeclarationKind.UF ? new PrincessFunctionDeclaration.PrincessIFunctionDeclaration(((IFunApp)input).fun()) : (kind == FunctionDeclarationKind.MUL ? PrincessFunctionDeclaration.PrincessMultiplyDeclaration.INSTANCE : new PrincessFunctionDeclaration.PrincessByExampleDeclaration(input))) : new PrincessFunctionDeclaration.PrincessByExampleDeclaration(input);
        return visitor.visitFunction(f, (List<Formula>)args.build(), FunctionDeclarationImpl.of(this.getName(input), kind, argTypes.build(), this.getFormulaType(f), solverDeclaration));
    }

    private FunctionDeclarationKind getDeclarationKind(IExpression input) {
        assert (!(input instanceof IAtom && ((IAtom)input).args().isEmpty() || input instanceof IConstant)) : "Variables should be handled somewhere else";
        if (input instanceof IFormulaITE || input instanceof ITermITE) {
            return FunctionDeclarationKind.ITE;
        }
        if (input instanceof IFunApp) {
            IFunction fun = ((IFunApp)input).fun();
            FunctionDeclarationKind theoryKind = theoryFunctionKind.get(fun);
            if (theoryKind != null) {
                return theoryKind;
            }
            if (SimpleArray.Select$.MODULE$.unapply(fun)) {
                return FunctionDeclarationKind.SELECT;
            }
            if (SimpleArray.Store$.MODULE$.unapply(fun)) {
                return FunctionDeclarationKind.STORE;
            }
            return FunctionDeclarationKind.UF;
        }
        if (input instanceof IAtom) {
            Predicate pred = ((IAtom)input).pred();
            FunctionDeclarationKind theoryKind = theoryPredKind.get(pred);
            if (theoryKind != null) {
                return theoryKind;
            }
            return FunctionDeclarationKind.UF;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.And())) {
            return FunctionDeclarationKind.AND;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.Or())) {
            return FunctionDeclarationKind.OR;
        }
        if (input instanceof INot) {
            return FunctionDeclarationKind.NOT;
        }
        if (PrincessFormulaCreator.isBinaryFunction(input, IBinJunctor.Eqv())) {
            return FunctionDeclarationKind.IFF;
        }
        if (input instanceof ITimes) {
            return FunctionDeclarationKind.MUL;
        }
        if (input instanceof IPlus) {
            return FunctionDeclarationKind.ADD;
        }
        if (input instanceof IIntFormula) {
            IIntFormula f = (IIntFormula)input;
            if (f.rel().equals((Object)IIntRelation.EqZero())) {
                Sort sort = Sort$.MODULE$.sortOf(((IIntFormula)input).t());
                if (sort == PrincessEnvironment.BOOL_SORT) {
                    return FunctionDeclarationKind.UF;
                }
                if (sort == PrincessEnvironment.INTEGER_SORT) {
                    return FunctionDeclarationKind.EQ_ZERO;
                }
                return FunctionDeclarationKind.EQ;
            }
            if (f.rel().equals((Object)IIntRelation.GeqZero())) {
                return FunctionDeclarationKind.GTE_ZERO;
            }
            throw new AssertionError((Object)"Unhandled value for integer relation");
        }
        return FunctionDeclarationKind.OTHER;
    }

    private static boolean isBinaryFunction(IExpression t, Enumeration.Value val) {
        return t instanceof IBinFormula && val.equals((Object)((IBinFormula)t).j());
    }

    @Override
    public PrincessFunctionDeclaration declareUFImpl(String pName, Sort pReturnType, List<Sort> args) {
        return new PrincessFunctionDeclaration.PrincessIFunctionDeclaration(((PrincessEnvironment)this.environment).declareFun(pName, pReturnType, args));
    }

    @Override
    public IExpression callFunctionImpl(PrincessFunctionDeclaration declaration, List<IExpression> args) {
        return declaration.makeApp((PrincessEnvironment)this.environment, args);
    }

    @Override
    protected PrincessFunctionDeclaration getBooleanVarDeclarationImpl(IExpression pIExpression) {
        return new PrincessFunctionDeclaration.PrincessByExampleDeclaration(pIExpression);
    }

    static {
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_concat(), FunctionDeclarationKind.BV_CONCAT);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_extract(), FunctionDeclarationKind.BV_EXTRACT);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_not(), FunctionDeclarationKind.BV_NOT);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_neg(), FunctionDeclarationKind.BV_NEG);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_and(), FunctionDeclarationKind.BV_AND);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_or(), FunctionDeclarationKind.BV_OR);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_add(), FunctionDeclarationKind.BV_ADD);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_sub(), FunctionDeclarationKind.BV_SUB);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_mul(), FunctionDeclarationKind.BV_MUL);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_udiv(), FunctionDeclarationKind.BV_UDIV);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_sdiv(), FunctionDeclarationKind.BV_SDIV);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_urem(), FunctionDeclarationKind.BV_UREM);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_srem(), FunctionDeclarationKind.BV_SREM);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_shl(), FunctionDeclarationKind.BV_SHL);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_lshr(), FunctionDeclarationKind.BV_LSHR);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_ashr(), FunctionDeclarationKind.BV_ASHR);
        theoryFunctionKind.put((IFunction)ModuloArithmetic.bv_xor(), FunctionDeclarationKind.BV_XOR);
        theoryPredKind.put(ModuloArithmetic.bv_ult(), FunctionDeclarationKind.BV_ULT);
        theoryPredKind.put(ModuloArithmetic.bv_ule(), FunctionDeclarationKind.BV_ULE);
        theoryPredKind.put(ModuloArithmetic.bv_slt(), FunctionDeclarationKind.BV_SLT);
        theoryPredKind.put(ModuloArithmetic.bv_sle(), FunctionDeclarationKind.BV_SLE);
        theoryFunctionKind.put(GroebnerMultiplication$.MODULE$.mul(), FunctionDeclarationKind.MUL);
    }
}

