/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.mathsat5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.rationals.Rational;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.FunctionDeclarationKind;
import org.sosy_lab.java_smt.api.visitors.FormulaVisitor;
import org.sosy_lab.java_smt.basicimpl.FormulaCreator;
import org.sosy_lab.java_smt.basicimpl.FunctionDeclarationImpl;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5Formula;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5FormulaManager;
import org.sosy_lab.java_smt.solvers.mathsat5.Mathsat5NativeApi;

class Mathsat5FormulaCreator
extends FormulaCreator<Long, Long, Long, Long> {
    private static final Pattern FLOATING_POINT_PATTERN = Pattern.compile("^(\\d+)_(\\d+)_(\\d+)$");
    private static final Pattern BITVECTOR_PATTERN = Pattern.compile("^(\\d+)_(\\d+)$");

    Mathsat5FormulaCreator(Long msatEnv) {
        super(msatEnv, Mathsat5NativeApi.msat_get_bool_type(msatEnv), Mathsat5NativeApi.msat_get_integer_type(msatEnv), Mathsat5NativeApi.msat_get_rational_type(msatEnv));
    }

    @Override
    public Long makeVariable(Long type, String varName) {
        long funcDecl = Mathsat5NativeApi.msat_declare_function((Long)this.getEnv(), varName, type);
        return Mathsat5NativeApi.msat_make_constant((Long)this.getEnv(), funcDecl);
    }

    @Override
    public Long extractInfo(Formula pT) {
        return Mathsat5FormulaManager.getMsatTerm(pT);
    }

    @Override
    public <T extends Formula> FormulaType<T> getFormulaType(T pFormula) {
        long env = (Long)this.getEnv();
        if (pFormula instanceof BitvectorFormula) {
            long type = Mathsat5NativeApi.msat_term_get_type(this.extractInfo(pFormula));
            Preconditions.checkArgument((boolean)Mathsat5NativeApi.msat_is_bv_type(env, type), (Object)("BitvectorFormula with actual type " + Mathsat5NativeApi.msat_type_repr(type) + ": " + pFormula));
            return FormulaType.getBitvectorTypeWithSize(Mathsat5NativeApi.msat_get_bv_type_size(env, type));
        }
        if (pFormula instanceof FloatingPointFormula) {
            long type = Mathsat5NativeApi.msat_term_get_type(this.extractInfo(pFormula));
            Preconditions.checkArgument((boolean)Mathsat5NativeApi.msat_is_fp_type(env, type), (Object)("FloatingPointFormula with actual type " + Mathsat5NativeApi.msat_type_repr(type) + ": " + pFormula));
            return FormulaType.getFloatingPointType(Mathsat5NativeApi.msat_get_fp_type_exp_width(env, type), Mathsat5NativeApi.msat_get_fp_type_mant_width(env, type));
        }
        if (pFormula instanceof ArrayFormula) {
            FormulaType arrayIndexType = this.getArrayFormulaIndexType((ArrayFormula)pFormula);
            FormulaType arrayElementType = this.getArrayFormulaElementType((ArrayFormula)pFormula);
            return FormulaType.getArrayType(arrayIndexType, arrayElementType);
        }
        return super.getFormulaType(pFormula);
    }

    @Override
    public FormulaType<?> getFormulaType(Long pFormula) {
        long type = Mathsat5NativeApi.msat_term_get_type(pFormula);
        return this.getFormulaTypeFromTermType(type);
    }

    private FormulaType<?> getFormulaTypeFromTermType(Long type) {
        long env = (Long)this.getEnv();
        if (Mathsat5NativeApi.msat_is_bool_type(env, type)) {
            return FormulaType.BooleanType;
        }
        if (Mathsat5NativeApi.msat_is_integer_type(env, type)) {
            return FormulaType.IntegerType;
        }
        if (Mathsat5NativeApi.msat_is_rational_type(env, type)) {
            return FormulaType.RationalType;
        }
        if (Mathsat5NativeApi.msat_is_bv_type(env, type)) {
            return FormulaType.getBitvectorTypeWithSize(Mathsat5NativeApi.msat_get_bv_type_size(env, type));
        }
        if (Mathsat5NativeApi.msat_is_fp_type(env, type)) {
            return FormulaType.getFloatingPointType(Mathsat5NativeApi.msat_get_fp_type_exp_width(env, type), Mathsat5NativeApi.msat_get_fp_type_mant_width(env, type));
        }
        if (Mathsat5NativeApi.msat_is_fp_roundingmode_type(env, type)) {
            return FormulaType.FloatingPointRoundingModeType;
        }
        if (Mathsat5NativeApi.msat_is_array_type(env, type)) {
            long indexType = Mathsat5NativeApi.msat_get_array_index_type(env, type);
            long elementType = Mathsat5NativeApi.msat_get_array_element_type(env, type);
            return FormulaType.getArrayType(this.getFormulaTypeFromTermType(indexType), this.getFormulaTypeFromTermType(elementType));
        }
        throw new IllegalArgumentException("Unknown formula type " + Mathsat5NativeApi.msat_type_repr(type));
    }

    @Override
    public Long getBitvectorType(int pBitwidth) {
        return Mathsat5NativeApi.msat_get_bv_type((Long)this.getEnv(), pBitwidth);
    }

    @Override
    public Long getFloatingPointType(FormulaType.FloatingPointType pType) {
        return Mathsat5NativeApi.msat_get_fp_type((Long)this.getEnv(), pType.getExponentSize(), pType.getMantissaSize());
    }

    @Override
    public <T extends Formula> T encapsulate(FormulaType<T> pType, Long pTerm) {
        assert (pType.equals(this.getFormulaType(pTerm)) || pType.equals(FormulaType.RationalType) && this.getFormulaType(pTerm).equals(FormulaType.IntegerType)) : String.format("Trying to encapsulate formula of type %s as %s", this.getFormulaType(pTerm), pType);
        if (pType.isBooleanType()) {
            return (T)new Mathsat5Formula.Mathsat5BooleanFormula(pTerm);
        }
        if (pType.isIntegerType()) {
            return (T)new Mathsat5Formula.Mathsat5IntegerFormula(pTerm);
        }
        if (pType.isRationalType()) {
            return (T)new Mathsat5Formula.Mathsat5RationalFormula(pTerm);
        }
        if (pType.isArrayType()) {
            FormulaType.ArrayFormulaType arrFt = (FormulaType.ArrayFormulaType)pType;
            return (T)new Mathsat5Formula.Mathsat5ArrayFormula(pTerm, arrFt.getIndexType(), arrFt.getElementType());
        }
        if (pType.isBitvectorType()) {
            return (T)new Mathsat5Formula.Mathsat5BitvectorFormula(pTerm);
        }
        if (pType.isFloatingPointType()) {
            return (T)new Mathsat5Formula.Mathsat5FloatingPointFormula(pTerm);
        }
        if (pType.isFloatingPointRoundingModeType()) {
            return (T)new Mathsat5Formula.Mathsat5FloatingPointRoundingModeFormula(pTerm);
        }
        throw new IllegalArgumentException("Cannot create formulas of type " + pType + " in MathSAT");
    }

    @Override
    public BooleanFormula encapsulateBoolean(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBooleanType());
        return new Mathsat5Formula.Mathsat5BooleanFormula(pTerm);
    }

    @Override
    public BitvectorFormula encapsulateBitvector(Long pTerm) {
        assert (this.getFormulaType(pTerm).isBitvectorType());
        return new Mathsat5Formula.Mathsat5BitvectorFormula(pTerm);
    }

    @Override
    protected FloatingPointFormula encapsulateFloatingPoint(Long pTerm) {
        assert (this.getFormulaType(pTerm).isFloatingPointType());
        return new Mathsat5Formula.Mathsat5FloatingPointFormula(pTerm);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> ArrayFormula<TI, TE> encapsulateArray(Long pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        assert (this.getFormulaType(pTerm).equals(FormulaType.getArrayType(pIndexType, pElementType)));
        return new Mathsat5Formula.Mathsat5ArrayFormula<TI, TE>(pTerm, pIndexType, pElementType);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TE> getArrayFormulaElementType(ArrayFormula<TI, TE> pArray) {
        return ((Mathsat5Formula.Mathsat5ArrayFormula)pArray).getElementType();
    }

    @Override
    protected <TI extends Formula, TE extends Formula> FormulaType<TI> getArrayFormulaIndexType(ArrayFormula<TI, TE> pArray) {
        return ((Mathsat5Formula.Mathsat5ArrayFormula)pArray).getIndexType();
    }

    @Override
    public Long getArrayType(Long pIndexType, Long pElementType) {
        return Mathsat5NativeApi.msat_get_array_type((Long)this.getEnv(), pIndexType, pElementType);
    }

    @Override
    public <R> R visit(FormulaVisitor<R> visitor, Formula formula, Long f) {
        int arity = Mathsat5NativeApi.msat_term_arity(f);
        if (Mathsat5NativeApi.msat_term_is_number((Long)this.environment, f)) {
            return visitor.visitConstant(formula, this.convertValue(f, f));
        }
        if (Mathsat5NativeApi.msat_term_is_true((Long)this.environment, f)) {
            return visitor.visitConstant(formula, true);
        }
        if (Mathsat5NativeApi.msat_term_is_false((Long)this.environment, f)) {
            return visitor.visitConstant(formula, false);
        }
        if (Mathsat5NativeApi.msat_term_is_constant((Long)this.environment, f)) {
            return visitor.visitFreeVariable(formula, Mathsat5NativeApi.msat_term_repr(f));
        }
        String name = Mathsat5NativeApi.msat_decl_get_name(Mathsat5NativeApi.msat_term_get_decl(f));
        if (arity == 0 && name.startsWith("'")) {
            return visitor.visitFreeVariable(formula, name);
        }
        ImmutableList.Builder args = ImmutableList.builder();
        ImmutableList.Builder argTypes = ImmutableList.builder();
        for (int i = 0; i < arity; ++i) {
            long arg = Mathsat5NativeApi.msat_term_get_arg(f, i);
            FormulaType<?> argumentType = this.getFormulaType(arg);
            args.add(this.encapsulate(argumentType, arg));
            argTypes.add(argumentType);
        }
        return visitor.visitFunction(formula, (List<Formula>)args.build(), FunctionDeclarationImpl.of(name, this.getDeclarationKind(f), argTypes.build(), this.getFormulaType(f), Mathsat5NativeApi.msat_term_get_decl(f)));
    }

    String getName(long term) {
        if (Mathsat5NativeApi.msat_term_is_uf((Long)this.environment, term)) {
            return Mathsat5NativeApi.msat_decl_get_name(Mathsat5NativeApi.msat_term_get_decl(term));
        }
        return Mathsat5NativeApi.msat_term_repr(term);
    }

    private FunctionDeclarationKind getDeclarationKind(long pF) {
        if (Mathsat5NativeApi.msat_term_is_uf((Long)this.environment, pF)) {
            return FunctionDeclarationKind.UF;
        }
        assert (!Mathsat5NativeApi.msat_term_is_constant((Long)this.environment, pF)) : "Variables should be handled somewhere else";
        long decl = Mathsat5NativeApi.msat_term_get_decl(pF);
        int tag = Mathsat5NativeApi.msat_decl_get_tag((Long)this.environment, decl);
        switch (tag) {
            case 3: {
                return FunctionDeclarationKind.AND;
            }
            case 5: {
                return FunctionDeclarationKind.NOT;
            }
            case 4: {
                return FunctionDeclarationKind.OR;
            }
            case 6: {
                return FunctionDeclarationKind.IFF;
            }
            case 13: {
                return FunctionDeclarationKind.ITE;
            }
            case 8: {
                return FunctionDeclarationKind.MUL;
            }
            case 7: {
                return FunctionDeclarationKind.ADD;
            }
            case 11: {
                return FunctionDeclarationKind.LTE;
            }
            case 12: {
                return FunctionDeclarationKind.EQ;
            }
            case 41: {
                return FunctionDeclarationKind.SELECT;
            }
            case 42: {
                return FunctionDeclarationKind.STORE;
            }
            case 16: {
                return FunctionDeclarationKind.BV_EXTRACT;
            }
            case 15: {
                return FunctionDeclarationKind.BV_CONCAT;
            }
            case 17: {
                return FunctionDeclarationKind.BV_NOT;
            }
            case 26: {
                return FunctionDeclarationKind.BV_NEG;
            }
            case 18: {
                return FunctionDeclarationKind.BV_AND;
            }
            case 19: {
                return FunctionDeclarationKind.BV_OR;
            }
            case 20: {
                return FunctionDeclarationKind.BV_XOR;
            }
            case 21: {
                return FunctionDeclarationKind.BV_ULT;
            }
            case 22: {
                return FunctionDeclarationKind.BV_SLT;
            }
            case 23: {
                return FunctionDeclarationKind.BV_ULE;
            }
            case 24: {
                return FunctionDeclarationKind.BV_SLE;
            }
            case 27: {
                return FunctionDeclarationKind.BV_ADD;
            }
            case 28: {
                return FunctionDeclarationKind.BV_SUB;
            }
            case 29: {
                return FunctionDeclarationKind.BV_MUL;
            }
            case 30: {
                return FunctionDeclarationKind.BV_UDIV;
            }
            case 31: {
                return FunctionDeclarationKind.BV_SDIV;
            }
            case 32: {
                return FunctionDeclarationKind.BV_UREM;
            }
            case 33: {
                return FunctionDeclarationKind.BV_SREM;
            }
            case 34: {
                return FunctionDeclarationKind.BV_SHL;
            }
            case 35: {
                return FunctionDeclarationKind.BV_LSHR;
            }
            case 36: {
                return FunctionDeclarationKind.BV_ASHR;
            }
            case 40: {
                return FunctionDeclarationKind.BV_SIGN_EXTENSION;
            }
            case 39: {
                return FunctionDeclarationKind.BV_ZERO_EXTENSION;
            }
            case 47: {
                return FunctionDeclarationKind.FP_NEG;
            }
            case 53: {
                return FunctionDeclarationKind.FP_ABS;
            }
            case 55: {
                return FunctionDeclarationKind.FP_MAX;
            }
            case 54: {
                return FunctionDeclarationKind.FP_MIN;
            }
            case 52: {
                return FunctionDeclarationKind.FP_SQRT;
            }
            case 48: {
                return FunctionDeclarationKind.FP_ADD;
            }
            case 49: {
                return FunctionDeclarationKind.FP_SUB;
            }
            case 51: {
                return FunctionDeclarationKind.FP_DIV;
            }
            case 50: {
                return FunctionDeclarationKind.FP_MUL;
            }
            case 45: {
                return FunctionDeclarationKind.FP_LT;
            }
            case 46: {
                return FunctionDeclarationKind.FP_LE;
            }
            case 44: {
                return FunctionDeclarationKind.FP_EQ;
            }
            case 57: {
                return FunctionDeclarationKind.FP_ROUND_TO_INTEGRAL;
            }
            case 58: {
                return FunctionDeclarationKind.BV_SCASTTO_FP;
            }
            case 59: {
                return FunctionDeclarationKind.BV_UCASTTO_FP;
            }
            case 60: {
                return FunctionDeclarationKind.FP_CASTTO_SBV;
            }
            case 61: {
                return FunctionDeclarationKind.FP_AS_IEEEBV;
            }
            case 56: {
                return FunctionDeclarationKind.FP_CASTTO_FP;
            }
            case 62: {
                return FunctionDeclarationKind.FP_IS_NAN;
            }
            case 63: {
                return FunctionDeclarationKind.FP_IS_INF;
            }
            case 64: {
                return FunctionDeclarationKind.FP_IS_ZERO;
            }
            case 67: {
                return FunctionDeclarationKind.FP_IS_NEGATIVE;
            }
            case 65: {
                return FunctionDeclarationKind.FP_IS_SUBNORMAL;
            }
            case 66: {
                return FunctionDeclarationKind.FP_IS_NORMAL;
            }
            case 0: {
                switch (Mathsat5NativeApi.msat_decl_get_name(decl)) {
                    case "`fprounding_even`": {
                        return FunctionDeclarationKind.FP_ROUND_EVEN;
                    }
                    case "`fprounding_plus_inf`": {
                        return FunctionDeclarationKind.FP_ROUND_POSITIVE;
                    }
                    case "`fprounding_minus_inf`": {
                        return FunctionDeclarationKind.FP_ROUND_NEGATIVE;
                    }
                    case "`fprounding_zero`": {
                        return FunctionDeclarationKind.FP_ROUND_ZERO;
                    }
                }
                return FunctionDeclarationKind.OTHER;
            }
            case 10: {
                return FunctionDeclarationKind.FLOOR;
            }
        }
        return FunctionDeclarationKind.OTHER;
    }

    @Override
    public Object convertValue(Long key) {
        throw new UnsupportedOperationException("Mathsat needs a second term to determine a correct type. Please use the other method.");
    }

    @Override
    public Object convertValue(Long key, Long term) {
        FormulaType<?> type = this.getFormulaType(key);
        String repr = Mathsat5NativeApi.msat_term_repr(term);
        if (type.isBooleanType()) {
            return Mathsat5NativeApi.msat_term_is_true((Long)this.getEnv(), term);
        }
        if (type.isRationalType()) {
            return Rational.ofString((String)repr);
        }
        if (type.isIntegerType()) {
            return new BigInteger(repr);
        }
        if (type.isBitvectorType()) {
            return Mathsat5FormulaCreator.parseBitvector(repr);
        }
        if (type.isFloatingPointType()) {
            return this.parseFloatingPoint(repr);
        }
        throw new IllegalArgumentException("Unexpected type: " + type);
    }

    private Number parseFloatingPoint(String lTermRepresentation) {
        Matcher matcher = FLOATING_POINT_PATTERN.matcher(lTermRepresentation);
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown floating-point format: " + lTermRepresentation);
        }
        int expWidth = Integer.parseInt(matcher.group(2));
        int mantWidth = Integer.parseInt(matcher.group(3));
        if (expWidth == 11 && mantWidth == 52) {
            return Double.longBitsToDouble(UnsignedLong.valueOf((String)matcher.group(1)).longValue());
        }
        if (expWidth == 8 && mantWidth == 23) {
            return Float.valueOf(Float.intBitsToFloat(UnsignedInteger.valueOf((String)matcher.group(1)).intValue()));
        }
        return new BigInteger(matcher.group(1));
    }

    private static BigInteger parseBitvector(String lTermRepresentation) {
        Matcher matcher = BITVECTOR_PATTERN.matcher(lTermRepresentation);
        if (!matcher.matches()) {
            throw new NumberFormatException("Unknown bitvector format: " + lTermRepresentation);
        }
        String term = matcher.group(1);
        return new BigInteger(term);
    }

    @Override
    public Long declareUFImpl(String pName, Long returnType, List<Long> pArgTypes) {
        long[] types = Longs.toArray(pArgTypes);
        long msatFuncType = pArgTypes.isEmpty() ? returnType : Mathsat5NativeApi.msat_get_function_type((Long)this.environment, types, types.length, returnType);
        long decl = Mathsat5NativeApi.msat_declare_function((Long)this.environment, pName, msatFuncType);
        return decl;
    }

    @Override
    public Long callFunctionImpl(Long declaration, List<Long> args) {
        return Mathsat5NativeApi.msat_make_term((Long)this.environment, declaration, Longs.toArray(args));
    }

    @Override
    protected Long getBooleanVarDeclarationImpl(Long pLong) {
        return Mathsat5NativeApi.msat_term_get_decl(pLong);
    }
}

