/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import edu.nyu.acsys.CVC4.Expr;
import edu.nyu.acsys.CVC4.ExprManager;
import edu.nyu.acsys.CVC4.ExprManagerMapCollection;
import edu.nyu.acsys.CVC4.Result;
import edu.nyu.acsys.CVC4.SExpr;
import edu.nyu.acsys.CVC4.SmtEngine;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4FormulaCreator;
import org.sosy_lab.java_smt.solvers.cvc4.CVC4Model;

class CVC4TheoremProver
extends AbstractProverWithAllSat<Void>
implements ProverEnvironment,
BasicProverEnvironment<Void> {
    private final CVC4FormulaCreator creator;
    private SmtEngine smtEngine;
    private ShutdownHook hook;
    private boolean changedSinceLastSatQuery = false;
    protected final Deque<List<Expr>> assertedFormulas = new ArrayDeque<List<Expr>>();
    private final Set<CVC4Model> models = new LinkedHashSet<CVC4Model>();
    private final ExprManager exprManager = new ExprManager();
    private final ExprManagerMapCollection exportMapping = new ExprManagerMapCollection();
    private final boolean incremental;

    protected CVC4TheoremProver(CVC4FormulaCreator pFormulaCreator, ShutdownNotifier pShutdownNotifier, int randomSeed, Set<SolverContext.ProverOptions> pOptions, BooleanFormulaManager pBmgr) {
        super(pOptions, pBmgr, pShutdownNotifier);
        this.creator = pFormulaCreator;
        this.smtEngine = new SmtEngine(this.exprManager);
        this.incremental = !this.enableSL;
        this.assertedFormulas.push(new ArrayList());
        this.setOptions(randomSeed, pOptions);
        this.hook = this.registerShutdownHandler(pShutdownNotifier);
    }

    private void setOptions(int randomSeed, Set<SolverContext.ProverOptions> pOptions) {
        this.smtEngine.setOption("incremental", new SExpr(this.incremental));
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_MODELS)) {
            this.smtEngine.setOption("produce-models", new SExpr(true));
        }
        if (pOptions.contains((Object)SolverContext.ProverOptions.GENERATE_UNSAT_CORE)) {
            this.smtEngine.setOption("produce-unsat-cores", new SExpr(true));
        }
        this.smtEngine.setOption("produce-assertions", new SExpr(true));
        this.smtEngine.setOption("dump-models", new SExpr(true));
        this.smtEngine.setOption("output-language", new SExpr("smt2"));
        this.smtEngine.setOption("random-seed", new SExpr(randomSeed));
    }

    protected void setOptionForIncremental() {
        this.smtEngine.setOption("incremental", new SExpr(true));
    }

    private ShutdownHook registerShutdownHandler(ShutdownNotifier pShutdownNotifier) {
        ShutdownHook listener = new ShutdownHook();
        pShutdownNotifier.register((ShutdownNotifier.ShutdownRequestListener)listener);
        return listener;
    }

    protected Expr importExpr(Expr expr) {
        return expr.exportTo(this.exprManager, this.exportMapping);
    }

    protected Expr exportExpr(Expr expr) {
        return expr.exportTo((ExprManager)this.creator.getEnv(), this.exportMapping);
    }

    @Override
    public void push() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        this.assertedFormulas.push(new ArrayList());
        if (this.incremental) {
            this.smtEngine.push();
        }
    }

    @Override
    public void pop() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        this.assertedFormulas.pop();
        Preconditions.checkState((this.assertedFormulas.size() > 0 ? 1 : 0) != 0, (Object)"initial level must remain until close");
        if (this.incremental) {
            this.smtEngine.pop();
        }
    }

    @Override
    public @Nullable Void addConstraint(BooleanFormula pF) throws InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.setChanged();
        Expr exp = this.creator.extractInfo(pF);
        this.assertedFormulas.peek().add(exp);
        if (this.incremental) {
            this.smtEngine.assertFormula(this.importExpr(exp));
        }
        return null;
    }

    @Override
    public CVC4Model getModel() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateModels();
        return this.getModelWithoutChecks();
    }

    @Override
    protected CVC4Model getModelWithoutChecks() {
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        CVC4Model model = new CVC4Model(this, this.creator, this.smtEngine, this.getAssertedExpressions());
        this.models.add(model);
        return model;
    }

    void unregisterModel(CVC4Model model) {
        this.models.remove(model);
    }

    private void setChanged() {
        if (!this.changedSinceLastSatQuery) {
            this.changedSinceLastSatQuery = true;
            this.closeAllModels();
            if (!this.incremental) {
                this.shutdownNotifier.unregister((ShutdownNotifier.ShutdownRequestListener)this.hook);
                this.smtEngine = new SmtEngine(this.exprManager);
                this.hook = this.registerShutdownHandler(this.shutdownNotifier);
            }
        }
    }

    private void closeAllModels() {
        for (CVC4Model model : ImmutableList.copyOf(this.models)) {
            model.close();
        }
        Preconditions.checkState((boolean)this.models.isEmpty(), (Object)"all models should be closed");
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        try (CVC4Model model = this.getModel();){
            ImmutableList<Model.ValueAssignment> immutableList = model.toList();
            return immutableList;
        }
    }

    @Override
    public boolean isUnsat() throws InterruptedException, SolverException {
        Result result;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closeAllModels();
        this.changedSinceLastSatQuery = false;
        if (!this.incremental) {
            for (Expr expr : this.getAssertedExpressions()) {
                this.smtEngine.assertFormula(this.importExpr(expr));
            }
        }
        this.shutdownNotifier.shutdownIfNecessary();
        try {
            result = this.smtEngine.checkSat();
        }
        finally {
            this.hook.interrupted.set(false);
            this.shutdownNotifier.shutdownIfNecessary();
        }
        return this.convertSatResult(result);
    }

    private boolean convertSatResult(Result result) throws InterruptedException, SolverException {
        if (result.isUnknown()) {
            if (result.whyUnknown().equals(Result.UnknownExplanation.INTERRUPTED)) {
                throw new InterruptedException();
            }
            throw new SolverException("CVC4 returned null or unknown on sat check (" + result + ")");
        }
        if (result.isSat() == Result.Sat.SAT) {
            return false;
        }
        if (result.isSat() == Result.Sat.UNSAT) {
            return true;
        }
        throw new SolverException("CVC4 returned unknown on sat check");
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkGenerateUnsatCores();
        Preconditions.checkState((!this.changedSinceLastSatQuery ? 1 : 0) != 0);
        ArrayList<BooleanFormula> converted = new ArrayList<BooleanFormula>();
        for (Expr aCore : this.smtEngine.getUnsatCore()) {
            converted.add(this.creator.encapsulateBoolean(this.exportExpr(aCore)));
        }
        return converted;
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected Collection<Expr> getAssertedExpressions() {
        ArrayList<Expr> result = new ArrayList<Expr>();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closeAllModels();
            this.assertedFormulas.clear();
            this.exportMapping.delete();
            this.exprManager.delete();
            this.shutdownNotifier.unregister((ShutdownNotifier.ShutdownRequestListener)this.hook);
            this.closed = true;
        }
    }

    private final class ShutdownHook
    implements ShutdownNotifier.ShutdownRequestListener {
        private final AtomicBoolean interrupted = new AtomicBoolean(false);

        private ShutdownHook() {
        }

        public void shutdownRequested(String reason) {
            this.interrupted.set(true);
            while (this.interrupted.get()) {
                CVC4TheoremProver.this.smtEngine.interrupt();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

