/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.cvc4;

import com.google.errorprone.annotations.Immutable;
import edu.nyu.acsys.CVC4.Expr;
import org.sosy_lab.java_smt.api.ArrayFormula;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FloatingPointFormula;
import org.sosy_lab.java_smt.api.FloatingPointRoundingModeFormula;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

@Immutable
public class CVC4Formula
implements Formula {
    private final Expr cvc4term;

    CVC4Formula(Expr term) {
        this.cvc4term = term;
    }

    @Override
    public final String toString() {
        return this.cvc4term.toString();
    }

    @Override
    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CVC4Formula)) {
            return false;
        }
        return this.cvc4term.equals(((CVC4Formula)o).cvc4term);
    }

    @Override
    public final int hashCode() {
        return this.cvc4term.getId().intValue();
    }

    final Expr getTerm() {
        return this.cvc4term;
    }

    @Immutable
    static final class CVC4BooleanFormula
    extends CVC4Formula
    implements BooleanFormula {
        CVC4BooleanFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4RationalFormula
    extends CVC4Formula
    implements NumeralFormula.RationalFormula {
        CVC4RationalFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4IntegerFormula
    extends CVC4Formula
    implements NumeralFormula.IntegerFormula {
        CVC4IntegerFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4FloatingPointRoundingModeFormula
    extends CVC4Formula
    implements FloatingPointRoundingModeFormula {
        CVC4FloatingPointRoundingModeFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4FloatingPointFormula
    extends CVC4Formula
    implements FloatingPointFormula {
        CVC4FloatingPointFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4BitvectorFormula
    extends CVC4Formula
    implements BitvectorFormula {
        CVC4BitvectorFormula(Expr pTerm) {
            super(pTerm);
        }
    }

    @Immutable
    static final class CVC4ArrayFormula<TI extends Formula, TE extends Formula>
    extends CVC4Formula
    implements ArrayFormula<TI, TE> {
        private final FormulaType<TI> indexType;
        private final FormulaType<TE> elementType;

        CVC4ArrayFormula(Expr pTerm, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
            super(pTerm);
            this.indexType = pIndexType;
            this.elementType = pElementType;
        }

        public FormulaType<TI> getIndexType() {
            return this.indexType;
        }

        public FormulaType<TE> getElementType() {
            return this.elementType;
        }
    }
}

