/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.collect.ImmutableMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorSolverContext;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;
import org.sosy_lab.java_smt.solvers.boolector.BtorOption;

public class BoolectorNativeApiTest {
    private long btor;
    private static final ImmutableMap<String, String> ALLOWED_DIFFS = ImmutableMap.builder().put((Object)"BTOR_OPT_ACKERMANNIZE", (Object)"BTOR_OPT_ACKERMANN").put((Object)"BTOR_OPT_QUANT_DUAL", (Object)"BTOR_OPT_QUANT_DUAL_SOLVER").put((Object)"BTOR_OPT_QUANT_SYNTHLIMIT", (Object)"BTOR_OPT_QUANT_SYNTH_LIMIT").put((Object)"BTOR_OPT_QUANT_SYNTHQI", (Object)"BTOR_OPT_QUANT_SYNTH_QI").put((Object)"BTOR_OPT_QUANT_MS", (Object)"BTOR_OPT_QUANT_MINISCOPE").put((Object)"BTOR_OPT_DEFAULT_CADICAL", (Object)"BTOR_OPT_DEFAULT_TO_CADICAL").put((Object)"BTOR_OPT_QUANT_SYNTHCOMPLETE", (Object)"BTOR_OPT_QUANT_SYNTH_ITE_COMPLETE").build();

    @BeforeClass
    public static void load() {
        try {
            NativeLibraries.loadLibrary((String)"boolector");
        }
        catch (UnsatisfiedLinkError e) {
            throw new AssumptionViolatedException("Boolector is not available", (Throwable)e);
        }
    }

    @Before
    public void createEnvironment() {
        this.btor = BtorJNI.boolector_new();
    }

    @After
    public void freeEnvironment() {
        BtorJNI.boolector_delete(this.btor);
    }

    @Test
    public void optionNameTest() {
        for (BtorOption option : BtorOption.values()) {
            String optName = BtorJNI.boolector_get_opt_lng(this.btor, option.getValue());
            String converted = "BTOR_OPT_" + optName.replace("-", "_").replace(":", "_").toUpperCase();
            Assert.assertEquals((Object)option.name(), (Object)ALLOWED_DIFFS.getOrDefault((Object)converted, (Object)converted));
        }
    }

    @Test
    public void satSolverTest() {
        for (BoolectorSolverContext.SatSolver satSolver : BoolectorSolverContext.SatSolver.values()) {
            long btor1 = BtorJNI.boolector_new();
            BtorJNI.boolector_set_sat_solver(btor1, satSolver.name());
            long newVar = BtorJNI.boolector_var(btor1, BtorJNI.boolector_bool_sort(btor1), "x");
            BtorJNI.boolector_assert(btor1, newVar);
            int result = BtorJNI.boolector_sat(btor1);
            Assert.assertEquals((long)BtorJNI.BTOR_RESULT_SAT_get(), (long)result);
            BtorJNI.boolector_delete(btor1);
        }
    }
}

