/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.collect.Table;
import org.sosy_lab.java_smt.api.Formula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.basicimpl.AbstractArrayFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

public class BoolectorArrayFormulaManager
extends AbstractArrayFormulaManager<Long, Long, Long, Long> {
    private final long btor;
    private final Table<String, Long, Long> nameFormulaCache;

    BoolectorArrayFormulaManager(BoolectorFormulaCreator pCreator) {
        super(pCreator);
        this.btor = (Long)pCreator.getEnv();
        this.nameFormulaCache = pCreator.getCache();
    }

    @Override
    protected Long select(Long pArray, Long pIndex) {
        return BtorJNI.boolector_read(this.btor, pArray, pIndex);
    }

    @Override
    protected Long store(Long pArray, Long pIndex, Long pValue) {
        return BtorJNI.boolector_write(this.btor, pArray, pIndex, pValue);
    }

    @Override
    protected <TI extends Formula, TE extends Formula> Long internalMakeArray(String name, FormulaType<TI> pIndexType, FormulaType<TE> pElementType) {
        long elementSort;
        if (!pIndexType.isBitvectorType() || !pElementType.isBitvectorType()) {
            throw new IllegalArgumentException("Boolector supports bitvector arrays only.");
        }
        FormulaType.BitvectorType indexType = (FormulaType.BitvectorType)pIndexType;
        FormulaType.BitvectorType elementType = (FormulaType.BitvectorType)pElementType;
        long indexSort = BtorJNI.boolector_bitvec_sort(this.btor, indexType.getSize());
        long arraySort = BtorJNI.boolector_array_sort(this.btor, indexSort, elementSort = BtorJNI.boolector_bitvec_sort(this.btor, elementType.getSize()));
        Long maybeFormula = (Long)this.nameFormulaCache.get((Object)name, (Object)arraySort);
        if (maybeFormula != null) {
            return maybeFormula;
        }
        if (this.nameFormulaCache.containsRow((Object)name)) {
            throw new IllegalArgumentException("Symbol already used: " + name);
        }
        long array = BtorJNI.boolector_array(this.btor, arraySort, name);
        this.nameFormulaCache.put((Object)name, (Object)arraySort, (Object)array);
        return array;
    }

    @Override
    protected Long equivalence(Long pArray1, Long pArray2) {
        return BtorJNI.boolector_eq(this.btor, pArray1, pArray2);
    }
}

