/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.solvers.boolector;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;
import org.sosy_lab.java_smt.basicimpl.AbstractProverWithAllSat;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaCreator;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorFormulaManager;
import org.sosy_lab.java_smt.solvers.boolector.BoolectorModel;
import org.sosy_lab.java_smt.solvers.boolector.BtorJNI;

abstract class BoolectorAbstractProver<T>
extends AbstractProverWithAllSat<T> {
    private final long btor;
    private final BoolectorFormulaManager manager;
    private final BoolectorFormulaCreator creator;
    protected final Deque<List<Long>> assertedFormulas = new ArrayDeque<List<Long>>();
    protected boolean wasLastSatCheckSat = false;

    protected BoolectorAbstractProver(BoolectorFormulaManager manager, BoolectorFormulaCreator creator, long btor, ShutdownNotifier pShutdownNotifier, Set<SolverContext.ProverOptions> pOptions) {
        super(pOptions, manager.getBooleanFormulaManager(), pShutdownNotifier);
        this.manager = manager;
        this.creator = creator;
        this.btor = btor;
    }

    @Override
    public void close() {
        if (!this.closed) {
            BtorJNI.boolector_pop((Long)this.manager.getEnvironment(), this.assertedFormulas.size());
            this.assertedFormulas.clear();
            this.closed = true;
        }
    }

    @Override
    public boolean isUnsat() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.wasLastSatCheckSat = false;
        int result = BtorJNI.boolector_sat(this.btor);
        if (result == BtorJNI.BTOR_RESULT_SAT_get()) {
            this.wasLastSatCheckSat = true;
            return false;
        }
        if (result == BtorJNI.BTOR_RESULT_UNSAT_get()) {
            return true;
        }
        if (result == BtorJNI.BTOR_RESULT_UNKNOWN_get()) {
            throw new SolverException("Boolector encountered a problem or ran out of stack or heap memory, try increasing their sizes.");
        }
        throw new SolverException("Boolector sat call returned " + result);
    }

    @Override
    public void pop() {
        this.assertedFormulas.pop();
        BtorJNI.boolector_pop((Long)this.manager.getEnvironment(), 1L);
    }

    @Override
    public void push() {
        this.assertedFormulas.push(new ArrayList());
        BtorJNI.boolector_push((Long)this.manager.getEnvironment(), 1L);
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        for (BooleanFormula assumption : pAssumptions) {
            BtorJNI.boolector_assume(this.btor, BoolectorFormulaManager.getBtorTerm(assumption));
        }
        return this.isUnsat();
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.wasLastSatCheckSat, (Object)"Model computation failed. Are the pushed formulae satisfiable?");
        this.checkGenerateModels();
        return this.getModelWithoutChecks();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        throw new UnsupportedOperationException("Unsat core is not supported by Boolector.");
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        throw new UnsupportedOperationException("Unsat core with assumptions is not supported by Boolector.");
    }

    @Override
    protected Model getModelWithoutChecks() {
        return new BoolectorModel(this.btor, this.creator, this, this.getAssertedTerms());
    }

    @Override
    public @Nullable T addConstraint(BooleanFormula constraint) {
        BtorJNI.boolector_assert((Long)this.manager.getEnvironment(), BoolectorFormulaManager.getBtorTerm(constraint));
        this.assertedFormulas.peek().add(BoolectorFormulaManager.getBtorTerm(constraint));
        return null;
    }

    protected Collection<Long> getAssertedTerms() {
        ArrayList<Long> result = new ArrayList<Long>();
        this.assertedFormulas.forEach(result::addAll);
        return result;
    }

    protected boolean isClosed() {
        return this.closed;
    }
}

