/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.example;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.IntegerFormulaManager;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.NumeralFormula;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.api.SolverException;

public class MaximizeCo2 {
    public static void main(String ... args) throws InvalidConfigurationException, SolverException, InterruptedException {
        Configuration config = Configuration.defaultConfiguration();
        LogManager logger = BasicLogManager.create((Configuration)config);
        ShutdownNotifier notifier = ShutdownNotifier.createDummy();
        SolverContextFactory.Solvers solver = SolverContextFactory.Solvers.Z3;
        try (SolverContext context = SolverContextFactory.createSolverContext(config, logger, notifier, solver);
             OptimizationProverEnvironment prover = context.newOptimizationProverEnvironment(SolverContext.ProverOptions.GENERATE_MODELS);){
            BooleanFormulaManager bfmgr = context.getFormulaManager().getBooleanFormulaManager();
            IntegerFormulaManager ifmgr = context.getFormulaManager().getIntegerFormulaManager();
            List<List<Model.ValueAssignment>> models = MaximizeCo2.computeCo2(bfmgr, ifmgr, prover);
            logger.log(Level.INFO, new Object[]{Joiner.on((String)"\n").join(models)});
        }
    }

    private static List<List<Model.ValueAssignment>> computeCo2(BooleanFormulaManager bfmgr, IntegerFormulaManager ifmgr, OptimizationProverEnvironment prover) throws InterruptedException, SolverException {
        NumeralFormula.IntegerFormula co2 = (NumeralFormula.IntegerFormula)ifmgr.makeVariable("co2");
        NumeralFormula.IntegerFormula thousand = (NumeralFormula.IntegerFormula)ifmgr.makeNumber(1000L);
        BooleanFormula fan = bfmgr.makeVariable("fan");
        prover.addConstraint(ifmgr.lessOrEquals(co2, thousand));
        prover.addConstraint(bfmgr.implication(ifmgr.greaterThan(co2, thousand), fan));
        prover.addConstraint(bfmgr.not(fan));
        ArrayList<List<Model.ValueAssignment>> models = new ArrayList<List<Model.ValueAssignment>>();
        int iterations = 0;
        int handle = prover.maximize(co2);
        while (prover.check() != OptimizationProverEnvironment.OptStatus.UNSAT && iterations++ <= 5) {
            ImmutableList<Model.ValueAssignment> modelAssignments = prover.getModelAssignments();
            models.add((List<Model.ValueAssignment>)modelAssignments);
            prover.addConstraint(bfmgr.not(bfmgr.and(MaximizeCo2.asFormula(modelAssignments))));
        }
        return models;
    }

    private static List<BooleanFormula> asFormula(ImmutableList<Model.ValueAssignment> modelAssignments) {
        ArrayList<BooleanFormula> modelAssignmentsAsFormulas = new ArrayList<BooleanFormula>();
        for (Model.ValueAssignment va : modelAssignments) {
            modelAssignmentsAsFormulas.add(va.getAssignmentAsFormula());
        }
        return modelAssignmentsAsFormulas;
    }
}

