/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl.reusableStack;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.java_smt.api.BasicProverEnvironment;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Model;
import org.sosy_lab.java_smt.api.SolverException;

abstract class ReusableStackAbstractProver<T, D extends BasicProverEnvironment<T>>
implements BasicProverEnvironment<T> {
    D delegate;
    private int size;

    ReusableStackAbstractProver(D pDelegate) {
        this.delegate = (BasicProverEnvironment)Preconditions.checkNotNull(pDelegate);
        this.delegate.push();
        ++this.size;
    }

    @Override
    public boolean isUnsat() throws SolverException, InterruptedException {
        Preconditions.checkState((this.size >= 1 ? 1 : 0) != 0);
        return this.delegate.isUnsat();
    }

    @Override
    public boolean isUnsatWithAssumptions(Collection<BooleanFormula> pAssumptions) throws SolverException, InterruptedException {
        return this.delegate.isUnsatWithAssumptions(pAssumptions);
    }

    @Override
    public final void push() {
        ++this.size;
        this.delegate.push();
    }

    @Override
    public void pop() {
        Preconditions.checkState((this.size > 1 ? 1 : 0) != 0);
        --this.size;
        this.delegate.pop();
    }

    @Override
    public T addConstraint(BooleanFormula pConstraint) throws InterruptedException {
        return this.delegate.addConstraint(pConstraint);
    }

    @Override
    public Model getModel() throws SolverException {
        Preconditions.checkState((this.size >= 1 ? 1 : 0) != 0);
        return this.delegate.getModel();
    }

    @Override
    public ImmutableList<Model.ValueAssignment> getModelAssignments() throws SolverException {
        Preconditions.checkState((this.size >= 1 ? 1 : 0) != 0);
        return this.delegate.getModelAssignments();
    }

    @Override
    public List<BooleanFormula> getUnsatCore() {
        return this.delegate.getUnsatCore();
    }

    @Override
    public Optional<List<BooleanFormula>> unsatCoreOverAssumptions(Collection<BooleanFormula> assumptions) throws SolverException, InterruptedException {
        return this.delegate.unsatCoreOverAssumptions(assumptions);
    }

    @Override
    public void close() {
        while (this.size > 1) {
            this.pop();
        }
        if (this.size == 1) {
            this.delegate.pop();
            --this.size;
            this.delegate.close();
        } else {
            Preconditions.checkState((this.size == 0 ? 1 : 0) != 0);
        }
    }

    @Override
    public <R> R allSat(BasicProverEnvironment.AllSatCallback<R> callback, List<BooleanFormula> important) throws InterruptedException, SolverException {
        return this.delegate.allSat(callback, important);
    }
}

