/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.java_smt.basicimpl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.sosy_lab.java_smt.api.FormulaManager;
import org.sosy_lab.java_smt.api.InterpolatingProverEnvironment;
import org.sosy_lab.java_smt.api.OptimizationProverEnvironment;
import org.sosy_lab.java_smt.api.ProverEnvironment;
import org.sosy_lab.java_smt.api.SolverContext;
import org.sosy_lab.java_smt.basicimpl.withAssumptionsWrapper.InterpolatingProverWithAssumptionsWrapper;
import org.sosy_lab.java_smt.basicimpl.withAssumptionsWrapper.ProverWithAssumptionsWrapper;

public abstract class AbstractSolverContext
implements SolverContext {
    private final FormulaManager fmgr;

    protected AbstractSolverContext(FormulaManager fmgr) {
        this.fmgr = fmgr;
    }

    @Override
    public final FormulaManager getFormulaManager() {
        return this.fmgr;
    }

    @Override
    public final ProverEnvironment newProverEnvironment(SolverContext.ProverOptions ... options) {
        ProverEnvironment out = this.newProverEnvironment0(AbstractSolverContext.toSet(options));
        if (!this.supportsAssumptionSolving()) {
            out = new ProverWithAssumptionsWrapper(out);
        }
        return out;
    }

    protected abstract ProverEnvironment newProverEnvironment0(Set<SolverContext.ProverOptions> var1);

    @Override
    public final InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation(SolverContext.ProverOptions ... options) {
        InterpolatingProverEnvironment<?> out = this.newProverEnvironmentWithInterpolation0(AbstractSolverContext.toSet(options));
        if (!this.supportsAssumptionSolving()) {
            out = new InterpolatingProverWithAssumptionsWrapper(out, this.fmgr);
        }
        return out;
    }

    protected abstract InterpolatingProverEnvironment<?> newProverEnvironmentWithInterpolation0(Set<SolverContext.ProverOptions> var1);

    @Override
    public final OptimizationProverEnvironment newOptimizationProverEnvironment(SolverContext.ProverOptions ... options) {
        return this.newOptimizationProverEnvironment0(AbstractSolverContext.toSet(options));
    }

    protected abstract OptimizationProverEnvironment newOptimizationProverEnvironment0(Set<SolverContext.ProverOptions> var1);

    protected abstract boolean supportsAssumptionSolving();

    private static Set<SolverContext.ProverOptions> toSet(SolverContext.ProverOptions ... options) {
        EnumSet<SolverContext.ProverOptions> opts = EnumSet.noneOf(SolverContext.ProverOptions.class);
        Collections.addAll(opts, options);
        return opts;
    }
}

